/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.ws.impl;

import com.microsoft.azure.proton.transport.ws.WebSocketHandler;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketUpgrade;
import java.io.ByteArrayOutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;

public class WebSocketHandlerImpl
implements WebSocketHandler {
    private WebSocketUpgrade webSocketUpgrade = null;

    @Override
    public String createUpgradeRequest(String hostName, String webSocketPath, String webSocketQuery, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        this.webSocketUpgrade = this.createWebSocketUpgrade(hostName, webSocketPath, webSocketQuery, webSocketPort, webSocketProtocol, additionalHeaders);
        return this.webSocketUpgrade.createUpgradeRequest();
    }

    @Override
    public void createPong(ByteBuffer ping, ByteBuffer pong) {
        if (ping == null || pong == null) {
            throw new IllegalArgumentException("input parameter cannot be null");
        }
        if (ping.capacity() > pong.capacity()) {
            throw new IllegalArgumentException("insufficient output buffer size");
        }
        if (ping.remaining() > 0) {
            byte[] buffer = ping.array();
            buffer[0] = -118;
            pong.clear();
            pong.put(buffer);
        } else {
            pong.clear();
            pong.limit(0);
        }
    }

    @Override
    public Boolean validateUpgradeReply(ByteBuffer buffer) {
        int size;
        Boolean retVal = false;
        if (this.webSocketUpgrade != null && (size = buffer.remaining()) > 0) {
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            retVal = this.webSocketUpgrade.validateUpgradeReply(data);
            this.webSocketUpgrade = null;
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void wrapBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer) {
        if (srcBuffer == null || dstBuffer == null) {
            throw new IllegalArgumentException("input parameter is null");
        }
        if (srcBuffer.remaining() > 0) {
            byte[] maskingKey = this.createRandomMaskingKey();
            int dataLength = srcBuffer.remaining();
            ByteArrayOutputStream webSocketFrame = new ByteArrayOutputStream(6 + dataLength);
            int firstByte = -126;
            webSocketFrame.write(firstByte);
            int secondByte = -128;
            if (dataLength <= 125) {
                secondByte = (byte)(secondByte | dataLength);
                webSocketFrame.write(secondByte);
            } else if (dataLength <= 65535) {
                secondByte = (byte)(secondByte | 0x7E);
                webSocketFrame.write(secondByte);
                webSocketFrame.write((byte)(dataLength >>> 8));
                webSocketFrame.write((byte)dataLength);
            } else {
                secondByte = (byte)(secondByte | 0x7F);
                webSocketFrame.write(secondByte);
                webSocketFrame.write((byte)(dataLength >>> 56));
                webSocketFrame.write((byte)(dataLength >>> 48));
                webSocketFrame.write((byte)(dataLength >>> 40));
                webSocketFrame.write((byte)(dataLength >>> 32));
                webSocketFrame.write((byte)(dataLength >>> 24));
                webSocketFrame.write((byte)(dataLength >>> 16));
                webSocketFrame.write((byte)(dataLength >>> 8));
                webSocketFrame.write((byte)dataLength);
            }
            webSocketFrame.write(maskingKey[0]);
            webSocketFrame.write(maskingKey[1]);
            webSocketFrame.write(maskingKey[2]);
            webSocketFrame.write(maskingKey[3]);
            for (int i = 0; i < dataLength; ++i) {
                byte nextByte = srcBuffer.get();
                nextByte = (byte)(nextByte ^ maskingKey[i % 4]);
                webSocketFrame.write(nextByte);
            }
            dstBuffer.clear();
            if (dstBuffer.capacity() < webSocketFrame.size()) throw new OutOfMemoryError("insufficient output buffer size");
            dstBuffer.put(webSocketFrame.toByteArray());
            return;
        } else {
            dstBuffer.clear();
        }
    }

    @Override
    public WebSocketHandler.WebsocketTuple unwrapBuffer(ByteBuffer srcBuffer) {
        WebSocketHandler.WebsocketTuple result = new WebSocketHandler.WebsocketTuple(0L, WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN);
        if (srcBuffer == null) {
            throw new IllegalArgumentException("input parameter is null");
        }
        WebSocketHandler.WebSocketMessageType retVal = WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN;
        if (srcBuffer.remaining() > 2) {
            byte firstByte = srcBuffer.get();
            byte opcode = (byte)(firstByte & 0xF);
            byte secondByte = srcBuffer.get();
            byte maskBit = (byte)(secondByte & 0xFFFFFF80);
            byte payloadLength = (byte)(secondByte & 0x7F);
            long finalPayloadLength = -1L;
            if (payloadLength <= 125) {
                finalPayloadLength = payloadLength;
            } else if (payloadLength == 126) {
                try {
                    finalPayloadLength = srcBuffer.getShort() & 0xFFFF;
                }
                catch (BufferUnderflowException e) {
                    retVal = WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_HEADER_CHUNK;
                }
            } else if (payloadLength == 127) {
                try {
                    finalPayloadLength = srcBuffer.getLong();
                }
                catch (BufferUnderflowException e) {
                    retVal = WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_HEADER_CHUNK;
                }
            }
            if (retVal == WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN) {
                retVal = opcode == 2 ? WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_AMQP : (opcode == 9 ? WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_PING : (opcode == 8 ? WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_CLOSE : (opcode == 0 ? WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_CHUNK : WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN)));
            }
            result.setLength(finalPayloadLength);
            result.setType(retVal);
        }
        return result;
    }

    protected WebSocketUpgrade createWebSocketUpgrade(String hostName, String webSocketPath, String webSocketQuery, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        return new WebSocketUpgrade(hostName, webSocketPath, webSocketQuery, webSocketPort, webSocketProtocol, additionalHeaders);
    }

    protected byte[] createRandomMaskingKey() {
        byte[] maskingKey = new byte[4];
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(maskingKey);
        return maskingKey;
    }

    @Override
    public int calculateHeaderSize(int payloadSize) {
        int retVal = 0;
        if (payloadSize > 0) {
            retVal = payloadSize <= 125 ? 6 : (payloadSize <= 65535 ? 8 : 14);
        }
        return retVal;
    }
}

