/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ProfilingCachingCallSite
extends CachingCallSite {
    public static final Logger LOG = LoggerFactory.getLogger(ProfilingCachingCallSite.class);
    private volatile int totalMonomorphicCalls = 0;
    private final IRScope hostScope;
    private final long callSiteId;

    public ProfilingCachingCallSite(String methodName, IRScope scope, long callSiteId) {
        super(methodName, CallType.NORMAL);
        this.hostScope = scope;
        this.callSiteId = callSiteId;
    }

    private void inlineCheck(ThreadContext context, IRubyObject self2, CacheEntry cache) {
        AbstractIRMethod targetMethod;
        boolean siteIsIR;
        if (!this.hostScope.inliningAllowed()) {
            return;
        }
        boolean targetIsIR = cache.method instanceof AbstractIRMethod;
        boolean bl = siteIsIR = this.hostScope.compilable != null;
        if (!targetIsIR) {
            if (self2 instanceof RubyFixnum && "times".equals(this.methodName)) {
                targetIsIR = true;
                targetMethod = new MixedModeIRMethod(context.runtime.getIRManager().loadInternalMethod(context, self2, "times"), cache.method.getVisibility(), cache.method.getImplementationClass());
            } else {
                targetMethod = null;
            }
        } else {
            targetMethod = (AbstractIRMethod)cache.method;
        }
        if (targetIsIR && siteIsIR) {
            AbstractIRMethod hostMethod;
            IRMethod scopeToInline = (IRMethod)targetMethod.getIRScope();
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("PROFILE: " + this.hostScope + " -> " + scopeToInline + " - " + this.totalMonomorphicCalls, new Object[0]);
            }
            if ((hostMethod = (AbstractIRMethod)((Object)this.hostScope.compilable)) instanceof InterpretedIRMethod) {
                this.hostScope.inlineMethod(scopeToInline, this.callSiteId, cache.token, false);
            } else if (hostMethod instanceof MixedModeIRMethod) {
                this.hostScope.inlineMethodJIT(scopeToInline, this.callSiteId, cache.token, false);
            } else {
                this.hostScope.inlineMethodCompiled(scopeToInline, this.callSiteId, cache.token, false);
            }
        }
    }

    @Override
    protected boolean methodMissing(DynamicMethod method2, IRubyObject caller2) {
        return method2.isUndefined() || !this.methodName.equals("method_missing") && !method2.isCallableFrom(caller2, this.callType);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, long fixnum) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFixnum.newFixnum(context.runtime, fixnum));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, double flote) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFloat.newFloat(context.runtime, flote));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject ... args2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, args2);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, args2, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, args2, block);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, block, args2, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, block);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, block, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, context, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, block);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, context, self2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, block);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, arg3);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, context, self2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = ProfilingCachingCallSite.getClass(self2);
        if (cache.typeOk(selfType)) {
            if (this.totalMonomorphicCalls++ % IRManager.IR_INLINER_THRESHOLD == 0) {
                this.inlineCheck(context, self2, cache);
            }
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, arg3, block);
        }
        this.totalMonomorphicCalls = 1;
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1, arg2, arg3);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, args2, block);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, args2, block);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, args2);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, args2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, block);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, block);
    }

    @Override
    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg2);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg2, block);
    }

    @Override
    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, block);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, arg3);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, arg3);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, arg3, block);
        }
        this.cache = entry;
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, arg3, block);
    }
}

