/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.CommandLineParser;

public class CommandLineParserImpl
implements CommandLineParser {
    String[] argv;
    String[] validSwitches;
    String[] reqSwitches;
    String[] argSwitches;
    char switch_char;

    public CommandLineParserImpl(String[] argv, String[] validSwitches, String[] reqSwitches, String[] argSwitches, char switch_char) {
        this.argv = argv;
        this.validSwitches = validSwitches == null ? new String[]{} : validSwitches;
        this.reqSwitches = reqSwitches == null ? new String[]{} : reqSwitches;
        this.argSwitches = argSwitches == null ? new String[]{} : argSwitches;
        this.switch_char = switch_char;
    }

    public CommandLineParserImpl(String[] argv, String[] validSwitches, String[] reqSwitches, String[] argSwitches) {
        this(argv, validSwitches, reqSwitches, argSwitches, '-');
    }

    public boolean checkSwitch(String sw) {
        for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].charAt(0) != this.switch_char || !this.argv[i].equals(this.switch_char + sw)) continue;
            return true;
        }
        return false;
    }

    public String findSwitchArg(String sw) {
        for (int i = 0; i < this.argv.length - 1; ++i) {
            if (this.argv[i].charAt(0) != this.switch_char || !this.argv[i].equals(this.switch_char + sw)) continue;
            return this.argv[i + 1].charAt(0) == this.switch_char ? null : this.argv[i + 1];
        }
        return null;
    }

    public boolean checkArgv() {
        return this.checkValidSwitches() && this.checkRequiredSwitches() && this.checkSwitchArgSyntax();
    }

    boolean checkValidSwitches() {
        block0: for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].charAt(0) != this.switch_char) continue;
            for (int j = 0; j < this.validSwitches.length; ++j) {
                if (this.argv[i].equals(this.switch_char + this.validSwitches[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    boolean checkRequiredSwitches() {
        int i = this.reqSwitches.length;
        while (--i >= 0) {
            if (this.checkSwitch(this.reqSwitches[i])) continue;
            return false;
        }
        return true;
    }

    boolean checkSwitchArgSyntax() {
        int i = this.argSwitches.length;
        while (--i >= 0) {
            String check;
            if (!this.checkSwitch(this.argSwitches[i]) || (check = this.findSwitchArg(this.argSwitches[i])) != null && check.charAt(0) != this.switch_char) continue;
            return false;
        }
        return true;
    }

    public int findLastSwitched() {
        int i = this.argv.length;
        while (--i >= 0) {
            if (this.argv[i].charAt(0) != this.switch_char) continue;
            return i;
        }
        return -1;
    }

    public String[] findUnswitchedArgs() {
        String[] bigArray = new String[this.argv.length];
        int count = 0;
        for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].charAt(0) == this.switch_char) {
                if (!CommandLineParserImpl.contains(this.argv[i].substring(1), this.argSwitches)) continue;
                ++i;
                continue;
            }
            bigArray[count++] = this.argv[i];
        }
        String[] out = new String[count];
        System.arraycopy(bigArray, 0, out, 0, count);
        return out;
    }

    private static boolean contains(String string, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!list[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

