/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script.helper;

import java.util.List;
import java.util.Map;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticBinaryResult;
import onl.netfishers.netshot.diagnostic.DiagnosticNumericResult;
import onl.netfishers.netshot.work.TaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDiagnosticHelper {
    private static Logger logger = LoggerFactory.getLogger(JsDiagnosticHelper.class);
    private final Device device;
    private List<Diagnostic> diagnostics;
    private Map<String, Object> jsDiagnostics;
    private TaskLogger taskLogger;

    public JsDiagnosticHelper(Device device, List<Diagnostic> diagnostics, Map<String, Object> jsDiagnostics, TaskLogger taskLogger) {
        this.device = device;
        this.diagnostics = diagnostics;
        this.jsDiagnostics = jsDiagnostics;
        this.taskLogger = taskLogger;
    }

    public void set(String key, Double value) {
        if (value == null) {
            return;
        }
        try {
            for (Diagnostic diagnostic : this.diagnostics) {
                if (!diagnostic.getName().equals(key)) continue;
                switch (diagnostic.getResultType()) {
                    case NUMERIC: {
                        this.device.addDiagnosticResult(new DiagnosticNumericResult(this.device, diagnostic, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error while setting the numeric diagnostic result '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't set numeric diagnostic result %s: %s", key, e.getMessage()));
        }
    }

    public void set(String key, Boolean value) {
        if (value == null) {
            return;
        }
        try {
            for (Diagnostic diagnostic : this.diagnostics) {
                if (!diagnostic.getName().equals(key)) continue;
                switch (diagnostic.getResultType()) {
                    case BINARY: {
                        this.device.addDiagnosticResult(new DiagnosticBinaryResult(this.device, diagnostic, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error while setting the boolean diagnostic result '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't set boolean diagnostic result %s: %s", key, e.getMessage()));
        }
    }

    public void set(String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            for (Diagnostic diagnostic : this.diagnostics) {
                if (!diagnostic.getName().equals(key)) continue;
                diagnostic.addResultToDevice(this.device, (String)value);
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error while setting the diagnostic result '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't set diagnostic result %s: %s", key, e.toString()));
        }
    }

    public Map<String, Object> getJsDiagnostics() {
        return this.jsDiagnostics;
    }
}

