/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.ConvertDoubleStreamFunction;
import org.apache.solr.analytics.function.mapping.ConvertDoubleValueFunction;
import org.apache.solr.analytics.function.mapping.ConvertFloatStreamFunction;
import org.apache.solr.analytics.function.mapping.ConvertFloatValueFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class DecimalNumericConversionFunction {
    public static LongValueStream createDecimalConversionFunction(String name, ConvertFloatFunction fconv, ConvertDoubleFunction dconv, AnalyticsValueStream ... params) {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires 1 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof LongValueStream) {
            return (LongValueStream)param;
        }
        if (param instanceof FloatValueStream) {
            if (param instanceof FloatValue) {
                return new ConvertFloatValueFunction(name, (FloatValue)param, fconv);
            }
            return new ConvertFloatStreamFunction(name, (FloatValueStream)param, fconv);
        }
        if (param instanceof DoubleValueStream) {
            if (param instanceof DoubleValue) {
                return new ConvertDoubleValueFunction(name, (DoubleValue)param, dconv);
            }
            return new ConvertDoubleStreamFunction(name, (DoubleValueStream)param, dconv);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires a numeric parameter.");
    }

    @FunctionalInterface
    public static interface ConvertDoubleFunction {
        public long convert(double var1);
    }

    @FunctionalInterface
    public static interface ConvertFloatFunction {
        public int convert(float var1);
    }

    public static class RoundFunction {
        public static final String name = "round";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> Math.round(val), val -> Math.round(val), params);
    }

    public static class CeilingFunction {
        public static final String name = "ceil";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> (int)Math.ceil(val), val -> (long)Math.ceil(val), params);
    }

    public static class FloorFunction {
        public static final String name = "floor";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> (int)Math.floor(val), val -> (long)Math.floor(val), params);
    }
}

