/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetLongMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UniqueAgg;
import org.apache.solr.search.facet.UniqueSinglevaluedSlotAcc;

public abstract class UniqueBlockAgg
extends UniqueAgg {
    private static final String uniqueBlock = "uniqueBlock";

    public UniqueBlockAgg(String field) {
        super(field);
        this.name = uniqueBlock;
    }

    @Override
    public abstract SlotAcc createSlotAcc(FacetContext var1, int var2, int var3) throws IOException;

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetLongMerger();
    }

    protected static class UniqueBlockSlotAcc
    extends UniqueSinglevaluedSlotAcc {
        protected int[] lastSeenValuesPerSlot;

        protected UniqueBlockSlotAcc(FacetContext fcontext, SchemaField field, int numSlots) throws IOException {
            super(fcontext, field, 0, null);
            this.counts = new int[numSlots];
            this.lastSeenValuesPerSlot = new int[numSlots];
            Arrays.fill(this.lastSeenValuesPerSlot, Integer.MIN_VALUE);
        }

        @Override
        protected void collectOrdToSlot(int slotNum, int ord) {
            if (this.lastSeenValuesPerSlot[slotNum] != ord) {
                int n = slotNum;
                this.counts[n] = this.counts[n] + 1;
                this.lastSeenValuesPerSlot[slotNum] = ord;
            }
        }

        @Override
        public void calcCounts() {
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.lastSeenValuesPerSlot, Integer.MIN_VALUE);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.lastSeenValuesPerSlot = resizer.resize(this.lastSeenValuesPerSlot, Integer.MIN_VALUE);
            super.resize(resizer);
        }

        @Override
        public Object getValue(int slot) throws IOException {
            return this.counts[slot];
        }
    }
}

