/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.HttpClient;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.Package;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.PackageStoreAPI;
import org.apache.solr.pkg.PackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageAPI {
    public static final String PACKAGES = "packages";
    public final boolean enablePackages = Boolean.parseBoolean(System.getProperty("enable.packages", "false"));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ERR_MSG = "Package loading is not enabled , Start your nodes with -Denable.packages=true";
    final CoreContainer coreContainer;
    private final ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();
    private final PackageLoader packageLoader;
    Packages pkgs;
    public final Edit editAPI = new Edit();
    public final Read readAPI = new Read();

    public PackageAPI(CoreContainer coreContainer, PackageLoader loader) {
        this.coreContainer = coreContainer;
        this.packageLoader = loader;
        this.pkgs = new Packages();
        SolrZkClient zkClient = coreContainer.getZkController().getZkClient();
        try {
            this.pkgs = this.readPkgsFromZk(null, null);
        }
        catch (InterruptedException | KeeperException e) {
            this.pkgs = new Packages();
        }
        try {
            this.registerListener(zkClient);
        }
        catch (InterruptedException | KeeperException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
        }
    }

    private void registerListener(final SolrZkClient zkClient) throws KeeperException, InterruptedException {
        final String path = "/packages.json";
        zkClient.exists(path, new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    return;
                }
                try {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        log.debug("Updating [{}] ... ", (Object)path);
                        1 thisWatch = this;
                        Stat stat = new Stat();
                        byte[] data = zkClient.getData(path, (Watcher)thisWatch, stat, true);
                        PackageAPI.this.pkgs = PackageAPI.this.readPkgsFromZk(data, stat);
                        PackageAPI.this.packageLoader.refreshPackageConf();
                    }
                }
                catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                    log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
                }
                catch (KeeperException e) {
                    log.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted", (Throwable)e);
                }
            }
        }, true);
    }

    private Packages readPkgsFromZk(byte[] data, Stat stat) throws KeeperException, InterruptedException {
        if (data == null || stat == null) {
            stat = new Stat();
            data = this.coreContainer.getZkController().getZkClient().getData("/packages.json", null, stat, true);
        }
        Packages packages = null;
        if (data == null || data.length == 0) {
            packages = new Packages();
        } else {
            try {
                packages = (Packages)this.mapper.readValue(data, Packages.class);
                packages.znodeVersion = stat.getVersion();
            }
            catch (IOException e) {
                return new Packages();
            }
        }
        return packages;
    }

    public boolean isEnabled() {
        return this.enablePackages;
    }

    private boolean checkEnabled(CommandOperation payload) {
        if (!this.enablePackages) {
            payload.addError(ERR_MSG);
            return false;
        }
        return true;
    }

    void notifyAllNodesToSync(int expected) {
        for (String s : this.coreContainer.getPackageStoreAPI().shuffledNodes()) {
            Utils.executeGET((HttpClient)this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(this.coreContainer.getZkController().zkStateReader.getBaseUrlForNodeName(s).replace("/solr", "/api") + "/cluster/package?wt=javabin&omitHeader=true&expectedVersion" + expected), (Utils.InputStreamConsumer)Utils.JAVABINCONSUMER);
        }
    }

    public void handleZkErr(Exception e) {
        log.error("Error reading package config from zookeeper", SolrZkClient.checkInterrupted((Throwable)e));
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/package/", "/cluster/package/{name}"}, permission=PermissionNameProvider.Name.PACKAGE_READ_PERM)
    public class Read {
        @Command
        public void get(SolrQueryRequest req, SolrQueryResponse rsp) {
            String name;
            String refresh = req.getParams().get("refreshPackage");
            if (refresh != null) {
                PackageAPI.this.packageLoader.notifyListeners(refresh);
                return;
            }
            int expectedVersion = req.getParams().getInt("expectedVersion", -1);
            if (expectedVersion != -1) {
                this.syncToVersion(expectedVersion);
            }
            if ((name = req.getPathTemplateValues().get("name")) == null) {
                rsp.add("result", PackageAPI.this.pkgs);
            } else {
                rsp.add("result", Collections.singletonMap(name, PackageAPI.this.pkgs.packages.get(name)));
            }
        }

        private void syncToVersion(int expectedVersion) {
            int origVersion = PackageAPI.this.pkgs.znodeVersion;
            for (int i = 0; i < 10; ++i) {
                log.debug("my version is {} , and expected version {}", (Object)PackageAPI.this.pkgs.znodeVersion, (Object)expectedVersion);
                if (PackageAPI.this.pkgs.znodeVersion >= expectedVersion) {
                    if (origVersion < PackageAPI.this.pkgs.znodeVersion) {
                        PackageAPI.this.packageLoader.refreshPackageConf();
                    }
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    PackageAPI.this.pkgs = PackageAPI.this.readPkgsFromZk(null, null);
                    continue;
                }
                catch (InterruptedException | KeeperException e) {
                    PackageAPI.this.handleZkErr((Exception)e);
                }
            }
        }
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster/package"}, permission=PermissionNameProvider.Name.PACKAGE_EDIT_PERM)
    public class Edit {
        @Command(name="refresh")
        public void refresh(SolrQueryRequest req, SolrQueryResponse rsp, PayloadObj<String> payload) {
            String p = payload.get();
            if (p == null) {
                payload.addError("Package null");
                return;
            }
            PackageLoader.Package pkg = PackageAPI.this.coreContainer.getPackageLoader().getPackage(p);
            if (pkg == null) {
                payload.addError("No such package: " + p);
                return;
            }
            PackageAPI.this.packageLoader.notifyListeners(p);
            for (String s : PackageAPI.this.coreContainer.getPackageStoreAPI().shuffledNodes()) {
                Utils.executeGET((HttpClient)PackageAPI.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(PackageAPI.this.coreContainer.getZkController().zkStateReader.getBaseUrlForNodeName(s).replace("/solr", "/api") + "/cluster/package?wt=javabin&omitHeader=true&refreshPackage=" + p), (Utils.InputStreamConsumer)Utils.JAVABINCONSUMER);
            }
        }

        @Command(name="add")
        public void add(SolrQueryRequest req, SolrQueryResponse rsp, PayloadObj<Package.AddVersion> payload) {
            if (!PackageAPI.this.checkEnabled(payload)) {
                return;
            }
            Package.AddVersion add = payload.get();
            if (add.files.isEmpty()) {
                payload.addError("No files specified");
                return;
            }
            PackageStoreAPI packageStoreAPI = PackageAPI.this.coreContainer.getPackageStoreAPI();
            packageStoreAPI.validateFiles(add.files, true, s -> payload.addError((String)s));
            if (payload.hasError()) {
                return;
            }
            Packages[] finalState = new Packages[1];
            try {
                PackageAPI.this.coreContainer.getZkController().getZkClient().atomicUpdate("/packages.json", (stat, bytes) -> {
                    Packages packages = null;
                    try {
                        packages = bytes == null ? new Packages() : (Packages)PackageAPI.this.mapper.readValue(bytes, Packages.class);
                        packages = packages.copy();
                    }
                    catch (IOException e) {
                        log.error("Error deserializing packages.json", (Throwable)e);
                        packages = new Packages();
                    }
                    List<PkgVersion> list = packages.packages.computeIfAbsent(add.pkg, Utils.NEW_ARRAYLIST_FUN);
                    for (PkgVersion o : list) {
                        if (!(o instanceof PkgVersion)) continue;
                        PkgVersion version = o;
                        if (!Objects.equals(version.version, add.version)) continue;
                        payload.addError("Version '" + add.version + "' exists already");
                        return null;
                    }
                    list.add(new PkgVersion(add));
                    packages.znodeVersion = stat.getVersion() + 1;
                    finalState[0] = packages;
                    return Utils.toJSON((Object)packages);
                });
            }
            catch (InterruptedException | KeeperException e) {
                finalState[0] = null;
                PackageAPI.this.handleZkErr((Exception)e);
            }
            if (finalState[0] != null) {
                PackageAPI.this.pkgs = finalState[0];
                PackageAPI.this.notifyAllNodesToSync(PackageAPI.this.pkgs.znodeVersion);
                PackageAPI.this.packageLoader.refreshPackageConf();
            }
        }

        @Command(name="delete")
        public void del(SolrQueryRequest req, SolrQueryResponse rsp, PayloadObj<Package.DelVersion> payload) {
            if (!PackageAPI.this.checkEnabled(payload)) {
                return;
            }
            Package.DelVersion delVersion = payload.get();
            try {
                PackageAPI.this.coreContainer.getZkController().getZkClient().atomicUpdate("/packages.json", (stat, bytes) -> {
                    Packages packages = null;
                    try {
                        packages = (Packages)PackageAPI.this.mapper.readValue(bytes, Packages.class);
                        packages = packages.copy();
                    }
                    catch (IOException e) {
                        packages = new Packages();
                    }
                    List<PkgVersion> versions = packages.packages.get(delVersion.pkg);
                    if (versions == null || versions.isEmpty()) {
                        payload.addError("No such package: " + delVersion.pkg);
                        return null;
                    }
                    int idxToremove = -1;
                    for (int i = 0; i < versions.size(); ++i) {
                        if (!Objects.equals(versions.get((int)i).version, delVersion.version)) continue;
                        idxToremove = i;
                        break;
                    }
                    if (idxToremove == -1) {
                        payload.addError("No such version: " + delVersion.version);
                        return null;
                    }
                    versions.remove(idxToremove);
                    packages.znodeVersion = stat.getVersion() + 1;
                    return Utils.toJSON((Object)packages);
                });
            }
            catch (InterruptedException | KeeperException e) {
                PackageAPI.this.handleZkErr((Exception)e);
            }
        }
    }

    public static class PkgVersion
    implements ReflectMapWriter {
        @JsonProperty
        public String version;
        @JsonProperty
        public List<String> files;
        @JsonProperty
        public String manifest;
        @JsonProperty
        public String manifestSHA512;

        public PkgVersion() {
        }

        public PkgVersion(Package.AddVersion addVersion) {
            this.version = addVersion.version;
            this.files = addVersion.files;
            this.manifest = addVersion.manifest;
            this.manifestSHA512 = addVersion.manifestSHA512;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PkgVersion) {
                PkgVersion that = (PkgVersion)obj;
                return Objects.equals(this.version, that.version) && Objects.equals(this.files, that.files);
            }
            return false;
        }

        public String toString() {
            try {
                return Utils.writeJson((Object)this, (Writer)new StringWriter(), (boolean)false).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Packages
    implements ReflectMapWriter {
        @JsonProperty
        public int znodeVersion = -1;
        @JsonProperty
        public Map<String, List<PkgVersion>> packages = new LinkedHashMap<String, List<PkgVersion>>();

        public Packages copy() {
            Packages p = new Packages();
            p.znodeVersion = this.znodeVersion;
            p.packages = new LinkedHashMap<String, List<PkgVersion>>();
            this.packages.forEach((s, versions) -> {
                List cfr_ignored_0 = p.packages.put((String)s, new ArrayList(versions));
            });
            return p;
        }
    }
}

