/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class T800xProtocolDecoder
extends BaseProtocolDecoder {
    private short header = (short)8995;
    public static final short DEFAULT_HEADER = 8995;
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 2;
    public static final int MSG_HEARTBEAT = 3;
    public static final int MSG_ALARM = 4;
    public static final int MSG_NETWORK = 5;
    public static final int MSG_COMMAND = 129;

    public short getHeader() {
        return this.header;
    }

    public T800xProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, short header, int type, int index, ByteBuf imei, int alarm) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)(alarm > 0 ? 16 : 15));
            response.writeShort((int)header);
            response.writeByte(type);
            response.writeShort(response.capacity());
            response.writeShort(index);
            response.writeBytes(imei);
            if (alarm > 0) {
                response.writeByte(alarm);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 1: {
                return "powerCut";
            }
            case 2: {
                return "lowBattery";
            }
            case 3: {
                return "sos";
            }
            case 4: {
                return "overspeed";
            }
            case 5: {
                return "geofenceEnter";
            }
            case 6: {
                return "geofenceExit";
            }
            case 7: {
                return "tow";
            }
            case 8: 
            case 10: {
                return "vibration";
            }
            case 21: {
                return "jamming";
            }
            case 23: {
                return "powerRestored";
            }
            case 24: {
                return "lowPower";
            }
        }
        return null;
    }

    private Date readDate(ByteBuf buf) {
        return new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2)).getDate();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        this.header = buf.readShort();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        int index = buf.readUnsignedShort();
        ByteBuf imei = buf.readSlice(8);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)imei).substring(1));
        if (deviceSession == null) {
            return null;
        }
        if (type != 2 && type != 4) {
            this.sendResponse(channel, this.header, type, index, imei, 0);
        }
        if (type == 2 || type == 4) {
            return this.decodePosition(channel, deviceSession, buf, type, index, imei);
        }
        if (type == 5) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, this.readDate(buf));
            position.set("operator", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.UTF_16LE).toString());
            position.set("networkTechnology", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            position.set("networkBand", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII);
            position.set("iccid", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            return position;
        }
        if (type == 129) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            buf.readUnsignedByte();
            position.set("result", buf.toString(StandardCharsets.UTF_16LE));
            return position;
        }
        return null;
    }

    private Position decodePosition(Channel channel, DeviceSession deviceSession, ByteBuf buf, int type, int index, ByteBuf imei) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        if (this.header != 10023) {
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            position.set("rssi", BitUtil.to(buf.readUnsignedShort(), 7));
        }
        short status = buf.readUnsignedByte();
        position.set("sat", BitUtil.to(status, 5));
        if (this.header != 10023) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            int io = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(io, 14));
            position.set("ac", BitUtil.check(io, 13));
            for (int i = 0; i <= 2; ++i) {
                position.set("out" + (i + 1), BitUtil.check(io, 7 + i));
            }
            position.set("adc1", buf.readUnsignedShort());
            position.set("adc2", buf.readUnsignedShort());
        }
        short alarm = buf.readUnsignedByte();
        position.set("alarm", this.decodeAlarm(alarm));
        if (this.header != 10023) {
            buf.readUnsignedByte();
            position.set("odometer", buf.readUnsignedInt());
            int battery = BcdUtil.readInteger(buf, 2);
            if (battery == 0) {
                battery = 100;
            }
            position.set("battery", battery);
        }
        if (BitUtil.check(status, 6)) {
            position.setValid(!BitUtil.check(status, 7));
            position.setTime(this.readDate(buf));
            position.setAltitude(buf.readFloatLE());
            position.setLongitude(buf.readFloatLE());
            position.setLatitude(buf.readFloatLE());
            position.setSpeed(UnitsConverter.knotsFromKph((double)BcdUtil.readInteger(buf, 4) * 0.1));
            position.setCourse(buf.readUnsignedShort());
        } else {
            this.getLastLocation(position, this.readDate(buf));
            int mcc = buf.readUnsignedShortLE();
            int mnc = buf.readUnsignedShortLE();
            if (mcc != 65535 && mnc != 65535) {
                Network network = new Network();
                for (int i = 0; i < 3; ++i) {
                    network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE()));
                }
                position.setNetwork(network);
            }
        }
        if (this.header == 10023) {
            byte[] accelerationBytes = new byte[5];
            buf.readBytes(accelerationBytes);
            long acceleration = new BigInteger(accelerationBytes).longValue();
            double accelerationZ = (double)BitUtil.between(acceleration, 8, 15) + (double)BitUtil.between(acceleration, 4, 8) * 0.1;
            if (!BitUtil.check(acceleration, 15)) {
                accelerationZ = -accelerationZ;
            }
            double accelerationY = (double)BitUtil.between(acceleration, 20, 27) + (double)BitUtil.between(acceleration, 16, 20) * 0.1;
            if (!BitUtil.check(acceleration, 27)) {
                accelerationY = -accelerationY;
            }
            double accelerationX = (double)BitUtil.between(acceleration, 28, 32) + (double)BitUtil.between(acceleration, 32, 39) * 0.1;
            if (!BitUtil.check(acceleration, 39)) {
                accelerationX = -accelerationX;
            }
            position.set("gSensor", "[" + accelerationX + "," + accelerationY + "," + accelerationZ + "]");
            position.set("batteryLevel", BcdUtil.readInteger(buf, 2));
            position.set("deviceTemp", Integer.valueOf(buf.readByte()));
            position.set("lightSensor", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("battery", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("solarPanel", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("odometer", buf.readUnsignedInt());
            int inputStatus = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(inputStatus, 2));
            position.set("rssi", BitUtil.between(inputStatus, 4, 11));
            buf.readUnsignedShort();
            buf.readUnsignedInt();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
        } else if (buf.readableBytes() >= 2) {
            position.set("power", (double)BcdUtil.readInteger(buf, 4) * 0.01);
        }
        this.sendResponse(channel, this.header, type, index, imei, alarm);
        return position;
    }
}

