/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppClient;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.channel.SmppClientConnector;
import com.cloudhopper.smpp.channel.SmppSessionLogger;
import com.cloudhopper.smpp.channel.SmppSessionPduDecoder;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.BindReceiver;
import com.cloudhopper.smpp.pdu.BindTransceiver;
import com.cloudhopper.smpp.pdu.BindTransmitter;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import com.cloudhopper.smpp.ssl.SslContextFactory;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppBindException;
import com.cloudhopper.smpp.type.SmppChannelConnectException;
import com.cloudhopper.smpp.type.SmppChannelConnectTimeoutException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmppClient
implements SmppClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSmppClient.class);
    private final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final SmppClientConnector clientConnector;
    private Bootstrap clientBootstrap;
    private final NioEventLoopGroup workerGroup;
    private final ScheduledExecutorService monitorExecutor;
    private Channel clientChannel;

    public DefaultSmppClient() {
        this(new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(SmppClient.class, true)));
    }

    public DefaultSmppClient(NioEventLoopGroup workerGroup) {
        this(workerGroup, null);
    }

    public DefaultSmppClient(NioEventLoopGroup workerGroup, ScheduledExecutorService monitorExecutor) {
        this.workerGroup = workerGroup;
        this.clientBootstrap = new Bootstrap();
        this.clientBootstrap.group((EventLoopGroup)this.workerGroup);
        this.clientBootstrap.channel(NioSocketChannel.class);
        this.clientConnector = new SmppClientConnector(this.channels);
        this.clientBootstrap.handler((ChannelHandler)this.clientConnector);
        this.monitorExecutor = monitorExecutor;
    }

    public int getConnectionSize() {
        return this.channels.size();
    }

    @Override
    public void destroy() {
        this.channels.close().awaitUninterruptibly();
        try {
            if (this.clientChannel != null) {
                this.clientChannel.closeFuture().sync();
            }
            this.clientBootstrap = null;
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted closing client channel.", (Throwable)e);
        }
        finally {
            this.workerGroup.shutdownGracefully();
            try {
                this.workerGroup.terminationFuture().sync();
            }
            catch (InterruptedException e) {
                logger.warn("Thread interrupted closing executors.", (Throwable)e);
            }
        }
    }

    protected BaseBind createBindRequest(SmppSessionConfiguration config) throws UnrecoverablePduException {
        BaseBind bind = null;
        if (config.getType() == SmppBindType.TRANSCEIVER) {
            bind = new BindTransceiver();
        } else if (config.getType() == SmppBindType.RECEIVER) {
            bind = new BindReceiver();
        } else if (config.getType() == SmppBindType.TRANSMITTER) {
            bind = new BindTransmitter();
        } else {
            throw new UnrecoverablePduException("Unable to convert SmppSessionConfiguration into a BaseBind request");
        }
        bind.setSystemId(config.getSystemId());
        bind.setPassword(config.getPassword());
        bind.setSystemType(config.getSystemType());
        bind.setInterfaceVersion(config.getInterfaceVersion());
        bind.setAddressRange(config.getAddressRange());
        return bind;
    }

    public SmppSession bind(SmppSessionConfiguration config) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        return this.bind(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmppSession bind(SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        DefaultSmppSession session = null;
        try {
            session = this.doOpen(config, sessionHandler);
            this.doBind(session, config, sessionHandler);
        }
        finally {
            if (session != null && !session.isBound()) {
                try {
                    session.destroy();
                }
                catch (Exception exception) {}
            }
        }
        return session;
    }

    protected void doBind(DefaultSmppSession session, SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        BaseBind bindRequest = this.createBindRequest(config);
        BaseBindResp bindResp = null;
        try {
            bindResp = session.bind(bindRequest, config.getBindTimeout());
        }
        catch (RecoverablePduException e) {
            throw new UnrecoverablePduException(e.getMessage(), e);
        }
    }

    protected DefaultSmppSession doOpen(SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        this.clientChannel = this.createConnectedChannel(config.getHost(), config.getPort(), config.getConnectTimeout());
        return this.createSession(this.clientChannel, config, sessionHandler);
    }

    protected DefaultSmppSession createSession(Channel channel, SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        DefaultSmppSession session = new DefaultSmppSession(SmppSession.Type.CLIENT, config, channel, sessionHandler, this.monitorExecutor);
        if (config.isUseSsl()) {
            SslConfiguration sslConfig = config.getSslConfiguration();
            if (sslConfig == null) {
                throw new IllegalStateException("sslConfiguration must be set");
            }
            try {
                SslContextFactory factory = new SslContextFactory(sslConfig);
                SSLEngine sslEngine = factory.newSslEngine();
                sslEngine.setUseClientMode(true);
                channel.pipeline().addLast("smppSessionSSL", (ChannelHandler)new SslHandler(sslEngine));
            }
            catch (Exception e) {
                throw new SmppChannelConnectException("Unable to create SSL session]: " + e.getMessage(), e);
            }
        }
        if (config.getName() != null) {
            channel.pipeline().addLast("smppSessionThreadRenamer", (ChannelHandler)new SmppSessionThreadRenamer(config.getName()));
        } else {
            logger.warn("Session configuration did not have a name set - skipping threadRenamer in pipeline");
        }
        SmppSessionLogger loggingHandler = new SmppSessionLogger(DefaultSmppSession.class.getCanonicalName(), config.getLoggingOptions());
        channel.pipeline().addLast("smppSessionLogger", (ChannelHandler)loggingHandler);
        if (config.getWriteTimeout() > 0L) {
            WriteTimeoutHandler writeTimeoutHandler = new WriteTimeoutHandler(config.getWriteTimeout(), TimeUnit.MILLISECONDS);
            channel.pipeline().addLast("smppSessionWriteTimeout", (ChannelHandler)writeTimeoutHandler);
        }
        channel.pipeline().addLast("smppSessionPduDecoder", (ChannelHandler)new SmppSessionPduDecoder(session.getTranscoder()));
        channel.pipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper(session));
        return session;
    }

    protected Channel createConnectedChannel(String host, int port, long connectTimeoutMillis) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        InetSocketAddress socketAddr = new InetSocketAddress(host, port);
        this.clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeoutMillis));
        ChannelFuture connectFuture = this.clientBootstrap.connect((SocketAddress)socketAddr);
        logger.debug("Waiting for client connection to {}", (Object)socketAddr);
        connectFuture.awaitUninterruptibly();
        if (connectFuture.isCancelled()) {
            logger.warn("Client connection cancelled.");
            throw new InterruptedException("connectFuture cancelled by user");
        }
        if (!connectFuture.isSuccess()) {
            if (connectFuture.cause() instanceof ConnectTimeoutException) {
                logger.warn("Client did not connect in timeout " + connectTimeoutMillis + " ms", connectFuture.cause());
                throw new SmppChannelConnectTimeoutException("Unable to connect to host [" + host + "] and port [" + port + "] within " + connectTimeoutMillis + " ms", connectFuture.cause());
            }
            logger.warn("Client did not connect.", connectFuture.cause());
            throw new SmppChannelConnectException("Unable to connect to host [" + host + "] and port [" + port + "]: " + (connectFuture.cause() != null ? connectFuture.cause().getMessage() : "ChannelFuture failed without cause."), connectFuture.cause());
        }
        logger.debug("Client connected to {}", (Object)socketAddr);
        return connectFuture.channel();
    }
}

