# This file was automatically generated by bifcl from strings.bif.

##! Definitions of built-in functions related to string processing and
##! manipulation.


export {


## Calculates the Levenshtein distance between the two strings. See `Wikipedia
## <http://en.wikipedia.org/wiki/Levenshtein_distance>`__ for more information.
##
## s1: The first string.
##
## s2: The second string.
##
## Returns: The Levenshtein distance of two strings as a count.
##
global levenshtein_distance: function(s1: string , s2: string ): count ;


## Concatenates all arguments into a single string. The function takes a
## variable number of arguments of type string and stitches them together.
##
## Returns: The concatenation of all (string) arguments.
##
## .. zeek:see:: cat cat_sep
##              fmt
##              join_string_vec
global string_cat: function(va_args: any): string ;




## Joins all values in the given vector of strings with a separator placed
## between each element.
##
## sep: The separator to place between each element.
##
## vec: The :zeek:type:`string_vec` (``vector of string``).
##
## Returns: The concatenation of all elements in *vec*, with *sep* placed
##          between each element.
##
## .. zeek:see:: cat cat_sep string_cat
##              fmt
global join_string_vec: function(vec: string_vec , sep: string ): string ;


## Returns an edited version of a string that applies a special
## "backspace character" (usually ``\x08`` for backspace or ``\x7f`` for DEL).
## For example, ``edit("hello there", "e")`` returns ``"llo t"``.
##
## arg_s: The string to edit.
##
## arg_edit_char: A string of exactly one character that represents the
##                "backspace character". If it is longer than one character Zeek
##                generates a run-time error and uses the first character in
##                the string.
##
## Returns: An edited version of *arg_s* where *arg_edit_char* triggers the
##          deletion of the last character.
##
## .. zeek:see:: clean
##              to_string_literal
##              escape_string
##              strip
global edit: function(arg_s: string , arg_edit_char: string ): string ;


## Get a substring from a string, given a starting position and length.
##
## s: The string to obtain a substring from.
##
## start: The starting position of the substring in *s*, where 1 is the first
##        character. As a special case, 0 also represents the first character.
##
## n: The number of characters to extract, beginning at *start*.
##
## Returns: A substring of *s* of length *n* from position *start*.
global sub_bytes: function(s: string , start: count , n: int ): string ;




## Splits a string into an array of strings according to a pattern.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each element corresponds to a substring
##          in *str* separated by *re*.
##
## .. zeek:see:: split_string1 split_string_all split_string_n str_split
##
global split_string: function(str: string , re: pattern ): string_vec ;


## Splits a string *once* into a two-element array of strings according to a
## pattern. This function is the same as :zeek:id:`split_string`, but *str* is
## only split once (if possible) at the earliest position and an array of two
## strings is returned.
##
## str: The string to split.
##
## re: The pattern describing the separator to split *str* in two pieces.
##
## Returns: An array of strings with two elements in which the first represents
##          the substring in *str* up to the first occurence of *re*, and the
##          second everything after *re*. An array of one string is returned
##          when *s* cannot be split.
##
## .. zeek:see:: split_string split_string_all split_string_n str_split
global split_string1: function(str: string , re: pattern ): string_vec ;


## Splits a string into an array of strings according to a pattern. This
## function is the same as :zeek:id:`split_string`, except that the separators
## are returned as well. For example, ``split_string_all("a-b--cd", /(\-)+/)``
## returns ``{"a", "-", "b", "--", "cd"}``: odd-indexed elements do match the
## pattern and even-indexed ones do not.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## Returns: An array of strings where each two successive elements correspond
##          to a substring in *str* of the part not matching *re* (even-indexed)
##          and the part that matches *re* (odd-indexed).
##
## .. zeek:see:: split_string split_string1 split_string_n str_split
global split_string_all: function(str: string , re: pattern ): string_vec ;


## Splits a string a given number of times into an array of strings according
## to a pattern. This function is similar to :zeek:id:`split_string1` and
## :zeek:id:`split_string_all`, but with customizable behavior with respect to
## including separators in the result and the number of times to split.
##
## str: The string to split.
##
## re: The pattern describing the element separator in *str*.
##
## incl_sep: A flag indicating whether to include the separator matches in the
##           result (as in :zeek:id:`split_string_all`).
##
## max_num_sep: The number of times to split *str*.
##
## Returns: An array of strings where, if *incl_sep* is true, each two
##          successive elements correspond to a substring in *str* of the part
##          not matching *re* (even-indexed) and the part that matches *re*
##          (odd-indexed).
##
## .. zeek:see:: split_string split_string1 split_string_all str_split
global split_string_n: function(str: string , re: pattern , incl_sep: bool , max_num_sep: count ): string_vec ;


## Substitutes a given replacement string for the first occurrence of a pattern
## in a given string.
##
## str: The string to perform the substitution in.
##
## re: The pattern being replaced with *repl*.
##
## repl: The string that replaces *re*.
##
## Returns: A copy of *str* with the first occurence of *re* replaced with
##          *repl*.
##
## .. zeek:see:: gsub subst_string
global sub: function(str: string , re: pattern , repl: string ): string ;


## Substitutes a given replacement string for all occurrences of a pattern
## in a given string.
##
## str: The string to perform the substitution in.
##
## re: The pattern being replaced with *repl*.
##
## repl: The string that replaces *re*.
##
## Returns: A copy of *str* with all occurrences of *re* replaced with *repl*.
##
## .. zeek:see:: sub subst_string
global gsub: function(str: string , re: pattern , repl: string ): string ;



## Lexicographically compares two strings.
##
## s1: The first string.
##
## s2: The second string.
##
## Returns: An integer greater than, equal to, or less than 0 according as
##          *s1* is greater than, equal to, or less than *s2*.
global strcmp: function(s1: string , s2: string ): int ;


## Locates the first occurrence of one string in another.
##
## big: The string to look in.
##
## little: The (smaller) string to find inside *big*.
##
## Returns: The location of *little* in *big*, or 0 if *little* is not found in
##          *big*.
##
## .. zeek:see:: find_all find_last
global strstr: function(big: string , little: string ): count ;


## Substitutes each (non-overlapping) appearance of a string in another.
##
## s: The string in which to perform the substitution.
##
## from: The string to look for which is replaced with *to*.
##
## to: The string that replaces all occurrences of *from* in *s*.
##
## Returns: A copy of *s* where each occurrence of *from* is replaced with *to*.
##
## .. zeek:see:: sub gsub
global subst_string: function(s: string , from: string , to: string ): string ;


## Replaces all uppercase letters in a string with their lowercase counterpart.
##
## str: The string to convert to lowercase letters.
##
## Returns: A copy of the given string with the uppercase letters (as indicated
##          by ``isascii`` and ``isupper``) folded to lowercase
##          (via ``tolower``).
##
## .. zeek:see:: to_upper is_ascii
global to_lower: function(str: string ): string ;


## Replaces all lowercase letters in a string with their uppercase counterpart.
##
## str: The string to convert to uppercase letters.
##
## Returns: A copy of the given string with the lowercase letters (as indicated
##          by ``isascii`` and ``islower``) folded to uppercase
##          (via ``toupper``).
##
## .. zeek:see:: to_lower is_ascii
global to_upper: function(str: string ): string ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##
## If the string does not yet have a trailing NUL, one is added internally.
##
## In contrast to :zeek:id:`escape_string`, this encoding is *not* fully reversible.`
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. zeek:see:: to_string_literal escape_string
global clean: function(str: string ): string ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##     - ``\`` to ``\\``
##     - ``'`` and ``""`` to ``\'`` and ``\"``, respectively.
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. zeek:see:: clean escape_string
global to_string_literal: function(str: string ): string ;


## Determines whether a given string contains only ASCII characters.
##
## str: The string to examine.
##
## Returns: False if any byte value of *str* is greater than 127, and true
##          otherwise.
##
## .. zeek:see:: to_upper to_lower
global is_ascii: function(str: string ): bool ;


## Replaces non-printable characters in a string with escaped sequences. The
## mappings are:
##
##     - values not in *[32, 126]* to ``\xXX``
##     - ``\`` to ``\\``
##
## In contrast to :zeek:id:`clean`, this encoding is fully reversible.`
##
## str: The string to escape.
##
## Returns: The escaped string.
##
## .. zeek:see:: clean to_string_literal
global escape_string: function(s: string ): string ;


## Returns an ASCII hexadecimal representation of a string.
##
## s: The string to convert to hex.
##
## Returns: A copy of *s* where each byte is replaced with the corresponding
##          hex nibble.
global string_to_ascii_hex: function(s: string ): string ;


## Uses the Smith-Waterman algorithm to find similar/overlapping substrings.
## See `Wikipedia <http://en.wikipedia.org/wiki/Smith%E2%80%93Waterman_algorithm>`__.
##
## s1: The first string.
##
## s2: The second string.
##
## params: Parameters for the Smith-Waterman algorithm.
##
## Returns: The result of the Smith-Waterman algorithm calculation.
global str_smith_waterman: function(s1: string , s2: string , params: sw_params ) : sw_substring_vec ;


## Splits a string into substrings with the help of an index vector of cutting
## points.
##
## s: The string to split.
##
## idx: The index vector (``vector of count``) with the cutting points.
##
## Returns: A vector of strings.
##
## .. zeek:see:: split_string split_string1 split_string_all split_string_n
global str_split: function(s: string , idx: index_vec ): string_vec ;


## Strips whitespace at both ends of a string.
##
## str: The string to strip the whitespace from.
##
## Returns: A copy of *str* with leading and trailing whitespace removed.
##
## .. zeek:see:: sub gsub lstrip rstrip
global strip: function(str: string ): string ;




## Removes all combinations of characters in the *chars* argument
## starting at the beginning of the string until first mismatch.
##
## str: The string to strip characters from.
##
## chars: A string consisting of the characters to be removed.
##        Defaults to all whitespace characters.
##
## Returns: A copy of *str* with the characters in *chars* removed from
##          the beginning.
##
## .. zeek:see:: sub gsub strip rstrip
global lstrip: function(str: string , chars: string &default=" \t\n\r\v\f"): string ;


## Removes all combinations of characters in the *chars* argument
## starting at the end of the string until first mismatch.
##
## str: The string to strip characters from.
##
## chars: A string consisting of the characters to be removed.
##        Defaults to all whitespace characters.
##
## Returns: A copy of *str* with the characters in *chars* removed from
##          the end.
##
## .. zeek:see:: sub gsub strip lstrip
global rstrip: function(str: string , chars: string &default=" \t\n\r\v\f"): string ;


## Generates a string of a given size and fills it with repetitions of a source
## string.
##
## len: The length of the output string.
##
## source: The string to concatenate repeatedly until *len* has been reached.
##
## Returns: A string of length *len* filled with *source*.
global string_fill: function(len: int , source: string ): string ;


## Takes a string and escapes characters that would allow execution of
## commands at the shell level. Must be used before including strings in
## :zeek:id:`system` or similar calls.
##
## source: The string to escape.
##
## Returns: A shell-escaped version of *source*.  Specifically, this
##          backslash-escapes characters whose literal value is not otherwise
##          preserved by enclosure in double-quotes (dollar-sign, backquote,
##          backslash, and double-quote itself), and then encloses that
##          backslash-escaped string in double-quotes to ultimately preserve
##          the literal value of all input characters.
##
## .. zeek:see:: system safe_shell_quote
global safe_shell_quote: function(source: string ): string ;


## Finds all occurrences of a pattern in a string.
##
## str: The string to inspect.
##
## re: The pattern to look for in *str*.
##
## Returns: The set of strings in *str* that match *re*, or the empty set.
##
## .. zeek:see: find_last strstr
global find_all: function(str: string , re: pattern ) : string_set ;


## Finds the last occurrence of a pattern in a string. This function returns
## the match that starts at the largest index in the string, which is not
## necessarily the longest match.  For example, a pattern of ``/.*/`` will
## return the final character in the string.
##
## str: The string to inspect.
##
## re: The pattern to look for in *str*.
##
## Returns: The last string in *str* that matches *re*, or the empty string.
##
## .. zeek:see: find_all strstr
global find_last: function(str: string , re: pattern ) : string ;


## Returns a hex dump for given input data. The hex dump renders 16 bytes per
## line, with hex on the left and ASCII (where printable)
## on the right.
##
## data_str: The string to dump in hex format.
##
## Returns: The hex dump of the given string.
##
## .. zeek:see:: string_to_ascii_hex bytestring_to_hexstr
##
## .. note:: Based on Netdude's hex editor code.
##
global hexdump: function(data_str: string ) : string ;


## Returns a reversed copy of the string
##
## str: The string to reverse.
##
## Returns: A reversed copy of *str*
##
global reverse: function(str: string ) : string ;

} # end of export section
module GLOBAL;
