/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class TokenPairExpressionIterator
extends ExpressionAdapter {
    protected final String startToken;
    protected final String endToken;
    protected final boolean includeTokens;

    public TokenPairExpressionIterator(String startToken, String endToken, boolean includeTokens) {
        ObjectHelper.notEmpty(startToken, "startToken");
        ObjectHelper.notEmpty(endToken, "endToken");
        this.startToken = startToken;
        this.endToken = endToken;
        this.includeTokens = includeTokens;
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.doEvaluate(exchange, true);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    @Override
    public Object evaluate(Exchange exchange) {
        return this.doEvaluate(exchange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doEvaluate(Exchange exchange, boolean closeStream) {
        InputStream in = null;
        try {
            in = exchange.getIn().getMandatoryBody(InputStream.class);
            String charset = IOHelper.getCharsetName(exchange);
            Iterator<?> iterator = this.createIterator(in, charset);
            return iterator;
        }
        catch (InvalidPayloadException e) {
            exchange.setException(e);
            IOHelper.close((Closeable)in);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            if (closeStream) {
                IOHelper.close((Closeable)in);
            }
        }
    }

    protected Iterator<?> createIterator(InputStream in, String charset) {
        TokenPairIterator iterator = new TokenPairIterator(this.startToken, this.endToken, this.includeTokens, in, charset);
        iterator.init();
        return iterator;
    }

    public String toString() {
        return "tokenize[body() using tokens: " + this.startToken + "..." + this.endToken + "]";
    }

    static class TokenPairIterator
    implements Iterator<Object>,
    Closeable {
        final String startToken;
        String scanStartToken;
        final String endToken;
        String scanEndToken;
        final boolean includeTokens;
        final InputStream in;
        final String charset;
        Scanner scanner;
        Object image;

        TokenPairIterator(String startToken, String endToken, boolean includeTokens, InputStream in, String charset) {
            this.startToken = startToken;
            this.endToken = endToken;
            this.includeTokens = includeTokens;
            this.in = in;
            this.charset = charset;
            this.scanStartToken = startToken;
            if (this.scanStartToken.startsWith("[")) {
                this.scanStartToken = "\\" + this.scanStartToken;
            }
            if (this.scanStartToken.endsWith("]")) {
                this.scanStartToken = this.scanStartToken.substring(0, startToken.length() - 1) + "\\]";
            }
            this.scanEndToken = endToken;
            if (this.scanEndToken.startsWith("[")) {
                this.scanEndToken = "\\" + this.scanEndToken;
            }
            if (this.scanEndToken.endsWith("]")) {
                this.scanEndToken = this.scanEndToken.substring(0, this.scanEndToken.length() - 1) + "\\]";
            }
        }

        void init() {
            this.scanner = new Scanner(this.in, this.charset).useDelimiter(this.scanEndToken);
            this.image = this.scanner.hasNext() ? this.next(true) : null;
        }

        @Override
        public boolean hasNext() {
            return this.image != null;
        }

        @Override
        public Object next() {
            return this.next(false);
        }

        Object next(boolean first) {
            Object answer = this.image;
            this.image = this.scanner.hasNext() ? this.getNext(first) : null;
            if (answer == null) {
                answer = this.image;
            }
            return answer;
        }

        Object getNext(boolean first) {
            String next = this.scanner.next();
            if (next != null && next.contains(this.startToken)) {
                if ((next = ObjectHelper.after(next, this.startToken)) != null && this.includeTokens) {
                    StringBuilder sb = new StringBuilder();
                    next = sb.append(this.startToken).append(next).append(this.endToken).toString();
                }
            } else {
                return null;
            }
            return next;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }
}

