/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultRouteContext
implements RouteContext {
    private final Map<ProcessorDefinition<?>, AtomicInteger> nodeIndex = new HashMap();
    private final RouteDefinition route;
    private FromDefinition from;
    private final Collection<Route> routes;
    private Endpoint endpoint;
    private final List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private CamelContext camelContext;
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private InterceptStrategy managedInterceptStrategy;
    private boolean routeAdded;
    private Boolean trace;
    private Boolean messageHistory;
    private Boolean streamCache;
    private Boolean handleFault;
    private Long delay;
    private Boolean autoStartup = Boolean.TRUE;
    private List<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;

    public DefaultRouteContext(CamelContext camelContext, RouteDefinition route, FromDefinition from, Collection<Route> routes) {
        this.camelContext = camelContext;
        this.route = route;
        this.from = from;
        this.routes = routes;
    }

    public DefaultRouteContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.routes = new ArrayList<Route>();
        this.route = new RouteDefinition("temporary");
    }

    @Override
    public Endpoint getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = this.from.resolveEndpoint(this);
        }
        return this.endpoint;
    }

    @Override
    public FromDefinition getFrom() {
        return this.from;
    }

    @Override
    public RouteDefinition getRoute() {
        return this.route;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Endpoint resolveEndpoint(String uri) {
        return this.route.resolveEndpoint(this.getCamelContext(), uri);
    }

    @Override
    public Endpoint resolveEndpoint(String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = this.resolveEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null) {
            endpoint = this.lookup(ref, Endpoint.class);
            if (endpoint == null) {
                throw new NoSuchEndpointException("ref:" + ref, "check your camel registry with id " + ref);
            }
            if (!this.getCamelContext().equals(endpoint.getCamelContext())) {
                throw new NoSuchEndpointException("ref:" + ref, "make sure the endpoint has the same camel context as the route does.");
            }
            try {
                this.getCamelContext().addService(endpoint);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException(ex);
            }
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified on: " + this);
        }
        return endpoint;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.getCamelContext().getRegistry().lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.getCamelContext().getRegistry().findByTypeWithName(type);
    }

    @Override
    public <T> T mandatoryLookup(String name, Class<T> type) {
        return CamelContextHelper.mandatoryLookup(this.getCamelContext(), name, type);
    }

    @Override
    public void commit() {
        if (!this.eventDrivenProcessors.isEmpty()) {
            CamelInternalProcessor.RouteLifecycleAdvice task2;
            Processor target = Pipeline.newInstance(this.getCamelContext(), this.eventDrivenProcessors);
            String routeId = this.route.idOrCreate(this.getCamelContext().getNodeIdFactory());
            CamelInternalProcessor internal = new CamelInternalProcessor(target);
            internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(this));
            List<RoutePolicy> routePolicyList = this.getRoutePolicyList();
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    if (this.camelContext.hasService(policy)) continue;
                    try {
                        this.camelContext.addService(policy);
                    }
                    catch (Exception e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                }
                internal.addAdvice(new CamelInternalProcessor.RoutePolicyAdvice(routePolicyList));
            }
            internal.addAdvice(new CamelInternalProcessor.RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), routeId));
            internal.addAdvice(new CamelInternalProcessor.InstrumentationAdvice("route"));
            internal.addAdvice(new CamelInternalProcessor.RouteLifecycleAdvice());
            EventDrivenConsumerRoute edcr = new EventDrivenConsumerRoute((RouteContext)this, this.getEndpoint(), internal);
            edcr.getProperties().put("id", routeId);
            edcr.getProperties().put("parent", Integer.toHexString(this.route.hashCode()));
            edcr.getProperties().put("description", this.route.getDescriptionText());
            if (this.route.getGroup() != null) {
                edcr.getProperties().put("group", this.route.getGroup());
            }
            String rest = "false";
            if (this.route.isRest() != null && this.route.isRest().booleanValue()) {
                rest = "true";
            }
            edcr.getProperties().put("rest", rest);
            CamelInternalProcessor.RoutePolicyAdvice task = internal.getAdvice(CamelInternalProcessor.RoutePolicyAdvice.class);
            if (task != null) {
                task.setRoute(edcr);
            }
            if ((task2 = internal.getAdvice(CamelInternalProcessor.RouteLifecycleAdvice.class)) != null) {
                task2.setRoute(edcr);
            }
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    policy.onInit(edcr);
                }
            }
            this.routes.add(edcr);
        }
    }

    @Override
    public void addEventDrivenProcessor(Processor processor) {
        this.eventDrivenProcessors.add(processor);
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    @Override
    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    @Override
    public void setManagedInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.managedInterceptStrategy = interceptStrategy;
    }

    @Override
    public InterceptStrategy getManagedInterceptStrategy() {
        return this.managedInterceptStrategy;
    }

    @Override
    public boolean isRouteAdded() {
        return this.routeAdded;
    }

    @Override
    public void setIsRouteAdded(boolean routeAdded) {
        this.routeAdded = routeAdded;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        if (this.trace != null) {
            return this.trace;
        }
        return this.getCamelContext().isTracing();
    }

    @Override
    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public Boolean isMessageHistory() {
        if (this.messageHistory != null) {
            return this.messageHistory;
        }
        return this.getCamelContext().isMessageHistory();
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        if (this.streamCache != null) {
            return this.streamCache;
        }
        return this.getCamelContext().isStreamCaching();
    }

    @Override
    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public Boolean isHandleFault() {
        if (this.handleFault != null) {
            return this.handleFault;
        }
        return this.getCamelContext().isHandleFault();
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public Long getDelayer() {
        if (this.delay != null) {
            return this.delay;
        }
        return this.getCamelContext().getDelayer();
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public Boolean isAutoStartup() {
        if (this.autoStartup != null) {
            return this.autoStartup;
        }
        return true;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        throw new IllegalArgumentException("This option can only be configured on CamelContext");
    }

    @Override
    public Boolean isAllowUseOriginalMessage() {
        return this.getCamelContext().isAllowUseOriginalMessage();
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        if (this.shutdownRoute != null) {
            return this.shutdownRoute;
        }
        return this.getCamelContext().getShutdownRoute();
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        if (this.shutdownRunningTask != null) {
            return this.shutdownRunningTask;
        }
        return this.getCamelContext().getShutdownRunningTask();
    }

    @Override
    public int getAndIncrement(ProcessorDefinition<?> node) {
        AtomicInteger count = this.nodeIndex.get(node);
        if (count == null) {
            count = new AtomicInteger();
            this.nodeIndex.put(node, count);
        }
        return count.getAndIncrement();
    }

    @Override
    public void setRoutePolicyList(List<RoutePolicy> routePolicyList) {
        this.routePolicyList = routePolicyList;
    }

    @Override
    public List<RoutePolicy> getRoutePolicyList() {
        return this.routePolicyList;
    }
}

