/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.annotation.Nullable;

enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= bits.set((long)combinedHash % bitSize);
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                if (bits.get((long)combinedHash % bitSize)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    MURMUR128_MITZ_64{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes2 = Hashing.murmur3_128().hashObject(object, funnel).getBytesInternal();
            long hash1 = this.lowerEight(bytes2);
            long hash2 = this.upperEight(bytes2);
            boolean bitsChanged = false;
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                bitsChanged |= bits.set((combinedHash & Long.MAX_VALUE) % bitSize);
                combinedHash += hash2;
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes2 = Hashing.murmur3_128().hashObject(object, funnel).getBytesInternal();
            long hash1 = this.lowerEight(bytes2);
            long hash2 = this.upperEight(bytes2);
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                if (!bits.get((combinedHash & Long.MAX_VALUE) % bitSize)) {
                    return false;
                }
                combinedHash += hash2;
            }
            return true;
        }

        private long lowerEight(byte[] bytes2) {
            return Longs.fromBytes(bytes2[7], bytes2[6], bytes2[5], bytes2[4], bytes2[3], bytes2[2], bytes2[1], bytes2[0]);
        }

        private long upperEight(byte[] bytes2) {
            return Longs.fromBytes(bytes2[15], bytes2[14], bytes2[13], bytes2[12], bytes2[11], bytes2[10], bytes2[9], bytes2[8]);
        }
    };


    static final class BitArray {
        final long[] data;
        long bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast(LongMath.divide(bits, 64L, RoundingMode.CEILING))]);
        }

        BitArray(long[] data2) {
            Preconditions.checkArgument(data2.length > 0, "data length is zero!");
            this.data = data2;
            long bitCount = 0L;
            for (long value : data2) {
                bitCount += (long)Long.bitCount(value);
            }
            this.bitCount = bitCount;
        }

        boolean set(long index2) {
            if (!this.get(index2)) {
                int n = (int)(index2 >>> 6);
                this.data[n] = this.data[n] | 1L << (int)index2;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(long index2) {
            return (this.data[(int)(index2 >>> 6)] & 1L << (int)index2) != 0L;
        }

        long bitSize() {
            return (long)this.data.length * 64L;
        }

        long bitCount() {
            return this.bitCount;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        void putAll(BitArray array2) {
            Preconditions.checkArgument(this.data.length == array2.data.length, "BitArrays must be of equal length (%s != %s)", this.data.length, array2.data.length);
            this.bitCount = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array2.data[i];
                this.bitCount += (long)Long.bitCount(this.data[i]);
            }
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

