export class ThrottlingManager extends Common.Object{constructor(){super();this._cpuThrottlingRate=MobileThrottling.CPUThrottlingRates.NoThrottling;this._cpuThrottlingControls=new Set();this._cpuThrottlingRates=MobileThrottling.cpuThrottlingPresets;this._customNetworkConditionsSetting=Common.moduleSetting('customNetworkConditions');this._currentNetworkThrottlingConditions=SDK.NetworkManager.NoThrottlingConditions;this._lastNetworkThrottlingConditions;SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,()=>{this._lastNetworkThrottlingConditions=this._currentNetworkThrottlingConditions;this._currentNetworkThrottlingConditions=SDK.multitargetNetworkManager.networkConditions();});SDK.targetManager.observeModels(SDK.EmulationModel,this);}
decorateSelectWithNetworkThrottling(selectElement){let options=[];const selector=new MobileThrottling.NetworkThrottlingSelector(populate,select,this._customNetworkConditionsSetting);selectElement.addEventListener('change',optionSelected,false);return selector;function populate(groups){selectElement.removeChildren();options=[];for(let i=0;i<groups.length;++i){const group=groups[i];const groupElement=selectElement.createChild('optgroup');groupElement.label=group.title;for(const conditions of group.items){const title=conditions.title;const option=new Option(title,title);UI.ARIAUtils.setAccessibleName(option,ls`${group.title}: ${title}`);groupElement.appendChild(option);options.push(conditions);}
if(i===groups.length-1){const option=new Option(ls`Add\u2026`,ls`Add\u2026`);UI.ARIAUtils.setAccessibleName(option,ls`Add ${group.title}`);groupElement.appendChild(option);options.push(null);}}
return options;}
function optionSelected(){if(selectElement.selectedIndex===selectElement.options.length-1){selector.revealAndUpdate();}else{selector.optionSelected(options[selectElement.selectedIndex]);}}
function select(index){if(selectElement.selectedIndex!==index){selectElement.selectedIndex=index;}}}
createOfflineToolbarCheckbox(){const checkbox=new UI.ToolbarCheckbox(Common.UIString('Offline'),Common.UIString('Force disconnected from network'),forceOffline.bind(this));SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,networkConditionsChanged);checkbox.setChecked(SDK.multitargetNetworkManager.networkConditions()===SDK.NetworkManager.OfflineConditions);function forceOffline(){if(checkbox.checked()){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.OfflineConditions);}else{SDK.multitargetNetworkManager.setNetworkConditions(this._lastNetworkThrottlingConditions);}}
function networkConditionsChanged(){checkbox.setChecked(SDK.multitargetNetworkManager.networkConditions()===SDK.NetworkManager.OfflineConditions);}
return checkbox;}
createMobileThrottlingButton(){const button=new UI.ToolbarMenuButton(appendItems);button.setTitle(Common.UIString('Throttling'));button.setGlyph('');button.turnIntoSelect();button.setDarkText();let options=[];let selectedIndex=-1;const selector=new MobileThrottling.MobileThrottlingSelector(populate,select);return button;function appendItems(contextMenu){for(let index=0;index<options.length;++index){const conditions=options[index];if(!conditions){continue;}
if(conditions.title===MobileThrottling.CustomConditions.title&&conditions.description===MobileThrottling.CustomConditions.description){continue;}
contextMenu.defaultSection().appendCheckboxItem(Common.UIString(conditions.title),selector.optionSelected.bind(selector,(conditions)),selectedIndex===index);}}
function populate(groups){options=[];for(const group of groups){for(const conditions of group.items){options.push(conditions);}
options.push(null);}
return options;}
function select(index){selectedIndex=index;button.setText(options[index].title);button.setTitle(options[index].description);}}
cpuThrottlingRate(){return this._cpuThrottlingRate;}
setCPUThrottlingRate(rate){this._cpuThrottlingRate=rate;for(const emulationModel of SDK.targetManager.models(SDK.EmulationModel)){emulationModel.setCPUThrottlingRate(this._cpuThrottlingRate);}
let icon=null;if(this._cpuThrottlingRate!==MobileThrottling.CPUThrottlingRates.NoThrottling){Host.userMetrics.actionTaken(Host.UserMetrics.Action.CpuThrottlingEnabled);icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('CPU throttling is enabled');}
const index=this._cpuThrottlingRates.indexOf(this._cpuThrottlingRate);for(const control of this._cpuThrottlingControls){control.setSelectedIndex(index);}
UI.inspectorView.setPanelIcon('timeline',icon);this.dispatchEventToListeners(Events.RateChanged,this._cpuThrottlingRate);}
modelAdded(emulationModel){if(this._cpuThrottlingRate!==MobileThrottling.CPUThrottlingRates.NoThrottling){emulationModel.setCPUThrottlingRate(this._cpuThrottlingRate);}}
modelRemoved(emulationModel){}
createCPUThrottlingSelector(){const control=new UI.ToolbarComboBox(event=>this.setCPUThrottlingRate(this._cpuThrottlingRates[event.target.selectedIndex]),ls`CPU throttling`);this._cpuThrottlingControls.add(control);const currentRate=this._cpuThrottlingRate;for(let i=0;i<this._cpuThrottlingRates.length;++i){const rate=this._cpuThrottlingRates[i];const title=rate===1?Common.UIString('No throttling'):Common.UIString('%d\xD7 slowdown',rate);const option=control.createOption(title);control.addOption(option);if(currentRate===rate){control.setSelectedIndex(i);}}
return control;}}
export const Events={RateChanged:Symbol('RateChanged')};export class ActionDelegate{handleAction(context,actionId){if(actionId==='network-conditions.network-online'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.NoThrottlingConditions);return true;}
if(actionId==='network-conditions.network-low-end-mobile'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.Slow3GConditions);return true;}
if(actionId==='network-conditions.network-mid-tier-mobile'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.Fast3GConditions);return true;}
if(actionId==='network-conditions.network-offline'){SDK.multitargetNetworkManager.setNetworkConditions(SDK.NetworkManager.OfflineConditions);return true;}
return false;}}
export function throttlingManager(){return self.singleton(ThrottlingManager);}
self.MobileThrottling=self.MobileThrottling||{};MobileThrottling=MobileThrottling||{};MobileThrottling.ThrottlingManager=ThrottlingManager;MobileThrottling.ThrottlingManager.Events=Events;MobileThrottling.ThrottlingManager.ActionDelegate=ActionDelegate;MobileThrottling.throttlingManager=throttlingManager;