/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import java.net.URLEncoder;
import java.util.Set;
import org.simpleframework.http.Query;
import org.simpleframework.util.parse.MapParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser
extends MapParser<String>
implements Query {
    private Token name = new Token();
    private Token value = new Token();

    public QueryParser() {
    }

    public QueryParser(String text) {
        this();
        this.parse(text);
    }

    @Override
    public int getInteger(Object name) {
        String value = (String)this.get(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public float getFloat(Object name) {
        String value = (String)this.get(name);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return 0.0f;
    }

    @Override
    public boolean getBoolean(Object name) {
        Boolean flag = Boolean.FALSE;
        String value = (String)this.get(name);
        if (value != null) {
            flag = Boolean.valueOf(value);
        }
        return flag;
    }

    @Override
    protected void init() {
        this.all.clear();
        this.map.clear();
        this.name.len = 0;
        this.value.len = 0;
        this.off = 0;
    }

    @Override
    protected void parse() {
        this.param();
        while (this.skip("&")) {
            this.param();
        }
    }

    private void insert() {
        if (this.name.len > 0) {
            this.insert(this.name, this.value);
        }
        this.name.len = 0;
        this.value.len = 0;
    }

    private void insert(Token name, Token value) {
        this.put(name.toString(), value.toString());
    }

    private void param() {
        this.name();
        if (this.skip("=")) {
            this.value();
        }
        this.insert();
    }

    private void name() {
        int mark = this.off;
        int pos = this.off;
        while (this.off < this.count) {
            if (this.buf[this.off] == '%') {
                this.escape();
            } else {
                if (this.buf[this.off] == '=') break;
                if (this.buf[this.off] == '+') {
                    this.buf[this.off] = 32;
                }
            }
            this.buf[pos++] = this.buf[this.off++];
        }
        this.name.len = pos - mark;
        this.name.off = mark;
    }

    private void value() {
        int mark = this.off;
        int pos = this.off;
        while (this.off < this.count) {
            if (this.buf[this.off] == '%') {
                this.escape();
            } else if (this.buf[this.off] == '+') {
                this.buf[this.off] = 32;
            } else if (this.buf[this.off] == '&') break;
            this.buf[pos++] = this.buf[this.off++];
        }
        this.value.len = pos - mark;
        this.value.off = mark;
    }

    private void escape() {
        int peek = this.peek(this.off);
        if (!this.unicode(peek)) {
            this.binary(peek);
        }
    }

    private boolean binary(int peek) {
        if (this.off + 2 < this.count) {
            this.off += 2;
            this.buf[this.off] = this.bits(peek);
        }
        return true;
    }

    private boolean unicode(int peek) {
        if ((peek & 0x80) == 0) {
            return this.unicode(peek, 0);
        }
        if ((peek & 0xE0) == 192) {
            return this.unicode(peek & 0x1F, 1);
        }
        if ((peek & 0xF0) == 224) {
            return this.unicode(peek & 0xF, 2);
        }
        if ((peek & 0xF8) == 240) {
            return this.unicode(peek & 7, 3);
        }
        if ((peek & 0xFC) == 248) {
            return this.unicode(peek & 3, 4);
        }
        if ((peek & 0xFE) == 252) {
            return this.unicode(peek & 1, 5);
        }
        return false;
    }

    private boolean unicode(int peek, int more) {
        if (this.off + more * 3 >= this.count) {
            return false;
        }
        return this.unicode(peek, more, this.off);
    }

    private boolean unicode(int peek, int more, int pos) {
        while (more-- > 0) {
            int next;
            int hex;
            if (this.buf[pos] == '%' && ((hex = this.peek(next = pos + 3)) & 0xC0) == 128) {
                peek = peek << 6 | hex & 0x3F;
                pos = next;
                continue;
            }
            return false;
        }
        if (pos + 2 < this.count) {
            this.off = pos + 2;
            this.buf[this.off] = this.bits(peek);
        }
        return true;
    }

    private char bits(int data) {
        return (char)data;
    }

    private int peek(int pos) {
        if (this.buf[pos] == '%') {
            if (this.count <= pos + 2) {
                return -1;
            }
            char high = this.buf[pos + 1];
            char low = this.buf[pos + 2];
            return this.convert(high, low);
        }
        return -1;
    }

    private int convert(char high, char low) {
        int hex = 0;
        if (this.hex(high) && this.hex(low)) {
            if ('A' <= high && high <= 'F') {
                high = (char)(high + 32);
            }
            hex = high >= 'a' ? (hex ^= high - 97 + 10) : (hex ^= high - 48);
            hex <<= 4;
            if ('A' <= low && low <= 'F') {
                low = (char)(low + 32);
            }
            hex = low >= 'a' ? (hex ^= low - 97 + 10) : (hex ^= low - 48);
            return hex;
        }
        return -1;
    }

    private boolean hex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch >= 'a' && ch <= 'f') {
            return true;
        }
        return ch >= 'A' && ch <= 'F';
    }

    private String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (Exception e) {
            return text;
        }
    }

    private String encode(String name, String value) {
        return this.encode(name) + "=" + this.encode(value);
    }

    public String toString(Set set) {
        Object[] list = set.toArray();
        String text = "";
        for (int i = 0; i < list.length; ++i) {
            String name = list[i].toString();
            String value = (String)this.get(name);
            if (i > 0) {
                text = text + "&";
            }
            text = text + this.encode(name, value);
        }
        return text;
    }

    @Override
    public String toString() {
        Set set = this.map.keySet();
        if (this.map.size() > 0) {
            return this.toString(set);
        }
        return "";
    }

    private class Token {
        public int len;
        public int off;

        private Token() {
        }

        public String toString() {
            if (this.len <= 0) {
                return "";
            }
            return new String(QueryParser.this.buf, this.off, this.len);
        }
    }
}

