/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jnlp.runtime.Translator;

public class OptionsDefinitions {
    public static List<OPTIONS> getItwsettingsCommands() {
        return Arrays.asList(OPTIONS.HELP2, OPTIONS.LIST, OPTIONS.GET, OPTIONS.INFO, OPTIONS.SET, OPTIONS.RESET, OPTIONS.RESETALL, OPTIONS.HEADLESS, OPTIONS.CHECK, OPTIONS.VERBOSE);
    }

    public static List<OPTIONS> getPolicyEditorOptions() {
        return Arrays.asList(OPTIONS.HELP1, OPTIONS.DEFAULTFILE, OPTIONS.FILE, OPTIONS.CODEBASE, OPTIONS.VERBOSE);
    }

    public static List<OPTIONS> getJavaWsControlOptions() {
        return Arrays.asList(OPTIONS.ABOUT, OPTIONS.VIEWER, OPTIONS.CLEARCACHE, OPTIONS.LICENSE, OPTIONS.HELP1);
    }

    public static List<OPTIONS> getJavaWsRuntimeOptions() {
        return Arrays.asList(OPTIONS.VERSION, OPTIONS.ARG, OPTIONS.PARAM, OPTIONS.PROPERTY, OPTIONS.UPDATE, OPTIONS.VERBOSE, OPTIONS.NOSEC, OPTIONS.NOUPDATE, OPTIONS.HEADLESS, OPTIONS.STRICT, OPTIONS.XML, OPTIONS.REDIRECT, OPTIONS.NOFORK, OPTIONS.NOHEADERS, OPTIONS.OFFLINE, OPTIONS.TRUSTNONE, OPTIONS.JNLP, OPTIONS.HTML);
    }

    public static List<OPTIONS> getJavaWsOptions() {
        ArrayList<OPTIONS> l = new ArrayList<OPTIONS>();
        l.addAll(OptionsDefinitions.getJavaWsRuntimeOptions());
        l.addAll(OptionsDefinitions.getJavaWsControlOptions());
        l.add(OPTIONS.TRUSTALL);
        return l;
    }

    private static enum NumberOfArguments {
        NONE("NOAnone"),
        ONE("NOAone"),
        ONE_OR_MORE("NOAonemore"),
        EVEN_NUMBER_SUPPORTS_EQUALS_CHAR("NOAevennumber");

        String messageKey;

        private NumberOfArguments(String messageKey) {
            this.messageKey = messageKey;
        }

        public String getMessage() {
            return Translator.R(this.messageKey);
        }
    }

    public static enum OPTIONS {
        TRUSTALL("-Xtrustall", "BOTrustall"),
        ABOUT("-about", "BOAbout"),
        VIEWER("-viewer", "BOViewer"),
        CLEARCACHE("-Xclearcache", "BXclearcache"),
        LICENSE("-license", "BOLicense"),
        HELP1("-help", "BOHelp1"),
        VERSION("-version", "BOVersion"),
        ARG("-arg", "arg", "BOArg", NumberOfArguments.ONE_OR_MORE),
        PARAM("-param", "name=value", "BOParam", NumberOfArguments.ONE_OR_MORE),
        PROPERTY("-property", "name=value", "BOProperty", NumberOfArguments.ONE_OR_MORE),
        UPDATE("-update", "seconds", "BOUpdate", NumberOfArguments.ONE),
        VERBOSE("-verbose", "BOVerbose"),
        DETAILS("-details", "BOVerbose"),
        NOSEC("-nosecurity", "BONosecurity"),
        NOUPDATE("-noupdate", "BONoupdate"),
        HEADLESS("-headless", "BOHeadless"),
        STRICT("-strict", "BOStrict"),
        XML("-xml", "BOXml"),
        REDIRECT("-allowredirect", "BOredirect"),
        NOFORK("-Xnofork", "BXnofork"),
        NOHEADERS("-Xignoreheaders", "BXignoreheaders"),
        OFFLINE("-Xoffline", "BXoffline"),
        TRUSTNONE("-Xtrustnone", "BOTrustnone"),
        JNLP("-jnlp", "BOJnlp", NumberOfArguments.ONE),
        HTML("-html", "BOHtml", NumberOfArguments.ONE_OR_MORE),
        LIST("-list", "IBOList"),
        GET("-get", "name", "IBOGet", NumberOfArguments.ONE_OR_MORE),
        INFO("-info", "name", "IBOInfo", NumberOfArguments.ONE_OR_MORE),
        SET("-set", "name value", "IBOSet", NumberOfArguments.EVEN_NUMBER_SUPPORTS_EQUALS_CHAR),
        RESETALL("-reset", "all", "IBOResetAll"),
        RESET("-reset", "name", "IBOReset", NumberOfArguments.ONE_OR_MORE),
        CHECK("-check", "name", "IBOCheck"),
        HELP2("-help", "BOHelp2"),
        FILE("-file", "policy_file", "PBOFile", NumberOfArguments.ONE),
        DEFAULTFILE("-defaultfile", "PBODefaultFile"),
        CODEBASE("-codebase", "url", "PBOCodebase", NumberOfArguments.ONE_OR_MORE);

        public final String option;
        public final String helperString;
        public final String decriptionKey;
        private final NumberOfArguments numberOfArguments;

        private OPTIONS(String option, String helperString, String decriptionKey, NumberOfArguments numberOfArguments) {
            this.decriptionKey = decriptionKey;
            this.option = option;
            this.helperString = helperString;
            this.numberOfArguments = numberOfArguments;
        }

        private OPTIONS(String option, String helperString, String decriptionKey) {
            this(option, helperString, decriptionKey, NumberOfArguments.NONE);
        }

        private OPTIONS(String option, String decriptionKey, NumberOfArguments numberOfArguments) {
            this(option, "", decriptionKey, numberOfArguments);
        }

        private OPTIONS(String option, String decriptionKey) {
            this(option, "", decriptionKey);
        }

        public String getLocalizedDescription() {
            return Translator.R(this.decriptionKey);
        }

        public boolean hasNoArguments() {
            return this.numberOfArguments == NumberOfArguments.NONE;
        }

        public boolean hasEvenNumberSupportingEqualsChar() {
            return this.numberOfArguments == NumberOfArguments.EVEN_NUMBER_SUPPORTS_EQUALS_CHAR;
        }

        public boolean hasOneOrMoreArguments() {
            return this.numberOfArguments == NumberOfArguments.ONE_OR_MORE;
        }

        public boolean hasOneArgument() {
            return this.numberOfArguments == NumberOfArguments.ONE;
        }

        public String getArgumentExplanation() {
            return this.numberOfArguments.getMessage();
        }
    }
}

