"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var annotation_utils_1 = require("./annotation_utils");
var utils_1 = require("../state/utils");
var axis_utils_1 = require("../utils/axis_utils");
var rect_annotation_tooltip_1 = require("./rect_annotation_tooltip");
exports.DEFAULT_LINE_OVERFLOW = 0;
function computeYDomainLineAnnotationDimensions(dataValues, yScale, chartRotation, axisPosition, chartDimensions, lineColor, marker, markerDimension) {
    if (markerDimension === void 0) { markerDimension = { width: 0, height: 0 }; }
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var lineProps = [];
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        // avoid rendering invalid annotation value
        if (dataValue === null || dataValue === undefined || dataValue === '') {
            return;
        }
        var annotationValueYposition = yScale.scale(dataValue);
        // avoid rendering non scalable annotation values
        if (isNaN(annotationValueYposition)) {
            return;
        }
        var _a = __read(yScale.domain, 2), domainStart = _a[0], domainEnd = _a[1];
        // avoid rendering annotation with values outside the scale domain
        if (domainStart > dataValue || domainEnd < dataValue) {
            return;
        }
        var anchor = {
            position: axisPosition,
            top: 0,
            left: 0,
        };
        var markerPosition = { top: 0, left: 0 };
        var linePathPoints = {
            start: { x1: 0, y1: 0 },
            end: { x2: 0, y2: 0 },
        };
        // the Y axis is vertical, X axis is horizontal  y|--x--|y
        if (isHorizontalChartRotation) {
            // y|__x__
            if (axisPosition === specs_1.Position.Left) {
                anchor.left = 0;
                markerPosition.left = -markerDimension.width;
                linePathPoints.start.x1 = 0;
                linePathPoints.end.x2 = chartWidth;
                // __x__|y
            }
            else {
                anchor.left = chartWidth;
                markerPosition.left = chartWidth;
                linePathPoints.start.x1 = chartWidth;
                linePathPoints.end.x2 = 0;
            }
            // __x__
            if (chartRotation === 0) {
                anchor.top = annotationValueYposition;
                markerPosition.top = annotationValueYposition - markerDimension.height / 2;
                // ¯¯x¯¯
            }
            else {
                anchor.top = chartHeight - annotationValueYposition;
                markerPosition.top = chartHeight - annotationValueYposition - markerDimension.height / 2;
            }
            linePathPoints.start.y1 = annotationValueYposition;
            linePathPoints.end.y2 = annotationValueYposition;
            // the Y axis is horizontal, X axis is vertical x|--y--|x
        }
        else {
            // ¯¯y¯¯
            if (axisPosition === specs_1.Position.Top) {
                anchor.top = 0;
                markerPosition.top = -markerDimension.height;
                linePathPoints.start.x1 = 0;
                linePathPoints.end.x2 = chartHeight;
                // __y__
            }
            else {
                anchor.top = chartHeight;
                markerPosition.top = chartHeight;
                linePathPoints.start.x1 = chartHeight;
                linePathPoints.end.x2 = 0;
            }
            // __y__|x
            if (chartRotation === -90) {
                anchor.left = annotationValueYposition;
                markerPosition.left = annotationValueYposition - markerDimension.width / 2;
                // x|__y__
            }
            else {
                anchor.left = chartWidth - annotationValueYposition;
                markerPosition.left = chartWidth - annotationValueYposition - markerDimension.width / 2;
            }
            linePathPoints.start.y1 = annotationValueYposition;
            linePathPoints.end.y2 = annotationValueYposition;
        }
        var annotationMarker = marker
            ? {
                icon: marker,
                color: lineColor,
                dimension: markerDimension,
                position: markerPosition,
            }
            : undefined;
        var lineProp = {
            anchor: anchor,
            linePathPoints: linePathPoints,
            marker: annotationMarker,
            details: {
                detailsText: datum.details,
                headerText: datum.header || dataValue.toString(),
            },
        };
        lineProps.push(lineProp);
    });
    return lineProps;
}
exports.computeYDomainLineAnnotationDimensions = computeYDomainLineAnnotationDimensions;
function computeXDomainLineAnnotationDimensions(dataValues, xScale, chartRotation, axisPosition, chartDimensions, lineColor, xScaleOffset, enableHistogramMode, marker, markerDimension) {
    if (markerDimension === void 0) { markerDimension = { width: 0, height: 0 }; }
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var lineProps = [];
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var alignWithTick = xScale.bandwidth > 0 && !enableHistogramMode;
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        var scaledXValue = annotation_utils_1.scaleAndValidateDatum(dataValue, xScale, alignWithTick);
        if (scaledXValue == null) {
            return;
        }
        var offset = xScale.bandwidth / 2 - xScaleOffset;
        var annotationValueXposition = scaledXValue + offset;
        var markerPosition = { top: 0, left: 0 };
        var linePathPoints = {
            start: { x1: 0, y1: 0 },
            end: { x2: 0, y2: 0 },
        };
        var anchor = {
            position: axisPosition,
            top: 0,
            left: 0,
        };
        // the Y axis is vertical, X axis is horizontal  y|--x--|y
        if (isHorizontalChartRotation) {
            // __x__
            if (axisPosition === specs_1.Position.Bottom) {
                linePathPoints.start.y1 = chartHeight;
                linePathPoints.end.y2 = 0;
                anchor.top = chartHeight;
                markerPosition.top = chartHeight;
                // ¯¯x¯¯
            }
            else {
                linePathPoints.start.y1 = 0;
                linePathPoints.end.y2 = chartHeight;
                anchor.top = 0;
                markerPosition.top = 0 - markerDimension.height;
            }
            // __x__
            if (chartRotation === 0) {
                anchor.left = annotationValueXposition;
                markerPosition.left = annotationValueXposition - markerDimension.width / 2;
                // ¯¯x¯¯
            }
            else {
                anchor.left = chartWidth - annotationValueXposition;
                markerPosition.left = chartWidth - annotationValueXposition - markerDimension.width / 2;
            }
            linePathPoints.start.x1 = annotationValueXposition;
            linePathPoints.end.x2 = annotationValueXposition;
            // the Y axis is horizontal, X axis is vertical x|--y--|x
        }
        else {
            // x|--y--
            if (axisPosition === specs_1.Position.Left) {
                anchor.left = 0;
                markerPosition.left = -markerDimension.width;
                linePathPoints.start.x1 = annotationValueXposition;
                linePathPoints.end.x2 = annotationValueXposition;
                // --y--|x
            }
            else {
                anchor.left = chartWidth;
                markerPosition.left = chartWidth;
                linePathPoints.start.x1 = annotationValueXposition;
                linePathPoints.end.x2 = annotationValueXposition;
            }
            // __y__|x
            if (chartRotation === -90) {
                anchor.top = chartHeight - annotationValueXposition;
                markerPosition.top = chartHeight - annotationValueXposition - markerDimension.height / 2;
                linePathPoints.start.y1 = 0;
                linePathPoints.end.y2 = chartWidth;
                // x|__y__
            }
            else {
                anchor.top = annotationValueXposition;
                markerPosition.top = annotationValueXposition - markerDimension.height / 2;
                linePathPoints.start.y1 = 0;
                linePathPoints.end.y2 = chartWidth;
            }
        }
        var annotationMarker = marker
            ? {
                icon: marker,
                color: lineColor,
                dimension: markerDimension,
                position: markerPosition,
            }
            : undefined;
        var lineProp = {
            anchor: anchor,
            linePathPoints: linePathPoints,
            details: {
                detailsText: datum.details,
                headerText: datum.header || dataValue.toString(),
            },
            marker: annotationMarker,
        };
        lineProps.push(lineProp);
    });
    return lineProps;
}
exports.computeXDomainLineAnnotationDimensions = computeXDomainLineAnnotationDimensions;
function computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, axisPosition, xScaleOffset, enableHistogramMode) {
    var domainType = annotationSpec.domainType, dataValues = annotationSpec.dataValues, marker = annotationSpec.marker, markerDimensions = annotationSpec.markerDimensions, hideLines = annotationSpec.hideLines;
    if (hideLines) {
        return null;
    }
    // this type is guaranteed as this has been merged with default
    var lineStyle = annotationSpec.style;
    var lineColor = lineStyle.line.stroke;
    if (domainType === specs_1.AnnotationDomainTypes.XDomain) {
        return computeXDomainLineAnnotationDimensions(dataValues, xScale, chartRotation, axisPosition, chartDimensions, lineColor, xScaleOffset, enableHistogramMode, marker, markerDimensions);
    }
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    return computeYDomainLineAnnotationDimensions(dataValues, yScale, chartRotation, axisPosition, chartDimensions, lineColor, marker, markerDimensions);
}
exports.computeLineAnnotationDimensions = computeLineAnnotationDimensions;
function getAnnotationLineTooltipXOffset(chartRotation, axisPosition) {
    var xOffset = 0;
    var isChartHorizontalRotation = utils_1.isHorizontalRotation(chartRotation);
    if (axis_utils_1.isHorizontalAxis(axisPosition)) {
        xOffset = isChartHorizontalRotation ? 50 : 0;
    }
    else {
        if (isChartHorizontalRotation) {
            xOffset = axisPosition === specs_1.Position.Right ? 100 : 0;
        }
        else {
            xOffset = 50;
        }
    }
    return xOffset;
}
exports.getAnnotationLineTooltipXOffset = getAnnotationLineTooltipXOffset;
function getAnnotationLineTooltipYOffset(chartRotation, axisPosition) {
    var yOffset = 0;
    var isChartHorizontalRotation = utils_1.isHorizontalRotation(chartRotation);
    if (axis_utils_1.isHorizontalAxis(axisPosition)) {
        if (isChartHorizontalRotation) {
            yOffset = axisPosition === specs_1.Position.Top ? 0 : 100;
        }
        else {
            yOffset = 50;
        }
    }
    else {
        yOffset = isChartHorizontalRotation ? 50 : 100;
    }
    return yOffset;
}
exports.getAnnotationLineTooltipYOffset = getAnnotationLineTooltipYOffset;
function isVerticalAnnotationLine(isXDomainAnnotation, isHorizontalChartRotation) {
    if (isXDomainAnnotation) {
        return isHorizontalChartRotation;
    }
    return !isHorizontalChartRotation;
}
exports.isVerticalAnnotationLine = isVerticalAnnotationLine;
/**
 * Checks if the cursorPosition is within the line annotation marker
 * @param cursorPosition the cursor position relative to the projected area
 * @param marker the line annotation marker
 */
function isWithinLineMarkerBounds(cursorPosition, marker) {
    var _a = marker.position, top = _a.top, left = _a.left;
    var _b = marker.dimension, width = _b.width, height = _b.height;
    var markerRect = { startX: left, startY: top, endX: left + width, endY: top + height };
    return rect_annotation_tooltip_1.isWithinRectBounds(cursorPosition, markerRect);
}
exports.isWithinLineMarkerBounds = isWithinLineMarkerBounds;
function computeLineAnnotationTooltipState(cursorPosition, annotationLines, groupId, domainType, axesSpecs) {
    var _a = utils_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isXDomainAnnotation = annotation_utils_1.isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    if (!annotationAxis) {
        return {
            isVisible: false,
        };
    }
    var totalAnnotationLines = annotationLines.length;
    for (var i = 0; i < totalAnnotationLines; i++) {
        var line = annotationLines[i];
        var isWithinBounds = line.marker && isWithinLineMarkerBounds(cursorPosition, line.marker);
        if (isWithinBounds) {
            return __assign(__assign({ annotationType: specs_1.AnnotationTypes.Line, isVisible: true, anchor: __assign({}, line.anchor) }, (line.details && { header: line.details.headerText })), (line.details && { details: line.details.detailsText }));
        }
    }
    return {
        isVisible: false,
    };
}
exports.computeLineAnnotationTooltipState = computeLineAnnotationTooltipState;
//# sourceMappingURL=line_annotation_tooltip.js.map