"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../utils/commons");
var specs_1 = require("../../chart_types/xy_chart/utils/specs");
var ids_1 = require("../../utils/ids");
var scales_1 = require("../../utils/scales/scales");
var chart_types_1 = require("../../chart_types");
var interactions_1 = require("../../chart_types/xy_chart/utils/interactions");
var light_theme_1 = require("../../utils/themes/light_theme");
var MockSeriesSpec = /** @class */ (function () {
    function MockSeriesSpec() {
    }
    MockSeriesSpec.bar = function (partial) {
        return commons_1.mergePartial(MockSeriesSpec.barBase, partial, { mergeOptionalPartialValues: true });
    };
    MockSeriesSpec.histogramBar = function (partial) {
        return commons_1.mergePartial(MockSeriesSpec.histogramBarBase, partial, {
            mergeOptionalPartialValues: true,
        });
    };
    MockSeriesSpec.area = function (partial) {
        return commons_1.mergePartial(MockSeriesSpec.areaBase, partial, { mergeOptionalPartialValues: true });
    };
    MockSeriesSpec.line = function (partial) {
        return commons_1.mergePartial(MockSeriesSpec.lineBase, partial, { mergeOptionalPartialValues: true });
    };
    MockSeriesSpec.byType = function (type) {
        switch (type) {
            case 'line':
                return MockSeriesSpec.lineBase;
            case 'bar':
                return MockSeriesSpec.barBase;
            case 'area':
                return MockSeriesSpec.areaBase;
            default:
                return MockSeriesSpec.barBase;
        }
    };
    MockSeriesSpec.barBase = {
        chartType: chart_types_1.ChartTypes.XYAxis,
        specType: specs_1.SpecTypes.Series,
        id: ids_1.getSpecId('spec1'),
        seriesType: specs_1.SeriesTypes.Bar,
        groupId: ids_1.getGroupId(specs_1.DEFAULT_GLOBAL_ID),
        xScaleType: scales_1.ScaleType.Ordinal,
        yScaleType: scales_1.ScaleType.Linear,
        xAccessor: 'x',
        yAccessors: ['y'],
        splitSeriesAccessors: ['g'],
        yScaleToDataExtent: false,
        hideInLegend: false,
        enableHistogramMode: false,
        stackAsPercentage: false,
        data: [],
    };
    MockSeriesSpec.histogramBarBase = {
        chartType: chart_types_1.ChartTypes.XYAxis,
        specType: specs_1.SpecTypes.Series,
        id: ids_1.getSpecId('spec1'),
        seriesType: specs_1.SeriesTypes.Bar,
        groupId: ids_1.getGroupId(specs_1.DEFAULT_GLOBAL_ID),
        xScaleType: scales_1.ScaleType.Ordinal,
        yScaleType: scales_1.ScaleType.Linear,
        xAccessor: 'x',
        yAccessors: ['y'],
        yScaleToDataExtent: false,
        hideInLegend: false,
        enableHistogramMode: true,
        data: [],
    };
    MockSeriesSpec.areaBase = {
        chartType: chart_types_1.ChartTypes.XYAxis,
        specType: specs_1.SpecTypes.Series,
        id: ids_1.getSpecId('spec1'),
        seriesType: specs_1.SeriesTypes.Area,
        groupId: ids_1.getGroupId(specs_1.DEFAULT_GLOBAL_ID),
        xScaleType: scales_1.ScaleType.Ordinal,
        yScaleType: scales_1.ScaleType.Linear,
        xAccessor: 'x',
        yAccessors: ['y'],
        yScaleToDataExtent: false,
        hideInLegend: false,
        histogramModeAlignment: specs_1.HistogramModeAlignments.Center,
        data: [],
    };
    MockSeriesSpec.lineBase = {
        chartType: chart_types_1.ChartTypes.XYAxis,
        specType: specs_1.SpecTypes.Series,
        id: ids_1.getSpecId('spec1'),
        seriesType: specs_1.SeriesTypes.Line,
        groupId: ids_1.getGroupId(specs_1.DEFAULT_GLOBAL_ID),
        xScaleType: scales_1.ScaleType.Ordinal,
        yScaleType: scales_1.ScaleType.Linear,
        xAccessor: 'x',
        yAccessors: ['y'],
        yScaleToDataExtent: false,
        hideInLegend: false,
        histogramModeAlignment: specs_1.HistogramModeAlignments.Center,
        data: [],
    };
    return MockSeriesSpec;
}());
exports.MockSeriesSpec = MockSeriesSpec;
var MockSeriesSpecs = /** @class */ (function () {
    function MockSeriesSpecs() {
    }
    MockSeriesSpecs.fromSpecs = function (specs) {
        return specs;
    };
    MockSeriesSpecs.fromPartialSpecs = function (specs) {
        return specs.map(function (_a) {
            var seriesType = _a.seriesType, spec = __rest(_a, ["seriesType"]);
            var base = MockSeriesSpec.byType(seriesType);
            return commons_1.mergePartial(base, spec, { mergeOptionalPartialValues: true });
        });
    };
    MockSeriesSpecs.empty = function () {
        return [];
    };
    return MockSeriesSpecs;
}());
exports.MockSeriesSpecs = MockSeriesSpecs;
var MockGlobalSpec = /** @class */ (function () {
    function MockGlobalSpec() {
    }
    MockGlobalSpec.settings = function (partial) {
        return commons_1.mergePartial(MockGlobalSpec.settingsBase, partial, { mergeOptionalPartialValues: true });
    };
    MockGlobalSpec.settingsBase = {
        id: '__global__settings___',
        chartType: chart_types_1.ChartTypes.Global,
        specType: specs_1.SpecTypes.Settings,
        rendering: 'canvas',
        rotation: 0,
        animateData: true,
        showLegend: false,
        resizeDebounce: 10,
        debug: false,
        tooltip: {
            type: interactions_1.TooltipType.VerticalCursor,
            snap: true,
        },
        legendPosition: specs_1.Position.Right,
        showLegendDisplayValue: true,
        hideDuplicateAxes: false,
        theme: light_theme_1.LIGHT_THEME,
    };
    return MockGlobalSpec;
}());
exports.MockGlobalSpec = MockGlobalSpec;
//# sourceMappingURL=specs.js.map