'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _throttle = require('lodash/throttle');

var _throttle2 = _interopRequireDefault(_throttle);

var _debounce = require('lodash/debounce');

var _debounce2 = _interopRequireDefault(_debounce);

var _resizeDetector = require('./resizeDetector');

var _resizeDetector2 = _interopRequireDefault(_resizeDetector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint-disable react/no-multi-comp */
/* eslint-disable react/require-default-props */

var defaultConfig = {
  monitorWidth: true,
  monitorHeight: false,
  monitorPosition: false,
  refreshRate: 16,
  refreshMode: 'throttle',
  noPlaceholder: false
};

function getDisplayName(WrappedComponent) {
  return WrappedComponent.displayName || WrappedComponent.name || 'Component';
}

/**
 * This is a utility wrapper component that will allow our higher order
 * component to get a ref handle on our wrapped components html.
 * @see https://gist.github.com/jimfb/32b587ee6177665fb4cf
 */

var ReferenceWrapper = function (_Component) {
  _inherits(ReferenceWrapper, _Component);

  function ReferenceWrapper() {
    _classCallCheck(this, ReferenceWrapper);

    return _possibleConstructorReturn(this, (ReferenceWrapper.__proto__ || Object.getPrototypeOf(ReferenceWrapper)).apply(this, arguments));
  }

  _createClass(ReferenceWrapper, [{
    key: 'render',
    value: function render() {
      return _react.Children.only(this.props.children);
    }
  }]);

  return ReferenceWrapper;
}(_react.Component);

ReferenceWrapper.displayName = 'SizeMeReferenceWrapper';

ReferenceWrapper.propTypes = { children: _propTypes2.default.element.isRequired };

function Placeholder(_ref) {
  var className = _ref.className,
      style = _ref.style;

  // Lets create the props for the temp element.
  var phProps = {};

  // We will use any provided className/style or else make the temp
  // container take the full available space.
  if (!className && !style) {
    phProps.style = { width: '100%', height: '100%' };
  } else {
    if (className) {
      phProps.className = className;
    }
    if (style) {
      phProps.style = style;
    }
  }

  return _react2.default.createElement('div', phProps);
}
Placeholder.displayName = 'SizeMePlaceholder';
Placeholder.propTypes = {
  className: _propTypes2.default.string,
  style: _propTypes2.default.object

  /**
   * As we need to maintain a ref on the root node that is rendered within our
   * SizeMe component we need to wrap our entire render in a sub component.
   * Without this, we lose the DOM ref after the placeholder is removed from
   * the render and the actual component is rendered.
   * It took me forever to figure this out, so tread extra careful on this one!
   */
};var renderWrapper = function renderWrapper(WrappedComponent) {
  function SizeMeRenderer(props) {
    var explicitRef = props.explicitRef,
        className = props.className,
        style = props.style,
        size = props.size,
        disablePlaceholder = props.disablePlaceholder,
        onSize = props.onSize,
        restProps = _objectWithoutProperties(props, ['explicitRef', 'className', 'style', 'size', 'disablePlaceholder', 'onSize']);

    var noSizeData = size == null || size.width == null && size.height == null && size.position == null;

    var renderPlaceholder = noSizeData && !disablePlaceholder;

    var renderProps = {
      className: className,
      style: style
    };

    if (size != null) {
      renderProps.size = size;
    }

    var toRender = renderPlaceholder ? _react2.default.createElement(Placeholder, { className: className, style: style }) : _react2.default.createElement(WrappedComponent, _extends({}, renderProps, restProps));

    return _react2.default.createElement(
      ReferenceWrapper,
      { ref: explicitRef },
      toRender
    );
  }

  SizeMeRenderer.displayName = 'SizeMeRenderer(' + getDisplayName(WrappedComponent) + ')';

  SizeMeRenderer.propTypes = {
    explicitRef: _propTypes2.default.func.isRequired,
    className: _propTypes2.default.string,
    style: _propTypes2.default.object, // eslint-disable-line react/forbid-prop-types
    size: _propTypes2.default.shape({
      width: _propTypes2.default.number, // eslint-disable-line react/no-unused-prop-types
      height: _propTypes2.default.number // eslint-disable-line react/no-unused-prop-types
    }),
    disablePlaceholder: _propTypes2.default.bool,
    onSize: _propTypes2.default.func
  };

  return SizeMeRenderer;
};

/**
 * :: config -> Component -> WrappedComponent
 *
 * Higher order component that allows the wrapped component to become aware
 * of it's size, by receiving it as an object within it's props.
 *
 * @param  monitorWidth
 *   Default true, whether changes in the element's width should be monitored,
 *   causing a size property to be broadcast.
 * @param  monitorHeight
 *   Default false, whether changes in the element's height should be monitored,
 *   causing a size property to be broadcast.
 *
 * @return The wrapped component.
 */
function sizeMe() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultConfig;
  var _config$monitorWidth = config.monitorWidth,
      monitorWidth = _config$monitorWidth === undefined ? defaultConfig.monitorWidth : _config$monitorWidth,
      _config$monitorHeight = config.monitorHeight,
      monitorHeight = _config$monitorHeight === undefined ? defaultConfig.monitorHeight : _config$monitorHeight,
      _config$monitorPositi = config.monitorPosition,
      monitorPosition = _config$monitorPositi === undefined ? defaultConfig.monitorPosition : _config$monitorPositi,
      _config$refreshRate = config.refreshRate,
      refreshRate = _config$refreshRate === undefined ? defaultConfig.refreshRate : _config$refreshRate,
      _config$refreshMode = config.refreshMode,
      refreshMode = _config$refreshMode === undefined ? defaultConfig.refreshMode : _config$refreshMode,
      _config$noPlaceholder = config.noPlaceholder,
      noPlaceholder = _config$noPlaceholder === undefined ? defaultConfig.noPlaceholder : _config$noPlaceholder;


  (0, _invariant2.default)(monitorWidth || monitorHeight || monitorPosition, 'You have to monitor at least one of the width, height, or position when using "sizeMe"');

  (0, _invariant2.default)(refreshRate >= 16, "It is highly recommended that you don't put your refreshRate lower than " + '16 as this may cause layout thrashing.');

  (0, _invariant2.default)(refreshMode === 'throttle' || refreshMode === 'debounce', 'The refreshMode should have a value of "throttle" or "debounce"');

  var refreshDelayStrategy = refreshMode === 'throttle' ? _throttle2.default : _debounce2.default;

  return function WrapComponent(WrappedComponent) {
    var SizeMeRenderWrapper = renderWrapper(WrappedComponent);

    var SizeAwareComponent = function (_React$Component) {
      _inherits(SizeAwareComponent, _React$Component);

      function SizeAwareComponent() {
        var _ref2;

        var _temp, _this2, _ret;

        _classCallCheck(this, SizeAwareComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref2 = SizeAwareComponent.__proto__ || Object.getPrototypeOf(SizeAwareComponent)).call.apply(_ref2, [this].concat(args))), _this2), _this2.state = {
          width: undefined,
          height: undefined,
          position: undefined
        }, _this2.determineStrategy = function (props) {
          if (props.onSize) {
            if (!_this2.callbackState) {
              _this2.callbackState = _extends({}, _this2.state);
            }
            _this2.strategy = 'callback';
          } else {
            _this2.strategy = 'render';
          }
        }, _this2.strategisedSetState = function (state) {
          if (_this2.strategy === 'callback') {
            _this2.callbackState = state;
            _this2.props.onSize(state);
          } else {
            _this2.setState(state);
          }
        }, _this2.strategisedGetState = function () {
          return _this2.strategy === 'callback' ? _this2.callbackState : _this2.state;
        }, _this2.refCallback = function (element) {
          _this2.element = element;
        }, _this2.hasSizeChanged = function (current, next) {
          var c = current;
          var n = next;
          var cp = c.position || {};
          var np = n.position || {};

          return monitorHeight && c.height !== n.height || monitorPosition && (cp.top !== np.top || cp.left !== np.left || cp.bottom !== np.bottom || cp.right !== np.right) || monitorWidth && c.width !== n.width;
        }, _this2.checkIfSizeChanged = refreshDelayStrategy(function (el) {
          var _el$getBoundingClient = el.getBoundingClientRect(),
              width = _el$getBoundingClient.width,
              height = _el$getBoundingClient.height,
              right = _el$getBoundingClient.right,
              left = _el$getBoundingClient.left,
              top = _el$getBoundingClient.top,
              bottom = _el$getBoundingClient.bottom;

          var next = {
            width: monitorWidth ? width : null,
            height: monitorHeight ? height : null,
            position: monitorPosition ? { right: right, left: left, top: top, bottom: bottom } : null
          };

          if (_this2.hasSizeChanged(_this2.strategisedGetState(), next)) {
            _this2.strategisedSetState(next);
          }
        }, refreshRate), _temp), _possibleConstructorReturn(_this2, _ret);
      }

      _createClass(SizeAwareComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
          this.determineStrategy(this.props);
          this.handleDOMNode();
        }
      }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
          this.determineStrategy(nextProps);
        }
      }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
          this.handleDOMNode();
        }
      }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
          // Change our size checker to a noop just in case we have some
          // late running events.
          this.hasSizeChanged = function () {
            return undefined;
          };
          this.checkIfSizeChanged = function () {
            return undefined;
          };

          if (this.domEl) {
            (0, _resizeDetector2.default)().removeAllListeners(this.domEl);
            this.domEl = null;
          }
        }
      }, {
        key: 'handleDOMNode',
        value: function handleDOMNode() {
          var found = this.element &&
          // One day this will be deprecated then I will be forced into wrapping
          // the component with a div or such in order to get a dome element handle.
          _reactDom2.default.findDOMNode(this.element); // eslint-disable-line react/no-find-dom-node

          if (!found) {
            // This is for special cases where the element may be null.
            if (this.domEl) {
              (0, _resizeDetector2.default)().removeAllListeners(this.domEl);
              this.domEl = null;
            }
            return;
          }

          if (this.domEl) {
            (0, _resizeDetector2.default)().removeAllListeners(this.domEl);
          }

          this.domEl = found;
          (0, _resizeDetector2.default)().listenTo(this.domEl, this.checkIfSizeChanged);
        }
      }, {
        key: 'render',
        value: function render() {
          var disablePlaceholder = sizeMe.enableSSRBehaviour || sizeMe.noPlaceholders || noPlaceholder || this.strategy === 'callback';

          var size = _extends({}, this.state);

          return _react2.default.createElement(SizeMeRenderWrapper, _extends({
            explicitRef: this.refCallback,
            size: this.strategy === 'callback' ? null : size,
            disablePlaceholder: disablePlaceholder
          }, this.props));
        }
      }]);

      return SizeAwareComponent;
    }(_react2.default.Component);

    SizeAwareComponent.displayName = 'SizeMe(' + getDisplayName(WrappedComponent) + ')';
    SizeAwareComponent.propTypes = {
      onSize: _propTypes2.default.func
    };


    SizeAwareComponent.WrappedComponent = WrappedComponent;

    return SizeAwareComponent;
  };
}

/**
 * Allow SizeMe to run within SSR environments.  This is a "global" behaviour
 * flag that should be set within the initialisation phase of your application.
 *
 * Warning: don't set this flag unless you need to as using it may cause
 * extra render cycles to happen within your components depending on the logic
 * contained within them around the usage of the `size` data.
 *
 * DEPRECATED: Please use the global disablePlaceholders
 */
sizeMe.enableSSRBehaviour = false;

/**
 * Global configuration allowing to disable placeholder rendering for all
 * sizeMe components.
 */
sizeMe.noPlaceholders = false;

exports.default = sizeMe;