/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.aggregator.AggregatorInstance;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.OrderComparator;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.factories.CapacityLimitedInMemoryFactory;
import net.sf.ehcache.transaction.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryOnlyStore
extends CompoundStore
implements CacheConfigurationListener {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Map<String, AttributeExtractor> attributeExtractors = new ConcurrentHashMap<String, AttributeExtractor>();
    private final CapacityLimitedInMemoryFactory memoryFactory;
    private final CacheConfiguration config;
    private final Map<String, Attribute> searchAttributes = new ConcurrentHashMap<String, Attribute>();

    private MemoryOnlyStore(CapacityLimitedInMemoryFactory memory, CacheConfiguration config) {
        super(memory, config.isCopyOnRead(), config.isCopyOnWrite(), config.getCopyStrategy());
        this.memoryFactory = memory;
        this.config = config;
    }

    public static MemoryOnlyStore create(Cache cache, String diskStorePath) {
        CacheConfiguration config = cache.getCacheConfiguration();
        CapacityLimitedInMemoryFactory memory = new CapacityLimitedInMemoryFactory(null, config.getMaxElementsInMemory(), MemoryOnlyStore.determineEvictionPolicy(config), cache.getCacheEventNotificationService());
        MemoryOnlyStore store = new MemoryOnlyStore(memory, config);
        cache.getCacheConfiguration().addConfigurationListener(store);
        return store;
    }

    private static final Policy determineEvictionPolicy(CacheConfiguration config) {
        MemoryStoreEvictionPolicy policySelection = config.getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    @Override
    public boolean bufferFull() {
        return false;
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        this.memoryFactory.expireElements();
    }

    @Override
    public void flush() throws IOException {
        if (this.config.isClearOnFlush()) {
            this.removeAll();
        }
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.memoryFactory.getEvictionPolicy();
    }

    @Override
    public int getInMemorySize() {
        return this.getSize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.memoryFactory.getSizeInBytes();
    }

    @Override
    public int getOnDiskSize() {
        return 0;
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.memoryFactory.setEvictionPolicy(policy);
    }

    @Override
    public void deregistered(CacheConfiguration config) {
    }

    @Override
    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
    }

    @Override
    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    @Override
    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.memoryFactory.setCapacity(newCapacity);
    }

    @Override
    public void registered(CacheConfiguration config) {
    }

    @Override
    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
    }

    @Override
    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.attributeExtractors.putAll(extractors);
        for (String name : extractors.keySet()) {
            this.searchAttributes.put(name, new Attribute(name));
        }
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        Criteria c = query.getCriteria();
        List<AggregatorInstance<?>> aggregators = query.getAggregatorInstances();
        boolean includeResults = query.requestsKeys() || query.requestsValues() || !query.requestedAttributes().isEmpty();
        ArrayList<Result> results = new ArrayList<Result>();
        boolean hasOrder = !query.getOrdering().isEmpty();
        boolean anyMatches = false;
        for (Element element : this.elementSet()) {
            if (!hasOrder && query.maxResults() >= 0 && results.size() == query.maxResults()) break;
            if (element.getObjectValue() instanceof SoftLock || !c.execute(element, this.attributeExtractors)) continue;
            anyMatches = true;
            if (includeResults) {
                Object[] sortAttributes;
                Map<String, Object> attributes;
                if (query.requestedAttributes().isEmpty()) {
                    attributes = Collections.emptyMap();
                } else {
                    attributes = new HashMap();
                    for (Attribute<?> attribute : query.requestedAttributes()) {
                        String name = attribute.getAttributeName();
                        attributes.put(name, this.attributeExtractors.get(name).attributeFor(element));
                    }
                }
                List<StoreQuery.Ordering> orderings = query.getOrdering();
                if (orderings.isEmpty()) {
                    sortAttributes = EMPTY_OBJECT_ARRAY;
                } else {
                    sortAttributes = new Object[orderings.size()];
                    for (int i = 0; i < sortAttributes.length; ++i) {
                        String name = orderings.get(i).getAttribute().getAttributeName();
                        sortAttributes[i] = this.attributeExtractors.get(name).attributeFor(element);
                    }
                }
                results.add(new ResultImpl(element.getObjectKey(), element.getObjectValue(), query, attributes, sortAttributes));
            }
            for (AggregatorInstance<?> aggregator : aggregators) {
                Attribute<?> attribute;
                attribute = aggregator.getAttribute();
                if (attribute == null) {
                    aggregator.accept(null);
                    continue;
                }
                Object val = this.attributeExtractors.get(attribute.getAttributeName()).attributeFor(element);
                aggregator.accept(val);
            }
        }
        if (hasOrder) {
            Collections.sort(results, new OrderComparator(query.getOrdering()));
            int max = query.maxResults();
            if (max >= 0 && results.size() > max) {
                results.subList(max, results.size()).clear();
                results.trimToSize();
            }
        }
        ArrayList<Object> aggregateResults = aggregators.isEmpty() ? Collections.emptyList() : new ArrayList<Object>();
        for (AggregatorInstance<?> aggregator : aggregators) {
            aggregateResults.add(aggregator.aggregateResult());
        }
        if (anyMatches && !includeResults && !aggregateResults.isEmpty()) {
            results.add(new AggregateOnlyResult(query));
        }
        if (!aggregateResults.isEmpty()) {
            for (Result result : results) {
                ((BaseResult)result).setAggregateResults(aggregateResults);
            }
        }
        return new ResultsImpl(results, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), anyMatches && !aggregateResults.isEmpty());
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        return this.searchAttributes.get(attributeName);
    }
}

