/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.chain.web.MapEntry;

final class ServletParamMap
implements Map {
    private HttpServletRequest request = null;

    public ServletParamMap(HttpServletRequest request) {
        this.request = request;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.request.getParameter(this.key(key)) != null;
    }

    public boolean containsValue(Object value) {
        Iterator values = this.values().iterator();
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MapEntry> set = new HashSet<MapEntry>();
        Enumeration<String> keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            set.add(new MapEntry(key, this.request.getParameter(key), false));
        }
        return set;
    }

    public boolean equals(Object o) {
        return this.request.equals(o);
    }

    public Object get(Object key) {
        return this.request.getParameter(this.key(key));
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration<String> keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        int n = 0;
        Enumeration<String> keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    public Collection values() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            list.add(this.request.getParameter(keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

