/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.solr.handler.sql.SolrSchema;

public class CalciteSolrDriver
extends Driver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcitesolr:";

    private CalciteSolrDriver() {
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Connection connection = super.connect(url, info);
        CalciteConnection calciteConnection = (CalciteConnection)connection;
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        String schemaName = info.getProperty("zk");
        if (schemaName == null) {
            throw new SQLException("zk must be set");
        }
        rootSchema.add(schemaName, (Schema)new SolrSchema(info));
        calciteConnection.setSchema(schemaName);
        return connection;
    }

    static {
        new CalciteSolrDriver().register();
    }
}

