/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.ExactStatsCache;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.search.stats.StatsUtil;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUStatsCache
extends ExactStatsCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_MAX_SIZE = 200;
    public static final int DEFAULT_MAX_IDLE_TIME = 60;
    private final Map<String, SolrCache<String, TermStats>> perShardTermStats = new ConcurrentHashMap<String, SolrCache<String, TermStats>>();
    private final Map<String, Map<String, CollectionStats>> perShardColStats = new ConcurrentHashMap<String, Map<String, CollectionStats>>();
    private final FastLRUCache<String, TermStats> currentGlobalTermStats = new FastLRUCache();
    private final FastLRUCache<String, CollectionStats> currentGlobalColStats = new FastLRUCache();
    private Set<String> missingColStats = ConcurrentHashMap.newKeySet();
    private Set<Term> missingTermStats = ConcurrentHashMap.newKeySet();
    private final Map<String, String> lruCacheInitArgs = new HashMap<String, String>();
    private final StatsCache.StatsCacheMetrics ignorableMetrics = new StatsCache.StatsCacheMetrics();

    @Override
    protected StatsSource doGet(SolrQueryRequest req) {
        log.debug("## GET total={}, cache {}", this.currentGlobalColStats, (Object)this.currentGlobalTermStats.size());
        return new LRUStatsSource(this.statsCacheMetrics);
    }

    @Override
    public void clear() {
        super.clear();
        this.perShardTermStats.clear();
        this.perShardColStats.clear();
        this.currentGlobalTermStats.clear();
        this.currentGlobalColStats.clear();
        this.ignorableMetrics.clear();
    }

    @Override
    public void init(PluginInfo info) {
        super.init(info);
        if (info != null && info.attributes != null) {
            this.lruCacheInitArgs.putAll(info.attributes);
        }
        this.lruCacheInitArgs.computeIfAbsent("size", s -> String.valueOf(200));
        this.lruCacheInitArgs.computeIfAbsent("maxIdleTime", t -> String.valueOf(60));
        HashMap<String, String> map = new HashMap<String, String>(this.lruCacheInitArgs);
        map.put("name", "globalTermStats");
        this.currentGlobalTermStats.init(this.lruCacheInitArgs, null, null);
        this.currentGlobalTermStats.setState(SolrCache.State.LIVE);
        map = new HashMap<String, String>(this.lruCacheInitArgs);
        map.put("name", "globalColStats");
        this.currentGlobalColStats.init(this.lruCacheInitArgs, null, null);
        this.currentGlobalColStats.setState(SolrCache.State.LIVE);
    }

    @Override
    protected ShardRequest doRetrieveStatsRequest(ResponseBuilder rb) {
        if (!this.missingColStats.isEmpty() || !this.missingColStats.isEmpty()) {
            ShardRequest sreq = super.doRetrieveStatsRequest(rb);
            if (!this.missingColStats.isEmpty()) {
                Set<String> requestColStats = this.missingColStats;
                this.missingColStats = ConcurrentHashMap.newKeySet();
                sreq.params.add("solr.stats.fields", new String[]{StatsUtil.fieldsToString(requestColStats)});
            }
            if (!this.missingTermStats.isEmpty()) {
                Set<Term> requestTermStats = this.missingTermStats;
                this.missingTermStats = ConcurrentHashMap.newKeySet();
                sreq.params.add("solr.stats.terms", new String[]{StatsUtil.termsToEncodedString(requestTermStats)});
            }
            return sreq;
        }
        LongAdder missing = new LongAdder();
        try {
            this.approxCheckMissingStats(rb, new LRUStatsSource(this.ignorableMetrics), t -> missing.increment(), f -> missing.increment());
            if (missing.sum() == 0L) {
                this.statsCacheMetrics.retrieveStats.decrement();
                this.statsCacheMetrics.useCachedGlobalStats.increment();
                return null;
            }
            return super.doRetrieveStatsRequest(rb);
        }
        catch (IOException e) {
            log.warn("Exception checking missing stats for query " + rb.getQuery() + ", forcing retrieving stats", (Throwable)e);
            return super.doRetrieveStatsRequest(rb);
        }
    }

    @Override
    protected void addToGlobalTermStats(SolrQueryRequest req, Map.Entry<String, TermStats> e) {
        this.currentGlobalTermStats.put(e.getKey(), e.getValue());
    }

    @Override
    protected void addToPerShardColStats(SolrQueryRequest req, String shard, Map<String, CollectionStats> colStats) {
        this.perShardColStats.put(shard, colStats);
    }

    @Override
    protected Map<String, CollectionStats> getPerShardColStats(ResponseBuilder rb, String shard) {
        return this.perShardColStats.get(shard);
    }

    @Override
    protected void addToPerShardTermStats(SolrQueryRequest req, String shard, String termStatsString) {
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(termStatsString);
        if (termStats != null) {
            SolrCache cache = this.perShardTermStats.computeIfAbsent(shard, s -> {
                FastLRUCache c = new FastLRUCache();
                HashMap<String, String> map = new HashMap<String, String>(this.lruCacheInitArgs);
                map.put("name", (String)s);
                c.init(map, null, null);
                c.setState(SolrCache.State.LIVE);
                return c;
            });
            for (Map.Entry<String, TermStats> e : termStats.entrySet()) {
                cache.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    protected TermStats getPerShardTermStats(SolrQueryRequest req, String t, String shard) {
        SolrCache<String, TermStats> cache = this.perShardTermStats.get(shard);
        return cache != null ? cache.get(t) : null;
    }

    @Override
    protected void addToGlobalColStats(SolrQueryRequest req, Map.Entry<String, CollectionStats> e) {
        this.currentGlobalColStats.put(e.getKey(), e.getValue());
    }

    @Override
    protected void printStats(SolrQueryRequest req) {
        log.debug("## MERGED: perShardColStats={}, perShardTermStats={}", this.perShardColStats, this.perShardTermStats);
    }

    class LRUStatsSource
    extends StatsSource {
        private final StatsCache.StatsCacheMetrics metrics;

        LRUStatsSource(StatsCache.StatsCacheMetrics metrics) {
            this.metrics = metrics;
        }

        @Override
        public TermStatistics termStatistics(SolrIndexSearcher localSearcher, Term term, int docFreq, long totalTermFreq) throws IOException {
            TermStats termStats = (TermStats)LRUStatsCache.this.currentGlobalTermStats.get(term.toString());
            if (termStats == null) {
                log.debug("## Missing global termStats info: {}, using local", (Object)term);
                LRUStatsCache.this.missingTermStats.add(term);
                this.metrics.missingGlobalTermStats.increment();
                return localSearcher != null ? localSearcher.localTermStatistics(term, docFreq, totalTermFreq) : null;
            }
            return termStats.toTermStatistics();
        }

        @Override
        public CollectionStatistics collectionStatistics(SolrIndexSearcher localSearcher, String field) throws IOException {
            CollectionStats colStats = (CollectionStats)LRUStatsCache.this.currentGlobalColStats.get(field);
            if (colStats == null) {
                log.debug("## Missing global colStats info: {}, using local", (Object)field);
                LRUStatsCache.this.missingColStats.add(field);
                this.metrics.missingGlobalFieldStats.increment();
                return localSearcher != null ? localSearcher.localCollectionStatistics(field) : null;
            }
            return colStats.toCollectionStatistics();
        }
    }
}

