/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToIntFunction;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.MockRandomMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NullInfoStream;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

public abstract class BaseMergePolicyTestCase
extends LuceneTestCase {
    private static final Directory FAKE_DIRECTORY = new Directory(){

        public String[] listAll() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(String name) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long fileLength(String name) throws IOException {
            if (name.endsWith(".liv")) {
                return 0L;
            }
            if (!name.endsWith(".fake")) {
                throw new IllegalArgumentException(name);
            }
            int startIndex = name.indexOf("_size=") + "_size=".length();
            int endIndex = name.length() - ".fake".length();
            return Long.parseLong(name.substring(startIndex, endIndex));
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sync(Collection<String> names) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void rename(String source, String dest) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void syncMetaData() throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Lock obtainLock(String name) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Set<String> getPendingDeletions() throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    protected abstract MergePolicy mergePolicy();

    protected abstract void assertSegmentInfos(MergePolicy var1, SegmentInfos var2) throws IOException;

    protected abstract void assertMerge(MergePolicy var1, MergePolicy.MergeSpecification var2) throws IOException;

    public void testForceMergeNotNeeded() throws IOException {
        try (BaseDirectoryWrapper dir = BaseMergePolicyTestCase.newDirectory();){
            int i;
            final AtomicBoolean mayMerge = new AtomicBoolean(true);
            SerialMergeScheduler mergeScheduler = new SerialMergeScheduler(){

                public synchronized void merge(IndexWriter writer, MergeTrigger trigger, boolean newMergesFound) throws IOException {
                    MergePolicy.OneMerge merge;
                    if (!mayMerge.get() && (merge = writer.getNextMerge()) != null) {
                        System.out.println("TEST: we should not need any merging, yet merge policy returned merge " + merge);
                        throw new AssertionError();
                    }
                    super.merge(writer, trigger, newMergesFound);
                }
            };
            MergePolicy mp = this.mergePolicy();
            BaseMergePolicyTestCase.assumeFalse("this test cannot tolerate random forceMerges", mp.toString().contains("MockRandomMergePolicy"));
            mp.setNoCFSRatio(BaseMergePolicyTestCase.random().nextBoolean() ? 0.0 : 1.0);
            IndexWriterConfig iwc = BaseMergePolicyTestCase.newIndexWriterConfig(new MockAnalyzer(BaseMergePolicyTestCase.random()));
            iwc.setMergeScheduler((MergeScheduler)mergeScheduler);
            iwc.setMergePolicy(mp);
            IndexWriter writer = new IndexWriter((Directory)dir, iwc);
            int numSegments = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 2, 20);
            for (i = 0; i < numSegments; ++i) {
                int numDocs = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 5);
                for (int j = 0; j < numDocs; ++j) {
                    writer.addDocument((Iterable)new Document());
                }
                writer.getReader().close();
            }
            for (i = 5; i >= 0; --i) {
                int segmentCount = writer.getSegmentCount();
                int maxNumSegments = i == 0 ? 1 : TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 10);
                mayMerge.set(segmentCount > maxNumSegments);
                if (VERBOSE) {
                    System.out.println("TEST: now forceMerge(maxNumSegments=" + maxNumSegments + ") vs segmentCount=" + segmentCount);
                }
                writer.forceMerge(maxNumSegments);
            }
            writer.close();
        }
    }

    public void testFindForcedDeletesMerges() throws IOException {
        MergePolicy mp = this.mergePolicy();
        if (mp instanceof FilterMergePolicy) {
            BaseMergePolicyTestCase.assumeFalse("test doesn't work with MockRandomMP", ((FilterMergePolicy)mp).in instanceof MockRandomMergePolicy);
        }
        SegmentInfos infos = new SegmentInfos(Version.LATEST.major);
        try (BaseDirectoryWrapper directory = BaseMergePolicyTestCase.newDirectory();){
            MockMergeContext context = new MockMergeContext(s -> 0);
            int numSegs = BaseMergePolicyTestCase.random().nextInt(10);
            for (int i = 0; i < numSegs; ++i) {
                SegmentInfo info = new SegmentInfo((Directory)directory, Version.LATEST, Version.LATEST, TestUtil.randomSimpleString(BaseMergePolicyTestCase.random()), BaseMergePolicyTestCase.random().nextInt(Integer.MAX_VALUE), BaseMergePolicyTestCase.random().nextBoolean(), null, Collections.emptyMap(), TestUtil.randomSimpleString(BaseMergePolicyTestCase.random(), 16, 16).getBytes(StandardCharsets.US_ASCII), Collections.emptyMap(), null);
                info.setFiles(Collections.emptyList());
                infos.add(new SegmentCommitInfo(info, BaseMergePolicyTestCase.random().nextInt(1), 0, -1L, -1L, -1L));
            }
            MergePolicy.MergeSpecification forcedDeletesMerges = mp.findForcedDeletesMerges(infos, (MergePolicy.MergeContext)context);
            if (forcedDeletesMerges != null) {
                BaseMergePolicyTestCase.assertEquals((long)0L, (long)forcedDeletesMerges.merges.size());
            }
        }
    }

    protected static SegmentCommitInfo makeSegmentCommitInfo(String name, int maxDoc, int numDeletedDocs, double sizeMB, String source) {
        if (!name.startsWith("_")) {
            throw new IllegalArgumentException("name must start with an _, got " + name);
        }
        byte[] id = new byte[16];
        BaseMergePolicyTestCase.random().nextBytes(id);
        SegmentInfo info = new SegmentInfo(FAKE_DIRECTORY, Version.LATEST, Version.LATEST, name, maxDoc, false, TestUtil.getDefaultCodec(), Collections.emptyMap(), id, Collections.singletonMap("source", source), null);
        info.setFiles(Collections.singleton(name + "_size=" + Long.toString((long)(sizeMB * 1024.0 * 1024.0)) + ".fake"));
        return new SegmentCommitInfo(info, numDeletedDocs, 0, 0L, 0L, 0L);
    }

    protected static SegmentInfos applyMerge(SegmentInfos infos, MergePolicy.OneMerge merge, String mergedSegmentName, IOStats stats) throws IOException {
        LinkedHashSet scis = new LinkedHashSet(infos.asList());
        int newMaxDoc = 0;
        double newSize = 0.0;
        for (SegmentCommitInfo sci : merge.segments) {
            int numLiveDocs = sci.info.maxDoc() - sci.getDelCount();
            newSize += (double)sci.sizeInBytes() * (double)numLiveDocs / (double)sci.info.maxDoc() / 1024.0 / 1024.0;
            newMaxDoc += numLiveDocs;
            boolean removed = scis.remove(sci);
            BaseMergePolicyTestCase.assertTrue((boolean)removed);
        }
        SegmentInfos newInfos = new SegmentInfos(Version.LATEST.major);
        newInfos.addAll(scis);
        newInfos.add(BaseMergePolicyTestCase.makeSegmentCommitInfo(mergedSegmentName, newMaxDoc, 0, newSize, "merge"));
        stats.mergeBytesWritten = (long)((double)stats.mergeBytesWritten + newSize * 1024.0 * 1024.0);
        return newInfos;
    }

    protected static SegmentInfos applyDeletes(SegmentInfos infos, int numDeletes) {
        List infoList = infos.asList();
        int totalNumDocs = infoList.stream().mapToInt(s -> s.info.maxDoc() - s.getDelCount()).sum();
        if (numDeletes > totalNumDocs) {
            throw new IllegalArgumentException("More deletes than documents");
        }
        double w = (double)numDeletes / (double)totalNumDocs;
        ArrayList<SegmentCommitInfo> newInfoList = new ArrayList<SegmentCommitInfo>();
        for (int i = 0; i < infoList.size(); ++i) {
            assert (numDeletes >= 0);
            SegmentCommitInfo sci = (SegmentCommitInfo)infoList.get(i);
            int segDeletes = i == infoList.size() - 1 ? numDeletes : Math.min(numDeletes, (int)Math.ceil(w * (double)(sci.info.maxDoc() - sci.getDelCount())));
            int newDelCount = sci.getDelCount() + segDeletes;
            assert (newDelCount <= sci.info.maxDoc());
            if (newDelCount < sci.info.maxDoc()) {
                SegmentCommitInfo newInfo = new SegmentCommitInfo(sci.info, sci.getDelCount() + segDeletes, 0, sci.getDelGen() + 1L, sci.getFieldInfosGen(), sci.getDocValuesGen());
                newInfoList.add(newInfo);
            }
            numDeletes -= segDeletes;
        }
        assert (numDeletes == 0);
        SegmentInfos newInfos = new SegmentInfos(Version.LATEST.major);
        newInfos.addAll(newInfoList);
        return newInfos;
    }

    public void testSimulateAppendOnly() throws IOException {
        this.doTestSimulateAppendOnly(this.mergePolicy(), 100000000, 10000);
    }

    protected void doTestSimulateAppendOnly(MergePolicy mergePolicy, int totalDocs, int maxDocsPerFlush) throws IOException {
        IOStats stats = new IOStats();
        AtomicLong segNameGenerator = new AtomicLong();
        MockMergeContext mergeContext = new MockMergeContext(SegmentCommitInfo::getDelCount);
        SegmentInfos segmentInfos = new SegmentInfos(Version.LATEST.major);
        double avgDocSizeMB = 0.0048828125;
        int numDocs = 0;
        while (numDocs < totalDocs) {
            int flushDocCount = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, maxDocsPerFlush);
            numDocs += flushDocCount;
            double flushSizeMB = (double)flushDocCount * 0.0048828125;
            stats.flushBytesWritten = (long)((double)stats.flushBytesWritten + flushSizeMB * 1024.0 * 1024.0);
            segmentInfos.add(BaseMergePolicyTestCase.makeSegmentCommitInfo("_" + segNameGenerator.getAndIncrement(), flushDocCount, 0, flushSizeMB, "flush"));
            MergePolicy.MergeSpecification merges = mergePolicy.findMerges(MergeTrigger.SEGMENT_FLUSH, segmentInfos, (MergePolicy.MergeContext)mergeContext);
            while (merges != null) {
                BaseMergePolicyTestCase.assertTrue((merges.merges.size() > 0 ? 1 : 0) != 0);
                this.assertMerge(mergePolicy, merges);
                for (MergePolicy.OneMerge oneMerge : merges.merges) {
                    segmentInfos = BaseMergePolicyTestCase.applyMerge(segmentInfos, oneMerge, "_" + segNameGenerator.getAndIncrement(), stats);
                }
                merges = mergePolicy.findMerges(MergeTrigger.MERGE_FINISHED, segmentInfos, (MergePolicy.MergeContext)mergeContext);
            }
            this.assertSegmentInfos(mergePolicy, segmentInfos);
        }
        if (VERBOSE) {
            System.out.println("Write amplification for append-only: " + (double)(stats.flushBytesWritten + stats.mergeBytesWritten) / (double)stats.flushBytesWritten);
        }
    }

    public void testSimulateUpdates() throws IOException {
        int numDocs = BaseMergePolicyTestCase.atLeast(1000000);
        this.doTestSimulateUpdates(this.mergePolicy(), numDocs, 2500);
    }

    protected void doTestSimulateUpdates(MergePolicy mergePolicy, int totalDocs, int maxDocsPerFlush) throws IOException {
        IOStats stats = new IOStats();
        AtomicLong segNameGenerator = new AtomicLong();
        MockMergeContext mergeContext = new MockMergeContext(SegmentCommitInfo::getDelCount);
        SegmentInfos segmentInfos = new SegmentInfos(Version.LATEST.major);
        double avgDocSizeMB = 0.0048828125;
        int numDocs = 0;
        while (numDocs < totalDocs) {
            int flushDocCount = BaseMergePolicyTestCase.usually() ? TestUtil.nextInt(BaseMergePolicyTestCase.random(), maxDocsPerFlush / 2, maxDocsPerFlush) : TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, maxDocsPerFlush);
            int delCount = (int)((double)flushDocCount * 0.9 * (double)numDocs / (double)totalDocs);
            numDocs += flushDocCount - delCount;
            segmentInfos = BaseMergePolicyTestCase.applyDeletes(segmentInfos, delCount);
            double flushSize = (double)flushDocCount * 0.0048828125;
            stats.flushBytesWritten = (long)((double)stats.flushBytesWritten + flushSize * 1024.0 * 1024.0);
            segmentInfos.add(BaseMergePolicyTestCase.makeSegmentCommitInfo("_" + segNameGenerator.getAndIncrement(), flushDocCount, 0, flushSize, "flush"));
            MergePolicy.MergeSpecification merges = mergePolicy.findMerges(MergeTrigger.SEGMENT_FLUSH, segmentInfos, (MergePolicy.MergeContext)mergeContext);
            while (merges != null) {
                this.assertMerge(mergePolicy, merges);
                for (MergePolicy.OneMerge oneMerge : merges.merges) {
                    segmentInfos = BaseMergePolicyTestCase.applyMerge(segmentInfos, oneMerge, "_" + segNameGenerator.getAndIncrement(), stats);
                }
                merges = mergePolicy.findMerges(MergeTrigger.MERGE_FINISHED, segmentInfos, (MergePolicy.MergeContext)mergeContext);
            }
            this.assertSegmentInfos(mergePolicy, segmentInfos);
        }
        if (VERBOSE) {
            System.out.println("Write amplification for update: " + (double)(stats.flushBytesWritten + stats.mergeBytesWritten) / (double)stats.flushBytesWritten);
            int totalDelCount = segmentInfos.asList().stream().mapToInt(SegmentCommitInfo::getDelCount).sum();
            int totalMaxDoc = segmentInfos.asList().stream().map(s -> s.info).mapToInt(SegmentInfo::maxDoc).sum();
            System.out.println("Final live ratio: " + (1.0 - (double)totalDelCount / (double)totalMaxDoc));
        }
    }

    public static class IOStats {
        long flushBytesWritten;
        long mergeBytesWritten;
    }

    public static final class MockMergeContext
    implements MergePolicy.MergeContext {
        private final ToIntFunction<SegmentCommitInfo> numDeletesFunc;
        private final InfoStream infoStream = new NullInfoStream(){

            @Override
            public boolean isEnabled(String component) {
                return false;
            }
        };
        private Set<SegmentCommitInfo> mergingSegments = Collections.emptySet();

        public MockMergeContext(ToIntFunction<SegmentCommitInfo> numDeletesFunc) {
            this.numDeletesFunc = numDeletesFunc;
        }

        public int numDeletesToMerge(SegmentCommitInfo info) {
            return this.numDeletesFunc.applyAsInt(info);
        }

        public int numDeletedDocs(SegmentCommitInfo info) {
            return this.numDeletesToMerge(info);
        }

        public InfoStream getInfoStream() {
            return this.infoStream;
        }

        public Set<SegmentCommitInfo> getMergingSegments() {
            return this.mergingSegments;
        }

        public void setMergingSegments(Set<SegmentCommitInfo> mergingSegments) {
            this.mergingSegments = mergingSegments;
        }
    }
}

