/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseServiceUtils;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateProcedureStatement;

@DatabaseChange(name="createTrigger", description="Creates a stored trigger", priority=101, appliesTo={"trigger"})
public class CreateTriggerChange
extends CreateProcedureChange {
    private String triggerName;
    private String triggerBody;
    private Boolean disabled;
    private String tableName;
    private String scope;

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors;
        new ValidationErrors();
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            validationErrors = LicenseServiceUtils.checkForValidLicense("Liquibase Pro", this);
            if (validationErrors.hasErrors()) {
                return validationErrors;
            }
        } else {
            return RefactoringUtils.createValidationErrors(database, this);
        }
        validationErrors = super.validate(database);
        if (database instanceof MSSQLDatabase && this.getDisabled() != null && this.getDisabled().booleanValue() && this.getScope() == null && this.getTableName() == null) {
            validationErrors.addError("tableName or scope is required when creating a disabled trigger");
        }
        return validationErrors;
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getTriggerName();
    }

    @Override
    public void setProcedureName(String string) {
        this.setTriggerName(string);
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getTriggerBody();
    }

    @Override
    public void setProcedureText(String string) {
        this.setTriggerBody(string);
    }

    @DatabaseChangeProperty(mustEqualExisting="trigger", description="Name of the trigger to drop")
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl2) {
        this.disabled = bl2;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getTriggerBody() {
        return this.triggerBody;
    }

    public void setTriggerBody(String string) {
        this.triggerBody = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Trigger " + this.getTriggerName() + " created";
    }

    @Override
    protected SqlStatement[] generateStatements(String object, String string, Database database) {
        boolean bl2 = false;
        if (this.getDisabled() != null) {
            bl2 = this.getDisabled();
        }
        object = new CreateTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTriggerName(), (String)object, string);
        ((CreateTriggerStatement)object).setDisabled(bl2);
        ((CreateTriggerStatement)object).setScope(this.getScope());
        ((CreateTriggerStatement)object).setTableName(this.getTableName());
        ((CreateProcedureStatement)object).setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{object};
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

