"""Generated client library for recommender version v1alpha2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.recommender.v1alpha2 import recommender_v1alpha2_messages as messages


class RecommenderV1alpha2(base_api.BaseApiClient):
  """Generated client library for service recommender version v1alpha2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://recommender.googleapis.com/'
  MTLS_BASE_URL = u'https://recommender.mtls.googleapis.com/'

  _PACKAGE = u'recommender'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'RecommenderV1alpha2'
  _URL_VERSION = u'v1alpha2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new recommender handle."""
    url = url or self.BASE_URL
    super(RecommenderV1alpha2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.billingAccounts_locations_insightTypes_insights = self.BillingAccountsLocationsInsightTypesInsightsService(self)
    self.billingAccounts_locations_insightTypes = self.BillingAccountsLocationsInsightTypesService(self)
    self.billingAccounts_locations_recommenders_recommendations = self.BillingAccountsLocationsRecommendersRecommendationsService(self)
    self.billingAccounts_locations_recommenders = self.BillingAccountsLocationsRecommendersService(self)
    self.billingAccounts_locations = self.BillingAccountsLocationsService(self)
    self.billingAccounts = self.BillingAccountsService(self)
    self.projects_locations_insightTypes_insights = self.ProjectsLocationsInsightTypesInsightsService(self)
    self.projects_locations_insightTypes = self.ProjectsLocationsInsightTypesService(self)
    self.projects_locations_recommenders_recommendations = self.ProjectsLocationsRecommendersRecommendationsService(self)
    self.projects_locations_recommenders = self.ProjectsLocationsRecommendersService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class BillingAccountsLocationsInsightTypesInsightsService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations_insightTypes_insights resource."""

    _NAME = u'billingAccounts_locations_insightTypes_insights'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsLocationsInsightTypesInsightsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the requested insight. Requires the recommender.*.get IAM permission.
for the specified insight type.

      Args:
        request: (RecommenderBillingAccountsLocationsInsightTypesInsightsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}',
        http_method=u'GET',
        method_id=u'recommender.billingAccounts.locations.insightTypes.insights.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'RecommenderBillingAccountsLocationsInsightTypesInsightsGetRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists insights for a Cloud project. Requires the recommender.*.list IAM.
permission for the specified insight type.

      Args:
        request: (RecommenderBillingAccountsLocationsInsightTypesInsightsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2ListInsightsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights',
        http_method=u'GET',
        method_id=u'recommender.billingAccounts.locations.insightTypes.insights.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/insights',
        request_field='',
        request_type_name=u'RecommenderBillingAccountsLocationsInsightTypesInsightsListRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2ListInsightsResponse',
        supports_download=False,
    )

    def MarkAccepted(self, request, global_params=None):
      r"""Marks the Insight State as Accepted. Users can use this method to.
indicate to the Recommender API that they have applied some action based
on the insight. This stops the insight content from being updated.

MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
the recommender.*.update IAM permission for the specified insight.

      Args:
        request: (RecommenderBillingAccountsLocationsInsightTypesInsightsMarkAcceptedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkAccepted')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkAccepted.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.insightTypes.insights.markAccepted',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markAccepted',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightAcceptedRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsInsightTypesInsightsMarkAcceptedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def MarkActive(self, request, global_params=None):
      r"""Mark the Insight State as Active. Users can use this method to.
indicate to the Recommender API that a DISMISSED insight has to
be marked back as ACTIVE.

MarkInsightActive can be applied to insights in DISMISSED state. Requires
the recommender.*.update IAM permission for the specified insight type.

      Args:
        request: (RecommenderBillingAccountsLocationsInsightTypesInsightsMarkActiveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkActive')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkActive.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markActive',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.insightTypes.insights.markActive',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markActive',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightActiveRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsInsightTypesInsightsMarkActiveRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def MarkDismissed(self, request, global_params=None):
      r"""Mark the Insight State as Dismissed. Users can use this method to.
indicate to the Recommender API that an ACTIVE insight should be dismissed.

MarkInsightDismissed can be applied to insights in ACTIVE state. Requires
the recommender.*.update IAM permission for the specified insight type.

      Args:
        request: (RecommenderBillingAccountsLocationsInsightTypesInsightsMarkDismissedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkDismissed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkDismissed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markDismissed',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.insightTypes.insights.markDismissed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markDismissed',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightDismissedRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsInsightTypesInsightsMarkDismissedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

  class BillingAccountsLocationsInsightTypesService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations_insightTypes resource."""

    _NAME = u'billingAccounts_locations_insightTypes'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsLocationsInsightTypesService, self).__init__(client)
      self._upload_configs = {
          }

  class BillingAccountsLocationsRecommendersRecommendationsService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations_recommenders_recommendations resource."""

    _NAME = u'billingAccounts_locations_recommenders_recommendations'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsLocationsRecommendersRecommendationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the requested recommendation. Requires the recommender.*.get.
IAM permission for the specified recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}',
        http_method=u'GET',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsGetRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists recommendations for a Cloud project. Requires the recommender.*.list.
IAM permission for the specified recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2ListRecommendationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations',
        http_method=u'GET',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/recommendations',
        request_field='',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsListRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2ListRecommendationsResponse',
        supports_download=False,
    )

    def MarkActive(self, request, global_params=None):
      r"""Mark the Recommendation State as Active. Users can use this method to.
indicate to the Recommender API that a DISMISSED recommendation has to
be marked back as ACTIVE.

MarkRecommendationActive can be applied to recommendations in DISMISSED
state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkActiveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkActive')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkActive.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markActive',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.markActive',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markActive',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationActiveRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkActiveRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkClaimed(self, request, global_params=None):
      r"""Marks the Recommendation State as Claimed. Users can use this method to.
indicate to the Recommender API that they are starting to apply the
recommendation themselves. This stops the recommendation content from being
updated. Associated insights are frozen and placed in the ACCEPTED state.

MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
ACTIVE state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkClaimedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkClaimed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkClaimed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.markClaimed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markClaimed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationClaimedRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkClaimedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkDismissed(self, request, global_params=None):
      r"""Mark the Recommendation State as Dismissed. Users can use this method to.
indicate to the Recommender API that an ACTIVE recommendation has to
be marked back as DISMISSED.

MarkRecommendationDismissed can be applied to recommendations in ACTIVE
state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkDismissedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkDismissed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkDismissed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markDismissed',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.markDismissed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markDismissed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationDismissedRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkDismissedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkFailed(self, request, global_params=None):
      r"""Marks the Recommendation State as Failed. Users can use this method to.
indicate to the Recommender API that they have applied the recommendation
themselves, and the operation failed. This stops the recommendation content
from being updated. Associated insights are frozen and placed in the
ACCEPTED state.

MarkRecommendationFailed can be applied to recommendations in ACTIVE,
CLAIMED, SUCCEEDED, or FAILED state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkFailedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkFailed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkFailed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.markFailed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markFailed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationFailedRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkFailedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkSucceeded(self, request, global_params=None):
      r"""Marks the Recommendation State as Succeeded. Users can use this method to.
indicate to the Recommender API that they have applied the recommendation
themselves, and the operation was successful. This stops the recommendation
content from being updated. Associated insights are frozen and placed in
the ACCEPTED state.

MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
CLAIMED, SUCCEEDED, or FAILED state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkSucceededRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkSucceeded')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkSucceeded.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded',
        http_method=u'POST',
        method_id=u'recommender.billingAccounts.locations.recommenders.recommendations.markSucceeded',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markSucceeded',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationSucceededRequest',
        request_type_name=u'RecommenderBillingAccountsLocationsRecommendersRecommendationsMarkSucceededRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

  class BillingAccountsLocationsRecommendersService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations_recommenders resource."""

    _NAME = u'billingAccounts_locations_recommenders'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsLocationsRecommendersService, self).__init__(client)
      self._upload_configs = {
          }

  class BillingAccountsLocationsService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations resource."""

    _NAME = u'billingAccounts_locations'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class BillingAccountsService(base_api.BaseApiService):
    """Service class for the billingAccounts resource."""

    _NAME = u'billingAccounts'

    def __init__(self, client):
      super(RecommenderV1alpha2.BillingAccountsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsInsightTypesInsightsService(base_api.BaseApiService):
    """Service class for the projects_locations_insightTypes_insights resource."""

    _NAME = u'projects_locations_insightTypes_insights'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsLocationsInsightTypesInsightsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the requested insight. Requires the recommender.*.get IAM permission.
for the specified insight type.

      Args:
        request: (RecommenderProjectsLocationsInsightTypesInsightsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}',
        http_method=u'GET',
        method_id=u'recommender.projects.locations.insightTypes.insights.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'RecommenderProjectsLocationsInsightTypesInsightsGetRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists insights for a Cloud project. Requires the recommender.*.list IAM.
permission for the specified insight type.

      Args:
        request: (RecommenderProjectsLocationsInsightTypesInsightsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2ListInsightsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights',
        http_method=u'GET',
        method_id=u'recommender.projects.locations.insightTypes.insights.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/insights',
        request_field='',
        request_type_name=u'RecommenderProjectsLocationsInsightTypesInsightsListRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2ListInsightsResponse',
        supports_download=False,
    )

    def MarkAccepted(self, request, global_params=None):
      r"""Marks the Insight State as Accepted. Users can use this method to.
indicate to the Recommender API that they have applied some action based
on the insight. This stops the insight content from being updated.

MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
the recommender.*.update IAM permission for the specified insight.

      Args:
        request: (RecommenderProjectsLocationsInsightTypesInsightsMarkAcceptedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkAccepted')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkAccepted.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.insightTypes.insights.markAccepted',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markAccepted',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightAcceptedRequest',
        request_type_name=u'RecommenderProjectsLocationsInsightTypesInsightsMarkAcceptedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def MarkActive(self, request, global_params=None):
      r"""Mark the Insight State as Active. Users can use this method to.
indicate to the Recommender API that a DISMISSED insight has to
be marked back as ACTIVE.

MarkInsightActive can be applied to insights in DISMISSED state. Requires
the recommender.*.update IAM permission for the specified insight type.

      Args:
        request: (RecommenderProjectsLocationsInsightTypesInsightsMarkActiveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkActive')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkActive.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markActive',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.insightTypes.insights.markActive',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markActive',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightActiveRequest',
        request_type_name=u'RecommenderProjectsLocationsInsightTypesInsightsMarkActiveRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

    def MarkDismissed(self, request, global_params=None):
      r"""Mark the Insight State as Dismissed. Users can use this method to.
indicate to the Recommender API that an ACTIVE insight should be dismissed.

MarkInsightDismissed can be applied to insights in ACTIVE state. Requires
the recommender.*.update IAM permission for the specified insight type.

      Args:
        request: (RecommenderProjectsLocationsInsightTypesInsightsMarkDismissedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Insight) The response message.
      """
      config = self.GetMethodConfig('MarkDismissed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkDismissed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markDismissed',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.insightTypes.insights.markDismissed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markDismissed',
        request_field=u'googleCloudRecommenderV1alpha2MarkInsightDismissedRequest',
        request_type_name=u'RecommenderProjectsLocationsInsightTypesInsightsMarkDismissedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Insight',
        supports_download=False,
    )

  class ProjectsLocationsInsightTypesService(base_api.BaseApiService):
    """Service class for the projects_locations_insightTypes resource."""

    _NAME = u'projects_locations_insightTypes'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsLocationsInsightTypesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsRecommendersRecommendationsService(base_api.BaseApiService):
    """Service class for the projects_locations_recommenders_recommendations resource."""

    _NAME = u'projects_locations_recommenders_recommendations'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsLocationsRecommendersRecommendationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the requested recommendation. Requires the recommender.*.get.
IAM permission for the specified recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}',
        http_method=u'GET',
        method_id=u'recommender.projects.locations.recommenders.recommendations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsGetRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists recommendations for a Cloud project. Requires the recommender.*.list.
IAM permission for the specified recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2ListRecommendationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations',
        http_method=u'GET',
        method_id=u'recommender.projects.locations.recommenders.recommendations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/recommendations',
        request_field='',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsListRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2ListRecommendationsResponse',
        supports_download=False,
    )

    def MarkActive(self, request, global_params=None):
      r"""Mark the Recommendation State as Active. Users can use this method to.
indicate to the Recommender API that a DISMISSED recommendation has to
be marked back as ACTIVE.

MarkRecommendationActive can be applied to recommendations in DISMISSED
state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsMarkActiveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkActive')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkActive.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markActive',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.recommenders.recommendations.markActive',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markActive',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationActiveRequest',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsMarkActiveRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkClaimed(self, request, global_params=None):
      r"""Marks the Recommendation State as Claimed. Users can use this method to.
indicate to the Recommender API that they are starting to apply the
recommendation themselves. This stops the recommendation content from being
updated. Associated insights are frozen and placed in the ACCEPTED state.

MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
ACTIVE state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsMarkClaimedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkClaimed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkClaimed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.recommenders.recommendations.markClaimed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markClaimed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationClaimedRequest',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsMarkClaimedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkDismissed(self, request, global_params=None):
      r"""Mark the Recommendation State as Dismissed. Users can use this method to.
indicate to the Recommender API that an ACTIVE recommendation has to
be marked back as DISMISSED.

MarkRecommendationDismissed can be applied to recommendations in ACTIVE
state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsMarkDismissedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkDismissed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkDismissed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markDismissed',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.recommenders.recommendations.markDismissed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markDismissed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationDismissedRequest',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsMarkDismissedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkFailed(self, request, global_params=None):
      r"""Marks the Recommendation State as Failed. Users can use this method to.
indicate to the Recommender API that they have applied the recommendation
themselves, and the operation failed. This stops the recommendation content
from being updated. Associated insights are frozen and placed in the
ACCEPTED state.

MarkRecommendationFailed can be applied to recommendations in ACTIVE,
CLAIMED, SUCCEEDED, or FAILED state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsMarkFailedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkFailed')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkFailed.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.recommenders.recommendations.markFailed',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markFailed',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationFailedRequest',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsMarkFailedRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

    def MarkSucceeded(self, request, global_params=None):
      r"""Marks the Recommendation State as Succeeded. Users can use this method to.
indicate to the Recommender API that they have applied the recommendation
themselves, and the operation was successful. This stops the recommendation
content from being updated. Associated insights are frozen and placed in
the ACCEPTED state.

MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
CLAIMED, SUCCEEDED, or FAILED state.

Requires the recommender.*.update IAM permission for the specified
recommender.

      Args:
        request: (RecommenderProjectsLocationsRecommendersRecommendationsMarkSucceededRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecommenderV1alpha2Recommendation) The response message.
      """
      config = self.GetMethodConfig('MarkSucceeded')
      return self._RunMethod(
          config, request, global_params=global_params)

    MarkSucceeded.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded',
        http_method=u'POST',
        method_id=u'recommender.projects.locations.recommenders.recommendations.markSucceeded',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:markSucceeded',
        request_field=u'googleCloudRecommenderV1alpha2MarkRecommendationSucceededRequest',
        request_type_name=u'RecommenderProjectsLocationsRecommendersRecommendationsMarkSucceededRequest',
        response_type_name=u'GoogleCloudRecommenderV1alpha2Recommendation',
        supports_download=False,
    )

  class ProjectsLocationsRecommendersService(base_api.BaseApiService):
    """Service class for the projects_locations_recommenders resource."""

    _NAME = u'projects_locations_recommenders'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsLocationsRecommendersService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(RecommenderV1alpha2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
