# an example plugin for pympd that logs the songs on song change to a file.

import gtk
import os
__name = 'MPD Logger'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__blurb = 'This plugin will log the last X songs played by mpd into a file that you specify.'

CONFIG_FILE=os.path.expanduser("~/.pympd/logger.conf")
class Logger:

    # called when we load the plugin. we get passed the mainWindow, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data, get):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.data = data
        self.filename = os.path.expanduser('~/.pympd/log')
        self.filesize = 1
        self.initWidgets()
        self.readConfig()
        self.connect_handlers()

    def _conf(self, hasConf=False):
        if hasConf:
            return True
        self.logentry.set_text(self.filename) 
        self.logspinner.set_value(self.filesize)
        self.confDialog.present()
        return True

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        song = self.pympd.getCurrentSong()
        if song == False:
            return
        newline = "%s - %s\n" % (song.artist, song.title)
        if songChanged:
            if os.path.exists(self.filename):
                outline = ''
                lines = open(self.filename).readlines()
                lines.append(newline)
                if len(lines) > self.filesize:
                    linenum = len(lines) - self.filesize
                else:
                    linenum = 0
                for line in lines[int(linenum):]:
                    outline += line
                outfile = open(self.filename, 'w')
                outfile.write(outline)
            else:
                outfile = open(self.filename, 'w')
                outfile.write(newline)
                
        
    # called on plugin unloaded
    def _unload(self):
        self.confDialog.destroy()
        self.saveConfig()
        return

    #TODO: set this up right, for once.
    def readConfigParser(self):
        if self.parser.has_section("logger"):
            pass

    def readConfig(self):
        if os.path.exists(CONFIG_FILE):
            conflines = open(CONFIG_FILE).readlines()
            self.filename = conflines[1]
            self.filesize = float(conflines[2])
        else: 
            print "creating default config"
            self.saveConfig()
        return

    def saveConfig(self):
        outfile = open(CONFIG_FILE, 'w')
        outlines = "#pympd logger config#\n%s\n%s\n"% (self.filename.strip(), self.filesize)
        outfile.write(outlines)
        

    def initWidgets(self):
        self.xml = gtk.glade.XML("%s/glade/logger.glade" % self.base_dir)
        self.logentry = self.xml.get_widget("logentry")
        self.logspinner = self.xml.get_widget("spinbutton1")
        self.confDialog = self.xml.get_widget("confDialog")

    def connect_handlers(self):
        dic = { 'on_cancel_clicked'     : self.cancel_clicked, 
                'on_ok_clicked'         : self.ok_clicked,
                'on_dialog_closed'      : self.cancel_clicked }
        self.xml.signal_autoconnect(dic)

    def cancel_clicked(self, obj):
        self.confDialog.hide()

    def ok_clicked(self, obj):
        self.filename = self.logentry.get_text()
        self.filesize = self.logspinner.get_value()
        self.confDialog.hide()
        self.saveConfig()
        
