/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Iterator;

public final class ImmutableList$Builder
extends ImmutableCollection$Builder {
    Object[] contents;
    private int size;
    private boolean forceCopy;

    public ImmutableList$Builder() {
        this(4);
    }

    ImmutableList$Builder(int n) {
        this.contents = new Object[n];
        this.size = 0;
    }

    private void getReadyToExpandTo(int n) {
        if (this.contents.length < n) {
            this.contents = Arrays.copyOf(this.contents, ImmutableList$Builder.expandedCapacity(this.contents.length, n));
            this.forceCopy = false;
        } else if (this.forceCopy) {
            this.contents = Arrays.copyOf(this.contents, this.contents.length);
            this.forceCopy = false;
        }
    }

    @Override
    @CanIgnoreReturnValue
    public ImmutableList$Builder add(Object object) {
        Preconditions.checkNotNull(object);
        this.getReadyToExpandTo(this.size + 1);
        this.contents[this.size++] = object;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ImmutableList$Builder addAll(Iterator iterator) {
        super.addAll(iterator);
        return this;
    }

    public ImmutableList build() {
        this.forceCopy = true;
        return ImmutableList.asImmutableList(this.contents, this.size);
    }
}

