/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.IOException;
import java.util.Objects;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileChunkReference;
import org.apache.tika.parser.microsoft.onenote.FileNodeList;
import org.apache.tika.parser.microsoft.onenote.FileNodeUnion;
import org.apache.tika.parser.microsoft.onenote.FndStructureConstants;
import org.apache.tika.parser.microsoft.onenote.GUID;
import org.apache.tika.parser.microsoft.onenote.IndentUtil;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNotePtr;
import org.apache.tika.parser.microsoft.onenote.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileNode {
    private static final Logger LOG = LoggerFactory.getLogger(FileNode.class);
    long id;
    long size;
    long baseType;
    ExtendedGUID gosid;
    ExtendedGUID gctxid;
    GUID fileDataStoreReference;
    FileChunkReference ref;
    PropertySet propertySet;
    boolean isFileData;
    FileNodeList childFileNodeList = new FileNodeList();
    FileNodeUnion subType = new FileNodeUnion();
    String idDesc;

    FileNode() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileNode fileNode = (FileNode)o;
        return this.id == fileNode.id && this.size == fileNode.size && this.baseType == fileNode.baseType && this.isFileData == fileNode.isFileData && Objects.equals(this.gosid, fileNode.gosid) && Objects.equals(this.gctxid, fileNode.gctxid) && Objects.equals(this.fileDataStoreReference, fileNode.fileDataStoreReference) && Objects.equals(this.ref, fileNode.ref) && Objects.equals(this.propertySet, fileNode.propertySet) && Objects.equals(this.childFileNodeList, fileNode.childFileNodeList) && Objects.equals(this.subType, fileNode.subType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.size, this.baseType, this.gosid, this.gctxid, this.fileDataStoreReference, this.ref, this.propertySet, this.isFileData, this.childFileNodeList, this.subType);
    }

    public boolean hasGctxid() {
        return this.id == 93L || this.id == 31L;
    }

    public long getId() {
        return this.id;
    }

    public FileNode setId(long id) {
        this.id = id;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public FileNode setSize(long size) {
        this.size = size;
        return this;
    }

    public long getBaseType() {
        return this.baseType;
    }

    public FileNode setBaseType(long baseType) {
        this.baseType = baseType;
        return this;
    }

    public ExtendedGUID getGosid() {
        return this.gosid;
    }

    public FileNode setGosid(ExtendedGUID gosid) {
        this.gosid = gosid;
        return this;
    }

    public ExtendedGUID getGctxid() {
        return this.gctxid;
    }

    public FileNode setGctxid(ExtendedGUID gctxid) {
        this.gctxid = gctxid;
        return this;
    }

    public GUID getFileDataStoreReference() {
        return this.fileDataStoreReference;
    }

    public FileNode setFileDataStoreReference(GUID fileDataStoreReference) {
        this.fileDataStoreReference = fileDataStoreReference;
        return this;
    }

    public FileChunkReference getRef() {
        return this.ref;
    }

    public FileNode setRef(FileChunkReference ref) {
        this.ref = ref;
        return this;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public FileNode setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
        return this;
    }

    public boolean isFileData() {
        return this.isFileData;
    }

    public FileNode setFileData(boolean fileData) {
        this.isFileData = fileData;
        return this;
    }

    public FileNodeList getChildFileNodeList() {
        return this.childFileNodeList;
    }

    public FileNode setChildFileNodeList(FileNodeList childFileNodeList) {
        this.childFileNodeList = childFileNodeList;
        return this;
    }

    public FileNodeUnion getSubType() {
        return this.subType;
    }

    public FileNode setSubType(FileNodeUnion subType) {
        this.subType = subType;
        return this;
    }

    public void print(OneNoteDocument document, OneNotePtr pointer, int indentLevel) throws IOException, TikaMemoryLimitException {
        boolean shouldPrintHeader = FndStructureConstants.nameOf(this.id).contains("ObjectDec");
        if (this.gosid.equals(ExtendedGUID.nil()) && shouldPrintHeader) {
            LOG.debug("{}[beg {}]:{}", new Object[]{IndentUtil.getIndent(indentLevel + 1), FndStructureConstants.nameOf(this.id), this.gosid});
        }
        this.propertySet.print(document, pointer, indentLevel + 1);
        if (!this.childFileNodeList.children.isEmpty()) {
            if (shouldPrintHeader) {
                LOG.debug("{}children", (Object)IndentUtil.getIndent(indentLevel + 1));
            }
            for (FileNode child : this.childFileNodeList.children) {
                child.print(document, pointer, indentLevel + 1);
            }
        }
        if (this.id == 92L || this.id == 93L) {
            LOG.debug("{}[Revision Role {}]", (Object)IndentUtil.getIndent(indentLevel + 1), (Object)this.subType.revisionRoleDeclaration.revisionRole);
        }
        if (this.id == 27L || this.id == 30L || this.id == 31L) {
            LOG.debug("{}[revisionRole {}]", (Object)IndentUtil.getIndent(indentLevel + 1), (Object)this.subType.revisionManifest.revisionRole);
        }
        if ((this.gctxid != ExtendedGUID.nil() || this.id == 31L) && shouldPrintHeader) {
            LOG.debug("{}[gctxid {}]", (Object)IndentUtil.getIndent(indentLevel + 1), (Object)this.gctxid);
        }
        if (this.gosid != ExtendedGUID.nil() && shouldPrintHeader) {
            LOG.debug("{}[end {}]:{}", new Object[]{IndentUtil.getIndent(indentLevel + 1), FndStructureConstants.nameOf(this.id), this.gosid});
        }
    }

    public String getIdDesc() {
        return this.idDesc;
    }

    public String toString() {
        return "FileNodeID=0x" + Long.toHexString(this.id) + ", gosid=" + this.gosid + ", baseType=0x" + Long.toHexString(this.baseType);
    }
}

