/* Automatically generated code; do not modify directly. */

#include <stddef.h>
#include <stdint.h>
#include <pgmspace.h>

typedef struct {
	uint32_t *dp;
	uint32_t *rp;
	const unsigned char *ip;
} t0_context;

static uint32_t
t0_parse7E_unsigned(const unsigned char **p)
{
	uint32_t x;

	x = 0;
	for (;;) {
		unsigned y;

		y = pgm_read_byte((*p)++);
		x = (x << 7) | (uint32_t)(y & 0x7F);
		if (y < 0x80) {
			return x;
		}
	}
}

static int32_t
t0_parse7E_signed(const unsigned char **p)
{
	int neg;
	uint32_t x;

	neg = (pgm_read_byte(*p) >> 6) & 1;
	x = (uint32_t)-neg;
	for (;;) {
		unsigned y;

		y = pgm_read_byte((*p)++);
		x = (x << 7) | (uint32_t)(y & 0x7F);
		if (y < 0x80) {
			if (neg) {
				return -(int32_t)~x - 1;
			} else {
				return (int32_t)x;
			}
		}
	}
}

#define T0_VBYTE(x, n)   (unsigned char)((((uint32_t)(x) >> (n)) & 0x7F) | 0x80)
#define T0_FBYTE(x, n)   (unsigned char)(((uint32_t)(x) >> (n)) & 0x7F)
#define T0_SBYTE(x)      (unsigned char)((((uint32_t)(x) >> 28) + 0xF8) ^ 0xF8)
#define T0_INT1(x)       T0_FBYTE(x, 0)
#define T0_INT2(x)       T0_VBYTE(x, 7), T0_FBYTE(x, 0)
#define T0_INT3(x)       T0_VBYTE(x, 14), T0_VBYTE(x, 7), T0_FBYTE(x, 0)
#define T0_INT4(x)       T0_VBYTE(x, 21), T0_VBYTE(x, 14), T0_VBYTE(x, 7), T0_FBYTE(x, 0)
#define T0_INT5(x)       T0_SBYTE(x), T0_VBYTE(x, 21), T0_VBYTE(x, 14), T0_VBYTE(x, 7), T0_FBYTE(x, 0)

/* static const unsigned char t0_datablock[]; */


void br_ssl_hs_server_init_main(void *t0ctx);

void br_ssl_hs_server_run(void *t0ctx);



#include <stddef.h>
#include <string.h>

#include "inner.h"

/*
 * This macro evaluates to a pointer to the current engine context.
 */
#define ENG  ((br_ssl_engine_context *)(void *)((unsigned char *)t0ctx - offsetof(br_ssl_engine_context, cpu)))





/*
 * This macro evaluates to a pointer to the server context, under that
 * specific name. It must be noted that since the engine context is the
 * first field of the br_ssl_server_context structure ('eng'), then
 * pointers values of both types are interchangeable, modulo an
 * appropriate cast. This also means that "addresses" computed as offsets
 * within the structure work for both kinds of context.
 */
#define CTX  ((br_ssl_server_context *)ENG)

/*
 * Decrypt the pre-master secret (RSA key exchange).
 */
static void
do_rsa_decrypt(br_ssl_server_context *ctx, int prf_id,
	unsigned char *epms, size_t len)
{
	uint32_t x;
	unsigned char rpms[48];

	/*
	 * Decrypt the PMS.
	 */
	x = (*ctx->policy_vtable)->do_keyx(ctx->policy_vtable, epms, &len);

	/*
	 * Set the first two bytes to the maximum supported client
	 * protocol version. These bytes are used for version rollback
	 * detection; forceing the two bytes will make the master secret
	 * wrong if the bytes are not correct. This process is
	 * recommended by RFC 5246 (section 7.4.7.1).
	 */
	br_enc16be(epms, ctx->client_max_version);

	/*
	 * Make a random PMS and copy it above the decrypted value if the
	 * decryption failed. Note that we use a constant-time conditional
	 * copy.
	 */
	br_hmac_drbg_generate(&ctx->eng.rng, rpms, sizeof rpms);
	br_ccopy(x ^ 1, epms, rpms, sizeof rpms);

	/*
	 * Compute master secret.
	 */
	br_ssl_engine_compute_master(&ctx->eng, prf_id, epms, 48);

	/*
	 * Clear the pre-master secret from RAM: it is normally a buffer
	 * in the context, hence potentially long-lived.
	 */
	memset(epms, 0, len);
}

/*
 * Common part for ECDH and ECDHE.
 */
static void
ecdh_common(br_ssl_server_context *ctx, int prf_id,
	unsigned char *xcoor, size_t xcoor_len, uint32_t ctl)
{
	unsigned char rpms[80];

	if (xcoor_len > sizeof rpms) {
		xcoor_len = sizeof rpms;
		ctl = 0;
	}

	/*
	 * Make a random PMS and copy it above the decrypted value if the
	 * decryption failed. Note that we use a constant-time conditional
	 * copy.
	 */
	br_hmac_drbg_generate(&ctx->eng.rng, rpms, xcoor_len);
	br_ccopy(ctl ^ 1, xcoor, rpms, xcoor_len);

	/*
	 * Compute master secret.
	 */
	br_ssl_engine_compute_master(&ctx->eng, prf_id, xcoor, xcoor_len);

	/*
	 * Clear the pre-master secret from RAM: it is normally a buffer
	 * in the context, hence potentially long-lived.
	 */
	memset(xcoor, 0, xcoor_len);
}

/*
 * Do the ECDH key exchange (not ECDHE).
 */
static void
do_ecdh(br_ssl_server_context *ctx, int prf_id,
	unsigned char *cpoint, size_t cpoint_len)
{
	uint32_t x;

	/*
	 * Finalise the key exchange.
	 */
	x = (*ctx->policy_vtable)->do_keyx(ctx->policy_vtable,
		cpoint, &cpoint_len);
	ecdh_common(ctx, prf_id, cpoint, cpoint_len, x);
}

/*
 * Do the full static ECDH key exchange. When this function is called,
 * it has already been verified that the cipher suite uses ECDH (not ECDHE),
 * and the client's public key (from its certificate) has type EC and is
 * apt for key exchange.
 */
static void
do_static_ecdh(br_ssl_server_context *ctx, int prf_id)
{
	unsigned char cpoint[133];
	size_t cpoint_len;
	const br_x509_class **xc;
	const br_x509_pkey *pk;

	xc = ctx->eng.x509ctx;
	pk = (*xc)->get_pkey(xc, NULL);
	cpoint_len = pk->key.ec.qlen;
	if (cpoint_len > sizeof cpoint) {
		/*
		 * If the point is larger than our buffer then we need to
		 * restrict it. Length 2 is not a valid point length, so
		 * the ECDH will fail.
		 */
		cpoint_len = 2;
	}
	memcpy(cpoint, pk->key.ec.q, cpoint_len);
	do_ecdh(ctx, prf_id, cpoint, cpoint_len);
}

static size_t
hash_data(br_ssl_server_context *ctx,
	void *dst, int hash_id, const void *src, size_t len)
{
	const br_hash_class *hf;
	br_hash_compat_context hc;

	if (hash_id == 0) {
		unsigned char tmp[36];

		hf = br_multihash_getimpl(&ctx->eng.mhash, br_md5_ID);
		if (hf == NULL) {
			return 0;
		}
		hf->init(&hc.vtable);
		hf->update(&hc.vtable, src, len);
		hf->out(&hc.vtable, tmp);
		hf = br_multihash_getimpl(&ctx->eng.mhash, br_sha1_ID);
		if (hf == NULL) {
			return 0;
		}
		hf->init(&hc.vtable);
		hf->update(&hc.vtable, src, len);
		hf->out(&hc.vtable, tmp + 16);
		memcpy(dst, tmp, 36);
		return 36;
	} else {
		hf = br_multihash_getimpl(&ctx->eng.mhash, hash_id);
		if (hf == NULL) {
			return 0;
		}
		hf->init(&hc.vtable);
		hf->update(&hc.vtable, src, len);
		hf->out(&hc.vtable, dst);
		return (hf->desc >> BR_HASHDESC_OUT_OFF) & BR_HASHDESC_OUT_MASK;
	}
}

/*
 * Do the ECDHE key exchange (part 1: generation of transient key, and
 * computing of the point to send to the client). Returned value is the
 * signature length (in bytes), or -x on error (with x being an error
 * code). The encoded point is written in the ecdhe_point[] context buffer
 * (length in ecdhe_point_len).
 */
static int
do_ecdhe_part1(br_ssl_server_context *ctx, int curve)
{
	unsigned algo_id;
	unsigned mask;
	const unsigned char *order;
	size_t olen, glen;
	size_t hv_len, sig_len;

	if (!((ctx->eng.iec->supported_curves >> curve) & 1)) {
		return -BR_ERR_INVALID_ALGORITHM;
	}
	ctx->eng.ecdhe_curve = curve;

	/*
	 * Generate our private key. We need a non-zero random value
	 * which is lower than the curve order, in a "large enough"
	 * range. We force the top bit to 0 and bottom bit to 1, which
	 * does the trick. Note that contrary to what happens in ECDSA,
	 * this is not a problem if we do not cover the full range of
	 * possible values.
	 */
	order = ctx->eng.iec->order(curve, &olen);
	mask = 0xFF;
	while (mask >= pgm_read_byte(&order[0])) {
		mask >>= 1;
	}
	br_hmac_drbg_generate(&ctx->eng.rng, ctx->ecdhe_key, olen);
	ctx->ecdhe_key[0] &= mask;
	ctx->ecdhe_key[olen - 1] |= 0x01;
	ctx->ecdhe_key_len = olen;

	/*
	 * Compute our ECDH point.
	 */
	glen = ctx->eng.iec->mulgen(ctx->eng.ecdhe_point,
		ctx->ecdhe_key, olen, curve);
	ctx->eng.ecdhe_point_len = glen;

	/*
	 * Assemble the message to be signed, and possibly hash it.
	 */
	memcpy(ctx->eng.pad, ctx->eng.client_random, 32);
	memcpy(ctx->eng.pad + 32, ctx->eng.server_random, 32);
	ctx->eng.pad[64 + 0] = 0x03;
	ctx->eng.pad[64 + 1] = 0x00;
	ctx->eng.pad[64 + 2] = curve;
	ctx->eng.pad[64 + 3] = ctx->eng.ecdhe_point_len;
	memcpy(ctx->eng.pad + 64 + 4,
		ctx->eng.ecdhe_point, ctx->eng.ecdhe_point_len);
	hv_len = 64 + 4 + ctx->eng.ecdhe_point_len;
	algo_id = ctx->sign_hash_id;
	if (algo_id >= (unsigned)0xFF00) {
		hv_len = hash_data(ctx, ctx->eng.pad, algo_id & 0xFF,
			ctx->eng.pad, hv_len);
		if (hv_len == 0) {
			return -BR_ERR_INVALID_ALGORITHM;
		}
	}

	sig_len = (*ctx->policy_vtable)->do_sign(ctx->policy_vtable,
		algo_id, ctx->eng.pad, hv_len, sizeof ctx->eng.pad);
	return sig_len ? (int)sig_len : -BR_ERR_INVALID_ALGORITHM;
}

/*
 * Do the ECDHE key exchange (part 2: computation of the shared secret
 * from the point sent by the client).
 */
static void
do_ecdhe_part2(br_ssl_server_context *ctx, int prf_id,
	unsigned char *cpoint, size_t cpoint_len)
{
	int curve;
	uint32_t ctl;
	size_t xoff, xlen;

	curve = ctx->eng.ecdhe_curve;

	/*
	 * Finalise the key exchange.
	 */
	ctl = ctx->eng.iec->mul(cpoint, cpoint_len,
		ctx->ecdhe_key, ctx->ecdhe_key_len, curve);
	xoff = ctx->eng.iec->xoff(curve, &xlen);
	ecdh_common(ctx, prf_id, cpoint + xoff, xlen, ctl);

	/*
	 * Clear the ECDHE private key. Forward Secrecy is achieved insofar
	 * as that key does not get stolen, so we'd better destroy it
	 * as soon as it ceases to be useful.
	 */
	memset(ctx->ecdhe_key, 0, ctx->ecdhe_key_len);
}

/*
 * Offset for hash value within the pad (when obtaining all hash values,
 * in preparation for verification of the CertificateVerify message).
 * Order is MD5, SHA-1, SHA-224, SHA-256, SHA-384, SHA-512; last value
 * is used to get the total length.
 */
static const unsigned char HASH_PAD_OFF[] = { 0, 16, 36, 64, 96, 144, 208 };

/*
 * OID for hash functions in RSA signatures.
 */
static const unsigned char HASH_OID[][10] PROGMEM = {
	{ 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A },                         //HASH_OID_SHA1,
	{ 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x04 }, // HASH_OID_SHA224,
	{ 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01 }, // HASH_OID_SHA256,
	{ 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x02 }, // HASH_OID_SHA384,
	{ 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x03 }  // HASH_OID_SHA512
};

/*
 * Verify the signature in CertificateVerify. Returned value is 0 on
 * success, or a non-zero error code. Lack of implementation of the
 * designated signature algorithm is reported as a "bad signature"
 * error (because it means that the peer did not honour our advertised
 * set of supported signature algorithms).
 */
static int
verify_CV_sig(br_ssl_server_context *ctx, size_t sig_len)
{
	const br_x509_class **xc;
	const br_x509_pkey *pk;
	int id;

	id = ctx->hash_CV_id;
	xc = ctx->eng.x509ctx;
	pk = (*xc)->get_pkey(xc, NULL);
	if (pk->key_type == BR_KEYTYPE_RSA) {
		unsigned char tmp[64];
		unsigned char hash_oid_ram[10];
		const unsigned char *hash_oid;

		if (id == 0) {
			hash_oid = NULL;
		} else {
			memcpy_P(hash_oid_ram, HASH_OID[id - 2], sizeof(HASH_OID[0]));
			hash_oid = hash_oid_ram;
		}
		if (ctx->eng.irsavrfy == 0) {
			return BR_ERR_BAD_SIGNATURE;
		}
		if (!ctx->eng.irsavrfy(ctx->eng.pad, sig_len,
			hash_oid, ctx->hash_CV_len, &pk->key.rsa, tmp)
			|| memcmp(tmp, ctx->hash_CV, ctx->hash_CV_len) != 0)
		{
			return BR_ERR_BAD_SIGNATURE;
		}
	} else {
		if (ctx->eng.iecdsa == 0) {
			return BR_ERR_BAD_SIGNATURE;
		}
		if (!ctx->eng.iecdsa(ctx->eng.iec,
			ctx->hash_CV, ctx->hash_CV_len,
			&pk->key.ec, ctx->eng.pad, sig_len))
		{
			return BR_ERR_BAD_SIGNATURE;
		}
	}
	return 0;
}



static const unsigned char t0_datablock[] PROGMEM = {

	0x00, 0x00, 0x0A, 0x00, 0x24, 0x00, 0x2F, 0x01, 0x24, 0x00, 0x35, 0x02,
	0x24, 0x00, 0x3C, 0x01, 0x44, 0x00, 0x3D, 0x02, 0x44, 0x00, 0x9C, 0x03,
	0x04, 0x00, 0x9D, 0x04, 0x05, 0xC0, 0x03, 0x40, 0x24, 0xC0, 0x04, 0x41,
	0x24, 0xC0, 0x05, 0x42, 0x24, 0xC0, 0x08, 0x20, 0x24, 0xC0, 0x09, 0x21,
	0x24, 0xC0, 0x0A, 0x22, 0x24, 0xC0, 0x0D, 0x30, 0x24, 0xC0, 0x0E, 0x31,
	0x24, 0xC0, 0x0F, 0x32, 0x24, 0xC0, 0x12, 0x10, 0x24, 0xC0, 0x13, 0x11,
	0x24, 0xC0, 0x14, 0x12, 0x24, 0xC0, 0x23, 0x21, 0x44, 0xC0, 0x24, 0x22,
	0x55, 0xC0, 0x25, 0x41, 0x44, 0xC0, 0x26, 0x42, 0x55, 0xC0, 0x27, 0x11,
	0x44, 0xC0, 0x28, 0x12, 0x55, 0xC0, 0x29, 0x31, 0x44, 0xC0, 0x2A, 0x32,
	0x55, 0xC0, 0x2B, 0x23, 0x04, 0xC0, 0x2C, 0x24, 0x05, 0xC0, 0x2D, 0x43,
	0x04, 0xC0, 0x2E, 0x44, 0x05, 0xC0, 0x2F, 0x13, 0x04, 0xC0, 0x30, 0x14,
	0x05, 0xC0, 0x31, 0x33, 0x04, 0xC0, 0x32, 0x34, 0x05, 0xC0, 0x9C, 0x06,
	0x04, 0xC0, 0x9D, 0x07, 0x04, 0xC0, 0xA0, 0x08, 0x04, 0xC0, 0xA1, 0x09,
	0x04, 0xC0, 0xAC, 0x26, 0x04, 0xC0, 0xAD, 0x27, 0x04, 0xC0, 0xAE, 0x28,
	0x04, 0xC0, 0xAF, 0x29, 0x04, 0xCC, 0xA8, 0x15, 0x04, 0xCC, 0xA9, 0x25,
	0x04, 0x00, 0x00
};

static const unsigned char t0_codeblock[] PROGMEM = {

	0x00, 0x01, 0x00, 0x0B, 0x00, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x01,
	0x00, 0x0F, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x01, 0x08,
	0x00, 0x00, 0x01, 0x01, 0x09, 0x00, 0x00, 0x01, 0x02, 0x08, 0x00, 0x00,
	0x01, 0x02, 0x09, 0x00, 0x00, 0x29, 0x29, 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_CCS), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_FINISHED), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_FRAGLEN), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_HANDSHAKE), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_PARAM), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_SECRENEG), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_SIGNATURE), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_BAD_VERSION), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_INVALID_ALGORITHM), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_LIMIT_EXCEEDED), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_NO_CLIENT_AUTH), 0x00, 0x00, 0x01, T0_INT1(BR_ERR_OK),
	0x00, 0x00, 0x01, T0_INT1(BR_ERR_OVERSIZED_ID), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_UNEXPECTED), 0x00, 0x00, 0x01,
	T0_INT1(BR_ERR_WRONG_KEY_USAGE), 0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, action)), 0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, alert)), 0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, application_data)), 0x00, 0x00,
	0x01,
	T0_INT2(offsetof(br_ssl_engine_context, session) + offsetof(br_ssl_session_parameters, cipher_suite)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_server_context, client_max_version)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, client_random)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_server_context, client_suites)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_server_context, client_suites_num)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, close_received)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_server_context, curves)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_engine_context, ecdhe_point)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, ecdhe_point_len)),
	0x00, 0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, flags)),
	0x00, 0x00, 0x01, T0_INT2(offsetof(br_ssl_server_context, hashes)),
	0x00, 0x00, 0x7B, 0x01,
	T0_INT2(BR_MAX_CIPHER_SUITES * sizeof(br_suite_translated)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, log_max_frag_len)),
	0x00, 0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, pad)), 0x00,
	0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, peer_log_max_frag_len)), 0x00,
	0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, protocol_names_num)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, record_type_in)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, record_type_out)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_engine_context, reneg)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_engine_context, saved_finished)), 0x00,
	0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, selected_protocol)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, server_name)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, server_random)), 0x00, 0x00,
	0x01,
	T0_INT2(offsetof(br_ssl_engine_context, session) + offsetof(br_ssl_session_parameters, session_id)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, session) + offsetof(br_ssl_session_parameters, session_id_len)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, shutdown_recv)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_server_context, sign_hash_id)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, suites_buf)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, suites_num)), 0x00,
	0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, session) + offsetof(br_ssl_session_parameters, version)),
	0x00, 0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, version_in)),
	0x00, 0x00, 0x01,
	T0_INT2(offsetof(br_ssl_engine_context, version_max)), 0x00, 0x00,
	0x01, T0_INT2(offsetof(br_ssl_engine_context, version_min)), 0x00,
	0x00, 0x01, T0_INT2(offsetof(br_ssl_engine_context, version_out)),
	0x00, 0x00, 0x09, 0x2A, 0x5D, 0x06, 0x02, 0x6A, 0x2B, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x01, 0x03, 0x00, 0x9B, 0x2A, 0x63, 0x47, 0x9F, 0x2A, 0x05,
	0x04, 0x65, 0x01, 0x00, 0x00, 0x02, 0x00, 0x0F, 0x06, 0x02, 0x9F, 0x00,
	0x63, 0x04, 0x6B, 0x00, 0x06, 0x02, 0x6A, 0x2B, 0x00, 0x00, 0x2A, 0x8B,
	0x47, 0x05, 0x03, 0x01, 0x0C, 0x08, 0x47, 0x78, 0x2E, 0xA8, 0x1C, 0x85,
	0x01, 0x0C, 0x33, 0x00, 0x00, 0x2A, 0x22, 0x01, 0x08, 0x0C, 0x47, 0x61,
	0x22, 0x08, 0x00, 0x01, 0x03, 0x00, 0x77, 0x30, 0x02, 0x00, 0x38, 0x13,
	0x01, 0x01, 0x0C, 0x77, 0x42, 0x2C, 0x19, 0x38, 0x06, 0x07, 0x02, 0x00,
	0xD0, 0x03, 0x00, 0x04, 0x75, 0x01, 0x00, 0xC7, 0x02, 0x00, 0x2A, 0x19,
	0x13, 0x06, 0x02, 0x71, 0x2B, 0xD0, 0x04, 0x76, 0x00, 0x01, 0x00, 0x77,
	0x42, 0x01, 0x16, 0x89, 0x42, 0x01, 0x00, 0x8C, 0x40, 0x36, 0xB1, 0x35,
	0x06, 0x02, 0x73, 0x2B, 0x06, 0x0A, 0xD7, 0x01, 0x00, 0xD3, 0x01, 0x00,
	0xAD, 0x04, 0x80, 0x46, 0xD7, 0xD4, 0x29, 0xD9, 0x50, 0x06, 0x01, 0xD5,
	0xD8, 0x2C, 0x50, 0x06, 0x31, 0x01, 0x00, 0xAE, 0x2A, 0x5D, 0x06, 0x0F,
	0x01, 0x02, 0xA4, 0x05, 0x02, 0x37, 0x2B, 0x29, 0xB2, 0xB0, 0x2A, 0xC9,
	0x29, 0x04, 0x19, 0x2A, 0x5F, 0x06, 0x0B, 0x29, 0x01, 0x02, 0xA4, 0x05,
	0x02, 0x70, 0x2B, 0xB2, 0x04, 0x0A, 0xB4, 0x2A, 0x05, 0x04, 0x29, 0xAB,
	0x04, 0x02, 0xB3, 0xAF, 0x04, 0x01, 0xB2, 0x01, 0x00, 0xAD, 0x01, 0x00,
	0xD3, 0x3E, 0x01, 0x01, 0x77, 0x42, 0x01, 0x17, 0x89, 0x42, 0x00, 0x00,
	0x3A, 0x3A, 0x00, 0x01, 0x03, 0x00, 0x2C, 0x19, 0x38, 0x06, 0x04, 0xCF,
	0x29, 0x04, 0x78, 0x01, 0x02, 0x02, 0x00, 0xC6, 0x19, 0x38, 0x06, 0x04,
	0xCF, 0x29, 0x04, 0x78, 0x02, 0x00, 0x01, 0x84, 0x00, 0x08, 0x2B, 0x00,
	0x00, 0x81, 0x2F, 0x47, 0x12, 0x01, 0x01, 0x13, 0x37, 0x00, 0x00, 0x2A,
	0x05, 0x04, 0x29, 0x01, 0x7F, 0x00, 0x01, 0x00, 0xA2, 0x12, 0x01, 0x01,
	0x13, 0x5F, 0x06, 0x03, 0x61, 0x04, 0x75, 0x47, 0x29, 0x00, 0x00, 0x01,
	0x7F, 0xA1, 0xCF, 0x2A, 0x01, 0x07, 0x13, 0x01, 0x00, 0x3A, 0x0F, 0x06,
	0x0D, 0x29, 0x01, 0x10, 0x13, 0x06, 0x05, 0x01, 0x00, 0x77, 0x42, 0xC5,
	0x04, 0x33, 0x01, 0x01, 0x3A, 0x0F, 0x06, 0x2A, 0x29, 0x29, 0x8A, 0x30,
	0x01, 0x01, 0x0F, 0x01, 0x01, 0xA4, 0x39, 0x06, 0x18, 0xC8, 0x2C, 0x19,
	0x38, 0x06, 0x04, 0xCF, 0x29, 0x04, 0x78, 0x01, 0x80, 0x64, 0xC7, 0x01,
	0x01, 0x77, 0x42, 0x01, 0x17, 0x89, 0x42, 0x04, 0x03, 0x01, 0x00, 0xA1,
	0x04, 0x03, 0x73, 0x2B, 0x29, 0x04, 0xFF, 0x32, 0x01, 0x2A, 0x03, 0x00,
	0x09, 0x2A, 0x5D, 0x06, 0x02, 0x6A, 0x2B, 0x02, 0x00, 0x00, 0x00, 0x9C,
	0x01, 0x0F, 0x13, 0x00, 0x00, 0x76, 0x30, 0x01, 0x00, 0x3A, 0x0F, 0x06,
	0x10, 0x29, 0x2A, 0x01, 0x01, 0x0E, 0x06, 0x03, 0x29, 0x01, 0x02, 0x76,
	0x42, 0x01, 0x00, 0x04, 0x21, 0x01, 0x01, 0x3A, 0x0F, 0x06, 0x14, 0x29,
	0x01, 0x00, 0x76, 0x42, 0x2A, 0x01, 0x80, 0x64, 0x0F, 0x06, 0x05, 0x01,
	0x82, 0x00, 0x08, 0x2B, 0x5F, 0x04, 0x07, 0x29, 0x01, 0x82, 0x00, 0x08,
	0x2B, 0x29, 0x00, 0x00, 0x01, 0x00, 0x31, 0x06, 0x05, 0x3D, 0xA9, 0x39,
	0x04, 0x78, 0x2A, 0x06, 0x04, 0x01, 0x01, 0x91, 0x42, 0x00, 0x00, 0x01,
	0x1F, 0x13, 0x01, 0x12, 0x0F, 0x05, 0x02, 0x74, 0x2B, 0x78, 0x2E, 0x2A,
	0xCB, 0x05, 0x02, 0x73, 0x2B, 0xA8, 0x28, 0x00, 0x02, 0x87, 0x2E, 0x05,
	0x02, 0xBC, 0x00, 0xC0, 0xA7, 0xC0, 0xA7, 0x01, 0x7E, 0x03, 0x00, 0x2A,
	0x06, 0x17, 0xC2, 0x2A, 0x03, 0x01, 0x85, 0x47, 0xB6, 0x02, 0x01, 0x51,
	0x2A, 0x02, 0x00, 0x53, 0x06, 0x04, 0x03, 0x00, 0x04, 0x01, 0x29, 0x04,
	0x66, 0x9D, 0x9D, 0x02, 0x00, 0x61, 0x8C, 0x40, 0x00, 0x00, 0x31, 0x06,
	0x0B, 0x88, 0x30, 0x01, 0x14, 0x0E, 0x06, 0x02, 0x73, 0x2B, 0x04, 0x11,
	0xCF, 0x01, 0x07, 0x13, 0x2A, 0x01, 0x02, 0x0E, 0x06, 0x06, 0x06, 0x02,
	0x73, 0x2B, 0x04, 0x70, 0x29, 0xC3, 0x01, 0x01, 0x0E, 0x35, 0x39, 0x06,
	0x02, 0x66, 0x2B, 0x2A, 0x01, 0x01, 0xCA, 0x38, 0xB5, 0x00, 0x01, 0xBA,
	0x01, 0x0B, 0x0F, 0x05, 0x02, 0x73, 0x2B, 0x2A, 0x01, 0x03, 0x0F, 0x06,
	0x08, 0xC1, 0x06, 0x02, 0x6A, 0x2B, 0x47, 0x29, 0x00, 0x47, 0x5C, 0xC1,
	0xA7, 0x2A, 0x06, 0x23, 0xC1, 0xA7, 0x2A, 0x5B, 0x2A, 0x06, 0x18, 0x2A,
	0x01, 0x82, 0x00, 0x10, 0x06, 0x05, 0x01, 0x82, 0x00, 0x04, 0x01, 0x2A,
	0x03, 0x00, 0x85, 0x02, 0x00, 0xB6, 0x02, 0x00, 0x58, 0x04, 0x65, 0x9D,
	0x59, 0x04, 0x5A, 0x9D, 0x9D, 0x5A, 0x2A, 0x06, 0x02, 0x37, 0x00, 0x29,
	0x2D, 0x00, 0x02, 0x2A, 0x01, 0x20, 0x13, 0x05, 0x02, 0x74, 0x2B, 0x01,
	0x0F, 0x13, 0x03, 0x00, 0xB0, 0x95, 0x2E, 0x01, 0x86, 0x03, 0x11, 0x06,
	0x23, 0xC0, 0x2A, 0x01, 0x81, 0x7F, 0x13, 0x61, 0x01, 0x01, 0x12, 0x02,
	0x00, 0x0F, 0x05, 0x02, 0x6C, 0x2B, 0x01, 0x08, 0x12, 0x2A, 0x01, 0x02,
	0x0B, 0x3A, 0x01, 0x06, 0x10, 0x39, 0x06, 0x02, 0x6E, 0x2B, 0x04, 0x0D,
	0x02, 0x00, 0x01, 0x01, 0x0F, 0x06, 0x04, 0x01, 0x00, 0x04, 0x02, 0x01,
	0x02, 0x20, 0x05, 0x02, 0x6E, 0x2B, 0xC0, 0x2A, 0x03, 0x01, 0x2A, 0x01,
	0x84, 0x00, 0x10, 0x06, 0x02, 0x6F, 0x2B, 0x85, 0x47, 0xB6, 0x02, 0x01,
	0x55, 0x2A, 0x06, 0x01, 0x2B, 0x29, 0x9D, 0x00, 0x00, 0x1D, 0xBA, 0x01,
	0x0F, 0x0F, 0x05, 0x02, 0x73, 0x2B, 0x00, 0x0A, 0xBA, 0x01, 0x01, 0x0F,
	0x05, 0x02, 0x73, 0x2B, 0xC0, 0x2A, 0x03, 0x00, 0x79, 0x40, 0x7A, 0x01,
	0x20, 0xB6, 0xC2, 0x2A, 0x01, 0x20, 0x10, 0x06, 0x02, 0x72, 0x2B, 0x2A,
	0x90, 0x42, 0x8F, 0x47, 0xB6, 0x1A, 0x03, 0x01, 0xC0, 0xA7, 0x01, 0x00,
	0x03, 0x02, 0x01, 0x00, 0x03, 0x03, 0x83, 0xA2, 0x17, 0x3A, 0x08, 0x03,
	0x04, 0x03, 0x05, 0x2A, 0x06, 0x80, 0x6D, 0xC0, 0x2A, 0x03, 0x06, 0x02,
	0x01, 0x06, 0x0A, 0x2A, 0x78, 0x2E, 0x0F, 0x06, 0x04, 0x01, 0x7F, 0x03,
	0x03, 0x2A, 0x01, 0x81, 0x7F, 0x0F, 0x06, 0x0A, 0x8A, 0x30, 0x06, 0x02,
	0x6B, 0x2B, 0x01, 0x7F, 0x03, 0x02, 0x2A, 0x01, 0x81, 0xAC, 0x00, 0x0F,
	0x06, 0x11, 0x02, 0x00, 0x98, 0x2E, 0x11, 0x02, 0x00, 0x97, 0x2E, 0x0B,
	0x13, 0x06, 0x04, 0x01, 0x7F, 0x03, 0x00, 0xC4, 0x2A, 0x5D, 0x06, 0x03,
	0x29, 0x04, 0x26, 0x01, 0x00, 0xA4, 0x06, 0x0B, 0x01, 0x02, 0x0C, 0x7B,
	0x08, 0x02, 0x06, 0x47, 0x40, 0x04, 0x16, 0x29, 0x02, 0x05, 0x02, 0x04,
	0x11, 0x06, 0x02, 0x69, 0x2B, 0x02, 0x06, 0x02, 0x05, 0x40, 0x02, 0x05,
	0x01, 0x04, 0x08, 0x03, 0x05, 0x04, 0xFF, 0x0F, 0x29, 0x01, 0x00, 0x03,
	0x07, 0xC2, 0xA7, 0x2A, 0x06, 0x09, 0xC2, 0x05, 0x04, 0x01, 0x7F, 0x03,
	0x07, 0x04, 0x74, 0x9D, 0x01, 0x00, 0x8D, 0x42, 0x01, 0x88, 0x04, 0x82,
	0x41, 0x01, 0x84, 0x80, 0x80, 0x00, 0x7E, 0x41, 0x2A, 0x06, 0x80, 0x4E,
	0xC0, 0xA7, 0x2A, 0x06, 0x80, 0x47, 0xC0, 0x01, 0x00, 0x3A, 0x0F, 0x06,
	0x04, 0x29, 0xB9, 0x04, 0x39, 0x01, 0x01, 0x3A, 0x0F, 0x06, 0x04, 0x29,
	0xB7, 0x04, 0x2F, 0x01, 0x83, 0xFE, 0x01, 0x3A, 0x0F, 0x06, 0x04, 0x29,
	0xB8, 0x04, 0x23, 0x01, 0x0D, 0x3A, 0x0F, 0x06, 0x04, 0x29, 0xBE, 0x04,
	0x19, 0x01, 0x0A, 0x3A, 0x0F, 0x06, 0x04, 0x29, 0xBF, 0x04, 0x0F, 0x01,
	0x10, 0x3A, 0x0F, 0x06, 0x04, 0x29, 0xAC, 0x04, 0x05, 0x29, 0xBC, 0x01,
	0x00, 0x29, 0x04, 0xFF, 0x35, 0x9D, 0x9D, 0x02, 0x01, 0x02, 0x03, 0x13,
	0x03, 0x01, 0x02, 0x00, 0x5D, 0x06, 0x08, 0x79, 0x2E, 0x99, 0x40, 0x01,
	0x80, 0x56, 0xA3, 0x97, 0x2E, 0x2A, 0x02, 0x00, 0x10, 0x06, 0x03, 0x29,
	0x02, 0x00, 0x2A, 0x01, 0x86, 0x00, 0x0B, 0x06, 0x02, 0x6D, 0x2B, 0x02,
	0x00, 0x98, 0x2E, 0x0B, 0x06, 0x04, 0x01, 0x80, 0x46, 0xA3, 0x02, 0x01,
	0x06, 0x10, 0x95, 0x2E, 0x02, 0x00, 0x0D, 0x06, 0x05, 0x29, 0x95, 0x2E,
	0x04, 0x04, 0x01, 0x00, 0x03, 0x01, 0x2A, 0x95, 0x40, 0x2A, 0x96, 0x40,
	0x2A, 0x99, 0x40, 0x01, 0x86, 0x03, 0x11, 0x03, 0x08, 0x02, 0x02, 0x06,
	0x04, 0x01, 0x02, 0x8A, 0x42, 0x8A, 0x30, 0x05, 0x04, 0x01, 0x01, 0x8A,
	0x42, 0x02, 0x07, 0x05, 0x03, 0x01, 0x28, 0xA3, 0x44, 0x29, 0x01, 0x82,
	0x01, 0x07, 0x01, 0xFC, 0x80, 0x00, 0x39, 0x82, 0x2F, 0x13, 0x2A, 0x82,
	0x41, 0x2A, 0x01, 0x81, 0x7F, 0x13, 0x5E, 0x37, 0x47, 0x01, 0x08, 0x12,
	0x5E, 0x01, 0x02, 0x13, 0x39, 0x01, 0x0C, 0x0C, 0x03, 0x09, 0x7E, 0x2F,
	0x43, 0x13, 0x2A, 0x7E, 0x41, 0x05, 0x04, 0x01, 0x00, 0x03, 0x09, 0x02,
	0x01, 0x06, 0x03, 0x01, 0x7F, 0x00, 0x8F, 0x01, 0x20, 0x34, 0x01, 0x20,
	0x90, 0x42, 0x7B, 0x2A, 0x03, 0x05, 0x2A, 0x02, 0x04, 0x0B, 0x06, 0x80,
	0x49, 0x2A, 0x2E, 0x2A, 0x9C, 0x2A, 0x01, 0x0C, 0x12, 0x2A, 0x01, 0x01,
	0x0F, 0x47, 0x01, 0x02, 0x0F, 0x39, 0x06, 0x0A, 0x2A, 0x02, 0x09, 0x13,
	0x05, 0x04, 0x65, 0x01, 0x00, 0x2A, 0x02, 0x08, 0x05, 0x0E, 0x2A, 0x01,
	0x81, 0x70, 0x13, 0x01, 0x20, 0x0E, 0x06, 0x04, 0x65, 0x01, 0x00, 0x2A,
	0x2A, 0x06, 0x10, 0x02, 0x05, 0x63, 0x40, 0x02, 0x05, 0x40, 0x02, 0x05,
	0x01, 0x04, 0x08, 0x03, 0x05, 0x04, 0x01, 0x65, 0x01, 0x04, 0x08, 0x04,
	0xFF, 0x30, 0x29, 0x02, 0x05, 0x7B, 0x09, 0x01, 0x02, 0x12, 0x2A, 0x05,
	0x03, 0x01, 0x28, 0xA3, 0x7C, 0x42, 0x8C, 0x2E, 0x01, 0x83, 0xFF, 0x7F,
	0x0F, 0x06, 0x0D, 0x01, 0x03, 0xA4, 0x06, 0x04, 0x01, 0x80, 0x78, 0xA3,
	0x01, 0x00, 0x8C, 0x40, 0x18, 0x05, 0x03, 0x01, 0x28, 0xA3, 0x01, 0x00,
	0x00, 0x00, 0xB4, 0xB3, 0x00, 0x04, 0x78, 0x2E, 0xCE, 0x06, 0x16, 0xC0,
	0x2A, 0x01, 0x84, 0x00, 0x10, 0x06, 0x02, 0x6F, 0x2B, 0x2A, 0x03, 0x00,
	0x85, 0x47, 0xB6, 0x02, 0x00, 0x78, 0x2E, 0xA8, 0x27, 0x78, 0x2E, 0x2A,
	0xCC, 0x47, 0xCB, 0x03, 0x01, 0x03, 0x02, 0x02, 0x01, 0x02, 0x02, 0x39,
	0x06, 0x14, 0xC2, 0x2A, 0x03, 0x03, 0x85, 0x47, 0xB6, 0x02, 0x03, 0x78,
	0x2E, 0xA8, 0x02, 0x02, 0x06, 0x03, 0x26, 0x04, 0x01, 0x24, 0x9D, 0x00,
	0x00, 0xBA, 0x01, 0x10, 0x0F, 0x05, 0x02, 0x73, 0x2B, 0x00, 0x00, 0x9E,
	0xBA, 0x01, 0x14, 0x0E, 0x06, 0x02, 0x73, 0x2B, 0x85, 0x01, 0x0C, 0x08,
	0x01, 0x0C, 0xB6, 0x9D, 0x85, 0x2A, 0x01, 0x0C, 0x08, 0x01, 0x0C, 0x32,
	0x05, 0x02, 0x67, 0x2B, 0x00, 0x02, 0x03, 0x00, 0x03, 0x01, 0x02, 0x00,
	0x9A, 0x02, 0x01, 0x02, 0x00, 0x3C, 0x2A, 0x01, 0x00, 0x0F, 0x06, 0x02,
	0x65, 0x00, 0xD1, 0x04, 0x74, 0x00, 0xC0, 0x01, 0x01, 0x0E, 0x06, 0x02,
	0x68, 0x2B, 0xC2, 0x2A, 0x2A, 0x5F, 0x47, 0x01, 0x05, 0x11, 0x39, 0x06,
	0x02, 0x68, 0x2B, 0x01, 0x08, 0x08, 0x2A, 0x84, 0x30, 0x0B, 0x06, 0x0D,
	0x2A, 0x01, 0x01, 0x47, 0x0C, 0x3F, 0x2A, 0x84, 0x42, 0x86, 0x42, 0x04,
	0x01, 0x29, 0x00, 0x00, 0xC0, 0x8A, 0x30, 0x01, 0x00, 0x3A, 0x0F, 0x06,
	0x13, 0x29, 0x01, 0x01, 0x0F, 0x05, 0x02, 0x6B, 0x2B, 0xC2, 0x06, 0x02,
	0x6B, 0x2B, 0x01, 0x02, 0x8A, 0x42, 0x04, 0x28, 0x01, 0x02, 0x3A, 0x0F,
	0x06, 0x1F, 0x29, 0x01, 0x0D, 0x0F, 0x05, 0x02, 0x6B, 0x2B, 0xC2, 0x01,
	0x0C, 0x0F, 0x05, 0x02, 0x6B, 0x2B, 0x85, 0x01, 0x0C, 0xB6, 0x8B, 0x85,
	0x01, 0x0C, 0x32, 0x05, 0x02, 0x6B, 0x2B, 0x04, 0x03, 0x6B, 0x2B, 0x29,
	0x00, 0x00, 0xC0, 0xA7, 0xC0, 0xA7, 0x2A, 0x06, 0x1D, 0xC2, 0x06, 0x03,
	0xBC, 0x04, 0x15, 0xC0, 0x2A, 0x01, 0x81, 0x7F, 0x0D, 0x06, 0x0C, 0x2A,
	0x8D, 0x08, 0x01, 0x00, 0x47, 0x42, 0x8D, 0x47, 0xB6, 0x04, 0x01, 0xC9,
	0x04, 0x60, 0x9D, 0x9D, 0x00, 0x00, 0xBB, 0x2A, 0x5F, 0x06, 0x07, 0x29,
	0x06, 0x02, 0x69, 0x2B, 0x04, 0x74, 0x00, 0x00, 0xC3, 0x01, 0x03, 0xC1,
	0x47, 0x29, 0x47, 0x00, 0x00, 0xC0, 0xC9, 0x00, 0x03, 0x01, 0x00, 0x03,
	0x00, 0xC0, 0xA7, 0x2A, 0x06, 0x80, 0x50, 0xC2, 0x03, 0x01, 0xC2, 0x03,
	0x02, 0x02, 0x01, 0x01, 0x08, 0x0F, 0x06, 0x16, 0x02, 0x02, 0x01, 0x0F,
	0x0D, 0x06, 0x0D, 0x01, 0x01, 0x02, 0x02, 0x01, 0x10, 0x08, 0x0C, 0x02,
	0x00, 0x39, 0x03, 0x00, 0x04, 0x2A, 0x02, 0x01, 0x01, 0x02, 0x11, 0x02,
	0x01, 0x01, 0x06, 0x0D, 0x13, 0x02, 0x02, 0x01, 0x01, 0x0F, 0x02, 0x02,
	0x01, 0x03, 0x0F, 0x39, 0x13, 0x06, 0x11, 0x02, 0x00, 0x01, 0x01, 0x02,
	0x02, 0x62, 0x01, 0x02, 0x0C, 0x02, 0x01, 0x08, 0x0C, 0x39, 0x03, 0x00,
	0x04, 0xFF, 0x2C, 0x9D, 0x02, 0x00, 0x00, 0x00, 0xC0, 0xA7, 0xBD, 0x82,
	0x41, 0x9D, 0x00, 0x00, 0xC0, 0xA7, 0xC0, 0xA7, 0x01, 0x00, 0x7E, 0x41,
	0x2A, 0x06, 0x15, 0xC0, 0x2A, 0x01, 0x20, 0x0B, 0x06, 0x0B, 0x01, 0x01,
	0x47, 0x0C, 0x7E, 0x2F, 0x39, 0x7E, 0x41, 0x04, 0x01, 0x29, 0x04, 0x68,
	0x9D, 0x9D, 0x00, 0x00, 0x01, 0x02, 0x9A, 0xC3, 0x01, 0x08, 0x0C, 0xC3,
	0x08, 0x00, 0x00, 0x01, 0x03, 0x9A, 0xC3, 0x01, 0x08, 0x0C, 0xC3, 0x08,
	0x01, 0x08, 0x0C, 0xC3, 0x08, 0x00, 0x00, 0x01, 0x01, 0x9A, 0xC3, 0x00,
	0x00, 0x3D, 0x2A, 0x5D, 0x05, 0x01, 0x00, 0x29, 0xD1, 0x04, 0x76, 0x02,
	0x03, 0x00, 0x94, 0x30, 0x03, 0x01, 0x01, 0x00, 0x2A, 0x02, 0x01, 0x0B,
	0x06, 0x10, 0x2A, 0x01, 0x01, 0x0C, 0x93, 0x08, 0x2E, 0x02, 0x00, 0x0F,
	0x06, 0x01, 0x00, 0x61, 0x04, 0x6A, 0x29, 0x01, 0x7F, 0x00, 0x00, 0x2C,
	0x19, 0x38, 0x06, 0x04, 0xCF, 0x29, 0x04, 0x78, 0x01, 0x16, 0x89, 0x42,
	0x01, 0x00, 0xE2, 0x01, 0x00, 0xE1, 0x2C, 0x01, 0x17, 0x89, 0x42, 0x00,
	0x00, 0x01, 0x15, 0x89, 0x42, 0x47, 0x57, 0x29, 0x57, 0x29, 0x2C, 0x00,
	0x00, 0x01, 0x01, 0x47, 0xC6, 0x00, 0x00, 0xBB, 0x01, 0x01, 0x0F, 0x05,
	0x02, 0x73, 0x2B, 0x2A, 0xC9, 0x29, 0x00, 0x00, 0x47, 0x3A, 0x9A, 0x47,
	0x2A, 0x06, 0x05, 0xC3, 0x29, 0x62, 0x04, 0x78, 0x29, 0x00, 0x02, 0x03,
	0x00, 0x78, 0x2E, 0x9C, 0x03, 0x01, 0x02, 0x01, 0x01, 0x0F, 0x13, 0x02,
	0x01, 0x01, 0x04, 0x12, 0x01, 0x0F, 0x13, 0x02, 0x01, 0x01, 0x08, 0x12,
	0x01, 0x0F, 0x13, 0x01, 0x00, 0x3A, 0x0F, 0x06, 0x10, 0x29, 0x01, 0x00,
	0x01, 0x18, 0x02, 0x00, 0x06, 0x03, 0x4C, 0x04, 0x01, 0x4D, 0x04, 0x81,
	0x0D, 0x01, 0x01, 0x3A, 0x0F, 0x06, 0x10, 0x29, 0x01, 0x01, 0x01, 0x10,
	0x02, 0x00, 0x06, 0x03, 0x4C, 0x04, 0x01, 0x4D, 0x04, 0x80, 0x77, 0x01,
	0x02, 0x3A, 0x0F, 0x06, 0x10, 0x29, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00,
	0x06, 0x03, 0x4C, 0x04, 0x01, 0x4D, 0x04, 0x80, 0x61, 0x01, 0x03, 0x3A,
	0x0F, 0x06, 0x0F, 0x29, 0x29, 0x01, 0x10, 0x02, 0x00, 0x06, 0x03, 0x4A,
	0x04, 0x01, 0x4B, 0x04, 0x80, 0x4C, 0x01, 0x04, 0x3A, 0x0F, 0x06, 0x0E,
	0x29, 0x29, 0x01, 0x20, 0x02, 0x00, 0x06, 0x03, 0x4A, 0x04, 0x01, 0x4B,
	0x04, 0x38, 0x01, 0x05, 0x3A, 0x0F, 0x06, 0x0C, 0x29, 0x29, 0x02, 0x00,
	0x06, 0x03, 0x4E, 0x04, 0x01, 0x4F, 0x04, 0x26, 0x2A, 0x01, 0x09, 0x10,
	0x06, 0x02, 0x6A, 0x2B, 0x47, 0x29, 0x2A, 0x01, 0x01, 0x13, 0x01, 0x04,
	0x0C, 0x01, 0x10, 0x08, 0x47, 0x01, 0x08, 0x13, 0x01, 0x10, 0x47, 0x09,
	0x02, 0x00, 0x06, 0x03, 0x48, 0x04, 0x01, 0x49, 0x00, 0x29, 0x00, 0x00,
	0x9C, 0x01, 0x0C, 0x12, 0x01, 0x02, 0x10, 0x00, 0x00, 0x9C, 0x01, 0x0C,
	0x12, 0x2A, 0x60, 0x47, 0x01, 0x03, 0x0B, 0x13, 0x00, 0x00, 0x9C, 0x01,
	0x0C, 0x12, 0x01, 0x01, 0x0F, 0x00, 0x00, 0x9C, 0x01, 0x0C, 0x12, 0x5F,
	0x00, 0x00, 0x1B, 0x01, 0x00, 0x75, 0x30, 0x2A, 0x06, 0x22, 0x01, 0x01,
	0x3A, 0x0F, 0x06, 0x06, 0x29, 0x01, 0x00, 0xA0, 0x04, 0x14, 0x01, 0x02,
	0x3A, 0x0F, 0x06, 0x0D, 0x29, 0x77, 0x30, 0x01, 0x01, 0x0F, 0x06, 0x03,
	0x01, 0x10, 0x39, 0x04, 0x01, 0x29, 0x04, 0x01, 0x29, 0x7D, 0x30, 0x05,
	0x33, 0x31, 0x06, 0x30, 0x88, 0x30, 0x01, 0x14, 0x3A, 0x0F, 0x06, 0x06,
	0x29, 0x01, 0x02, 0x39, 0x04, 0x22, 0x01, 0x15, 0x3A, 0x0F, 0x06, 0x09,
	0x29, 0xAA, 0x06, 0x03, 0x01, 0x7F, 0xA0, 0x04, 0x13, 0x01, 0x16, 0x3A,
	0x0F, 0x06, 0x06, 0x29, 0x01, 0x01, 0x39, 0x04, 0x07, 0x29, 0x01, 0x04,
	0x39, 0x01, 0x00, 0x29, 0x19, 0x06, 0x03, 0x01, 0x08, 0x39, 0x00, 0x00,
	0x1B, 0x2A, 0x05, 0x13, 0x31, 0x06, 0x10, 0x88, 0x30, 0x01, 0x15, 0x0F,
	0x06, 0x08, 0x29, 0xAA, 0x01, 0x00, 0x77, 0x42, 0x04, 0x01, 0x23, 0x00,
	0x00, 0xCF, 0x01, 0x07, 0x13, 0x01, 0x01, 0x10, 0x06, 0x02, 0x73, 0x2B,
	0x00, 0x01, 0x03, 0x00, 0x2C, 0x19, 0x06, 0x05, 0x02, 0x00, 0x89, 0x42,
	0x00, 0xCF, 0x29, 0x04, 0x74, 0x00, 0x01, 0x14, 0xD2, 0x01, 0x01, 0xE2,
	0x2C, 0x2A, 0x01, 0x00, 0xCA, 0x01, 0x16, 0xD2, 0xD6, 0x2C, 0x00, 0x00,
	0x01, 0x0B, 0xE2, 0x52, 0x2A, 0x2A, 0x01, 0x03, 0x08, 0xE1, 0xE1, 0x14,
	0x2A, 0x5D, 0x06, 0x02, 0x29, 0x00, 0xE1, 0x1E, 0x2A, 0x06, 0x05, 0x85,
	0x47, 0xDA, 0x04, 0x77, 0x29, 0x04, 0x6C, 0x00, 0x01, 0x00, 0xDC, 0x95,
	0x2E, 0x01, 0x86, 0x03, 0x11, 0x06, 0x05, 0x63, 0x01, 0x00, 0xDD, 0x08,
	0x50, 0x08, 0x01, 0x03, 0x08, 0x01, 0x0D, 0xE2, 0xE1, 0x01, 0x00, 0xDC,
	0xE2, 0x01, 0x01, 0xDC, 0x29, 0x95, 0x2E, 0x01, 0x86, 0x03, 0x11, 0x06,
	0x08, 0x01, 0x00, 0xDD, 0xE0, 0x01, 0x01, 0xDD, 0x29, 0x50, 0xE0, 0x16,
	0x15, 0x2A, 0x5D, 0x06, 0x02, 0x29, 0x00, 0xE0, 0x1F, 0x2A, 0x06, 0x05,
	0x85, 0x47, 0xDA, 0x04, 0x77, 0x29, 0x04, 0x6C, 0x00, 0x9E, 0x01, 0x14,
	0xE2, 0x01, 0x0C, 0xE1, 0x85, 0x01, 0x0C, 0xDA, 0x00, 0x04, 0x03, 0x00,
	0x01, 0x02, 0xE2, 0x01, 0x80, 0x46, 0x8A, 0x30, 0x01, 0x02, 0x0F, 0x06,
	0x0C, 0x02, 0x00, 0x06, 0x04, 0x01, 0x05, 0x04, 0x02, 0x01, 0x1D, 0x04,
	0x02, 0x01, 0x00, 0x03, 0x01, 0x86, 0x30, 0x06, 0x04, 0x01, 0x05, 0x04,
	0x02, 0x01, 0x00, 0x03, 0x02, 0x8C, 0x2E, 0x2A, 0x06, 0x05, 0x62, 0x21,
	0x01, 0x07, 0x08, 0x03, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x02, 0x03,
	0x08, 0x2A, 0x06, 0x03, 0x01, 0x02, 0x08, 0x08, 0xE1, 0x95, 0x2E, 0xE0,
	0x8E, 0x01, 0x04, 0x17, 0x8E, 0x01, 0x04, 0x08, 0x01, 0x1C, 0x34, 0x8E,
	0x01, 0x20, 0xDA, 0x01, 0x20, 0xE2, 0x8F, 0x01, 0x20, 0xDA, 0x78, 0x2E,
	0xE0, 0x01, 0x00, 0xE2, 0x02, 0x01, 0x02, 0x02, 0x08, 0x02, 0x03, 0x08,
	0x2A, 0x06, 0x80, 0x40, 0xE0, 0x02, 0x01, 0x2A, 0x06, 0x10, 0x01, 0x83,
	0xFE, 0x01, 0xE0, 0x01, 0x04, 0x09, 0x2A, 0xE0, 0x62, 0x8B, 0x47, 0xDB,
	0x04, 0x01, 0x29, 0x02, 0x02, 0x06, 0x0C, 0x01, 0x01, 0xE0, 0x01, 0x01,
	0xE0, 0x86, 0x30, 0x01, 0x08, 0x09, 0xE2, 0x02, 0x03, 0x2A, 0x06, 0x11,
	0x01, 0x10, 0xE0, 0x01, 0x04, 0x09, 0x2A, 0xE0, 0x64, 0x2A, 0xE0, 0x62,
	0x85, 0x47, 0xDB, 0x04, 0x01, 0x29, 0x04, 0x01, 0x29, 0x00, 0x00, 0x01,
	0x0E, 0xE2, 0x01, 0x00, 0xE1, 0x00, 0x03, 0x78, 0x2E, 0xCC, 0x05, 0x01,
	0x00, 0x7E, 0x2F, 0x2A, 0x01, 0x82, 0x80, 0x80, 0x80, 0x00, 0x13, 0x06,
	0x05, 0x29, 0x01, 0x1D, 0x04, 0x0E, 0x2A, 0x01, 0x83, 0xC0, 0x80, 0x80,
	0x00, 0x13, 0x2A, 0x06, 0x01, 0x47, 0x29, 0xA5, 0x03, 0x00, 0x02, 0x00,
	0x25, 0x2A, 0x5D, 0x06, 0x02, 0x37, 0x2B, 0x03, 0x01, 0x95, 0x2E, 0x01,
	0x86, 0x03, 0x11, 0x03, 0x02, 0x01, 0x0C, 0xE2, 0x02, 0x01, 0x80, 0x30,
	0x08, 0x02, 0x02, 0x01, 0x02, 0x13, 0x08, 0x01, 0x06, 0x08, 0xE1, 0x01,
	0x03, 0xE2, 0x02, 0x00, 0xE0, 0x7F, 0x80, 0x30, 0xDB, 0x02, 0x02, 0x06,
	0x1C, 0x92, 0x2E, 0x2A, 0x01, 0x83, 0xFE, 0x00, 0x0B, 0x06, 0x03, 0xE0,
	0x04, 0x0F, 0x01, 0x81, 0x7F, 0x13, 0xE2, 0x78, 0x2E, 0xCD, 0x01, 0x01,
	0x0C, 0x01, 0x03, 0x08, 0xE2, 0x02, 0x01, 0xE0, 0x85, 0x02, 0x01, 0xDA,
	0x00, 0x00, 0x56, 0x2A, 0x01, 0x00, 0x0F, 0x06, 0x02, 0x65, 0x00, 0xCF,
	0x29, 0x04, 0x73, 0x00, 0x2A, 0xE2, 0xDA, 0x00, 0x00, 0x01, 0x00, 0x78,
	0x2E, 0xCB, 0x06, 0x0C, 0x63, 0x3A, 0x06, 0x08, 0x01, 0x80, 0x41, 0xE2,
	0x01, 0x80, 0x42, 0xE2, 0x46, 0x06, 0x07, 0x61, 0x3A, 0x06, 0x03, 0x01,
	0x01, 0xE2, 0x45, 0x06, 0x08, 0x61, 0x3A, 0x06, 0x04, 0x01, 0x80, 0x40,
	0xE2, 0x47, 0x29, 0x00, 0x01, 0x01, 0x00, 0x03, 0x00, 0x46, 0x45, 0x39,
	0x05, 0x14, 0x01, 0x01, 0x01, 0x80, 0x7C, 0xDE, 0x03, 0x00, 0x01, 0x03,
	0x01, 0x80, 0x7C, 0xDE, 0x02, 0x00, 0x08, 0x47, 0x29, 0x00, 0x46, 0x06,
	0x07, 0x01, 0x01, 0x44, 0x29, 0xDE, 0x03, 0x00, 0x45, 0x06, 0x0A, 0x01,
	0x03, 0x44, 0x29, 0xDE, 0x02, 0x00, 0x08, 0x03, 0x00, 0x29, 0x02, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x01, 0x04, 0xDF, 0x01, 0x05, 0xDF, 0x01, 0x06,
	0xDF, 0x01, 0x03, 0xDF, 0x01, 0x02, 0xDF, 0x0A, 0x65, 0x00, 0x01, 0x03,
	0x00, 0x3A, 0x01, 0x01, 0x02, 0x00, 0x0C, 0x13, 0x05, 0x01, 0x00, 0x63,
	0x01, 0x03, 0x3B, 0x06, 0x07, 0x02, 0x00, 0xE2, 0x01, 0x02, 0x3B, 0xE2,
	0x00, 0x00, 0x2A, 0x01, 0x08, 0x54, 0xE2, 0xE2, 0x00, 0x00, 0x2A, 0x01,
	0x10, 0x54, 0xE2, 0xE0, 0x00, 0x00, 0x2A, 0x57, 0x06, 0x02, 0x29, 0x00,
	0xCF, 0x29, 0x04, 0x76
};

static const uint16_t t0_caddr[] PROGMEM = {

	0,
	5,
	10,
	15,
	20,
	25,
	30,
	35,
	40,
	44,
	48,
	52,
	56,
	60,
	64,
	68,
	72,
	76,
	80,
	84,
	88,
	92,
	96,
	100,
	104,
	109,
	114,
	119,
	124,
	129,
	134,
	139,
	144,
	149,
	154,
	159,
	164,
	169,
	174,
	180,
	185,
	190,
	195,
	200,
	205,
	210,
	215,
	220,
	225,
	230,
	235,
	240,
	245,
	250,
	255,
	260,
	265,
	270,
	275,
	280,
	285,
	290,
	299,
	303,
	328,
	334,
	353,
	364,
	405,
	516,
	520,
	553,
	563,
	587,
	669,
	683,
	689,
	748,
	767,
	789,
	838,
	887,
	963,
	1065,
	1076,
	1670,
	1674,
	1741,
	1751,
	1782,
	1806,
	1852,
	1922,
	1962,
	1976,
	1985,
	1989,
	2084,
	2092,
	2128,
	2139,
	2155,
	2161,
	2172,
	2207,
	2233,
	2245,
	2251,
	2264,
	2279,
	2472,
	2481,
	2494,
	2503,
	2510,
	2616,
	2641,
	2654,
	2670,
	2688,
	2720,
	2793,
	2806,
	2987,
	2995,
	3122,
	3136,
	3141,
	3185,
	3242,
	3263,
	3290,
	3298,
	3306
};

#define T0_INTERPRETED   93

#define T0_ENTER(ip, rp, slot)   do { \
		const unsigned char *t0_newip; \
		uint32_t t0_lnum; \
		t0_newip = &t0_codeblock[pgm_read_word(&t0_caddr[(slot) - T0_INTERPRETED])]; \
		t0_lnum = t0_parse7E_unsigned(&t0_newip); \
		(rp) += t0_lnum; \
		*((rp) ++) = (uint32_t)((ip) - &t0_codeblock[0]) + (t0_lnum << 16); \
		(ip) = t0_newip; \
	} while (0)

#define T0_DEFENTRY(name, slot) \
void \
name(void *ctx) \
{ \
	t0_context *t0ctx = ctx; \
	t0ctx->ip = &t0_codeblock[0]; \
	T0_ENTER(t0ctx->ip, t0ctx->rp, slot); \
}

T0_DEFENTRY(br_ssl_hs_server_init_main, 166)

#define T0_NEXT(t0ipp)   (pgm_read_byte((*t0ipp)++))

void
br_ssl_hs_server_run(void *t0ctx)
{
	uint32_t *dp, *rp;
	const unsigned char *ip;

#define T0_LOCAL(x)    (*(rp - 2 - (x)))
#define T0_POP()       (*-- dp)
#define T0_POPi()      (*(int32_t *)(-- dp))
#define T0_PEEK(x)     (*(dp - 1 - (x)))
#define T0_PEEKi(x)    (*(int32_t *)(dp - 1 - (x)))
#define T0_PUSH(v)     do { *dp = (v); dp ++; } while (0)
#define T0_PUSHi(v)    do { *(int32_t *)dp = (v); dp ++; } while (0)
#define T0_RPOP()      (*-- rp)
#define T0_RPOPi()     (*(int32_t *)(-- rp))
#define T0_RPUSH(v)    do { *rp = (v); rp ++; } while (0)
#define T0_RPUSHi(v)   do { *(int32_t *)rp = (v); rp ++; } while (0)
#define T0_ROLL(x)     do { \
	size_t t0len = (size_t)(x); \
	uint32_t t0tmp = *(dp - 1 - t0len); \
	memmove(dp - t0len - 1, dp - t0len, t0len * sizeof *dp); \
	*(dp - 1) = t0tmp; \
} while (0)
#define T0_SWAP()      do { \
	uint32_t t0tmp = *(dp - 2); \
	*(dp - 2) = *(dp - 1); \
	*(dp - 1) = t0tmp; \
} while (0)
#define T0_ROT()       do { \
	uint32_t t0tmp = *(dp - 3); \
	*(dp - 3) = *(dp - 2); \
	*(dp - 2) = *(dp - 1); \
	*(dp - 1) = t0tmp; \
} while (0)
#define T0_NROT()       do { \
	uint32_t t0tmp = *(dp - 1); \
	*(dp - 1) = *(dp - 2); \
	*(dp - 2) = *(dp - 3); \
	*(dp - 3) = t0tmp; \
} while (0)
#define T0_PICK(x)      do { \
	uint32_t t0depth = (x); \
	T0_PUSH(T0_PEEK(t0depth)); \
} while (0)
#define T0_CO()         do { \
	goto t0_exit; \
} while (0)
#define T0_RET()        goto t0_next

	dp = ((t0_context *)t0ctx)->dp;
	rp = ((t0_context *)t0ctx)->rp;
	ip = ((t0_context *)t0ctx)->ip;
	goto t0_next;
	for (;;) {
		uint32_t t0x;

	t0_next:
		t0x = T0_NEXT(&ip);
		if (t0x < T0_INTERPRETED) {
			switch (t0x) {
				int32_t t0off;

			case 0: /* ret */
				t0x = T0_RPOP();
				rp -= (t0x >> 16);
				t0x &= 0xFFFF;
				if (t0x == 0) {
					ip = NULL;
					goto t0_exit;
				}
				ip = &t0_codeblock[t0x];
				break;
			case 1: /* literal constant */
				T0_PUSHi(t0_parse7E_signed(&ip));
				break;
			case 2: /* read local */
				T0_PUSH(T0_LOCAL(t0_parse7E_unsigned(&ip)));
				break;
			case 3: /* write local */
				T0_LOCAL(t0_parse7E_unsigned(&ip)) = T0_POP();
				break;
			case 4: /* jump */
				t0off = t0_parse7E_signed(&ip);
				ip += t0off;
				break;
			case 5: /* jump if */
				t0off = t0_parse7E_signed(&ip);
				if (T0_POP()) {
					ip += t0off;
				}
				break;
			case 6: /* jump if not */
				t0off = t0_parse7E_signed(&ip);
				if (!T0_POP()) {
					ip += t0off;
				}
				break;
			case 7: {
				/* * */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(a * b);

				}
				break;
			case 8: {
				/* + */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(a + b);

				}
				break;
			case 9: {
				/* - */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(a - b);

				}
				break;
			case 10: {
				/* -rot */
 T0_NROT(); 
				}
				break;
			case 11: {
				/* < */

	int32_t b = T0_POPi();
	int32_t a = T0_POPi();
	T0_PUSH(-(uint32_t)(a < b));

				}
				break;
			case 12: {
				/* << */

	int c = (int)T0_POPi();
	uint32_t x = T0_POP();
	T0_PUSH(x << c);

				}
				break;
			case 13: {
				/* <= */

	int32_t b = T0_POPi();
	int32_t a = T0_POPi();
	T0_PUSH(-(uint32_t)(a <= b));

				}
				break;
			case 14: {
				/* <> */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(-(uint32_t)(a != b));

				}
				break;
			case 15: {
				/* = */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(-(uint32_t)(a == b));

				}
				break;
			case 16: {
				/* > */

	int32_t b = T0_POPi();
	int32_t a = T0_POPi();
	T0_PUSH(-(uint32_t)(a > b));

				}
				break;
			case 17: {
				/* >= */

	int32_t b = T0_POPi();
	int32_t a = T0_POPi();
	T0_PUSH(-(uint32_t)(a >= b));

				}
				break;
			case 18: {
				/* >> */

	int c = (int)T0_POPi();
	int32_t x = T0_POPi();
	T0_PUSHi(x >> c);

				}
				break;
			case 19: {
				/* and */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(a & b);

				}
				break;
			case 20: {
				/* begin-cert */

	if (ENG->chain_len == 0) {
		T0_PUSHi(-1);
	} else {
		ENG->cert_cur = ENG->chain->data;
		ENG->cert_len = ENG->chain->data_len;
		ENG->chain ++;
		ENG->chain_len --;
		T0_PUSH(ENG->cert_len);
	}

				}
				break;
			case 21: {
				/* begin-ta-name */

	const br_x500_name *dn;
	if (CTX->cur_dn_index >= CTX->num_tas) {
		T0_PUSHi(-1);
	} else {
		if (CTX->ta_names == NULL) {
			dn = &CTX->tas[CTX->cur_dn_index].dn;
		} else {
			dn = &CTX->ta_names[CTX->cur_dn_index];
		}
		CTX->cur_dn_index ++;
		CTX->cur_dn = dn->data;
		CTX->cur_dn_len = dn->len;
		T0_PUSH(CTX->cur_dn_len);
	}

				}
				break;
			case 22: {
				/* begin-ta-name-list */

	CTX->cur_dn_index = 0;

				}
				break;
			case 23: {
				/* bzero */

	size_t len = (size_t)T0_POP();
	void *addr = (unsigned char *)ENG + (size_t)T0_POP();
	memset(addr, 0, len);

				}
				break;
			case 24: {
				/* call-policy-handler */

	int x;
	br_ssl_server_choices choices;

	x = (*CTX->policy_vtable)->choose(
		CTX->policy_vtable, CTX, &choices);
	ENG->session.cipher_suite = choices.cipher_suite;
	CTX->sign_hash_id = choices.algo_id;
	ENG->chain = choices.chain;
	ENG->chain_len = choices.chain_len;
	T0_PUSHi(-(x != 0));

				}
				break;
			case 25: {
				/* can-output? */

	T0_PUSHi(-(ENG->hlen_out > 0));

				}
				break;
			case 26: {
				/* check-resume */

	if (ENG->session.session_id_len == 32
		&& CTX->cache_vtable != NULL && (*CTX->cache_vtable)->load(
			CTX->cache_vtable, CTX, &ENG->session))
	{
		T0_PUSHi(-1);
	} else {
		T0_PUSH(0);
	}

				}
				break;
			case 27: {
				/* co */
 T0_CO(); 
				}
				break;
			case 28: {
				/* compute-Finished-inner */

	int prf_id = T0_POP();
	int from_client = T0_POPi();
	unsigned char tmp[48];
	br_tls_prf_seed_chunk seed;

	br_tls_prf_impl prf = br_ssl_engine_get_PRF(ENG, prf_id);
	seed.data = tmp;
	if (ENG->session.version >= BR_TLS12) {
		seed.len = br_multihash_out(&ENG->mhash, prf_id, tmp);
	} else {
		br_multihash_out(&ENG->mhash, br_md5_ID, tmp);
		br_multihash_out(&ENG->mhash, br_sha1_ID, tmp + 16);
		seed.len = 36;
	}
	prf(ENG->pad, 12, ENG->session.master_secret,
		sizeof ENG->session.master_secret,
		from_client ? "client finished" : "server finished",
		1, &seed);

				}
				break;
			case 29: {
				/* compute-hash-CV */

	int i;

	for (i = 1; i <= 6; i ++) {
		br_multihash_out(&ENG->mhash, i,
			ENG->pad + HASH_PAD_OFF[i - 1]);
	}

				}
				break;
			case 30: {
				/* copy-cert-chunk */

	size_t clen;

	clen = ENG->cert_len;
	if (clen > sizeof ENG->pad) {
		clen = sizeof ENG->pad;
	}
	memcpy_P(ENG->pad, ENG->cert_cur, clen);
	ENG->cert_cur += clen;
	ENG->cert_len -= clen;
	T0_PUSH(clen);

				}
				break;
			case 31: {
				/* copy-dn-chunk */

	size_t clen;

	clen = CTX->cur_dn_len;
	if (clen > sizeof ENG->pad) {
		clen = sizeof ENG->pad;
	}
	memcpy(ENG->pad, CTX->cur_dn, clen);
	CTX->cur_dn += clen;
	CTX->cur_dn_len -= clen;
	T0_PUSH(clen);

				}
				break;
			case 32: {
				/* copy-hash-CV */

	int id = T0_POP();
	size_t off, len;

	if (id == 0) {
		off = 0;
		len = 36;
	} else {
		if (br_multihash_getimpl(&ENG->mhash, id) == 0) {
			T0_PUSH(0);
			T0_RET();
		}
		off = HASH_PAD_OFF[id - 1];
		len = HASH_PAD_OFF[id] - off;
	}
	memcpy(CTX->hash_CV, ENG->pad + off, len);
	CTX->hash_CV_len = len;
	CTX->hash_CV_id = id;
	T0_PUSHi(-1);

				}
				break;
			case 33: {
				/* copy-protocol-name */

	size_t idx = T0_POP();
	size_t len = strlen(ENG->protocol_names[idx]);
	memcpy(ENG->pad, ENG->protocol_names[idx], len);
	T0_PUSH(len);

				}
				break;
			case 34: {
				/* data-get8 */

	size_t addr = T0_POP();
	T0_PUSH(pgm_read_byte(&t0_datablock[addr]));

				}
				break;
			case 35: {
				/* discard-input */

	ENG->hlen_in = 0;

				}
				break;
			case 36: {
				/* do-ecdh */

	int prf_id = T0_POPi();
	size_t len = T0_POP();
	do_ecdh(CTX, prf_id, ENG->pad, len);

				}
				break;
			case 37: {
				/* do-ecdhe-part1 */

	int curve = T0_POPi();
	T0_PUSHi(do_ecdhe_part1(CTX, curve));

				}
				break;
			case 38: {
				/* do-ecdhe-part2 */

	int prf_id = T0_POPi();
	size_t len = T0_POP();
	do_ecdhe_part2(CTX, prf_id, ENG->pad, len);

				}
				break;
			case 39: {
				/* do-rsa-decrypt */

	int prf_id = T0_POPi();
	size_t len = T0_POP();
	do_rsa_decrypt(CTX, prf_id, ENG->pad, len);

				}
				break;
			case 40: {
				/* do-static-ecdh */

	do_static_ecdh(CTX, T0_POP());

				}
				break;
			case 41: {
				/* drop */
 (void)T0_POP(); 
				}
				break;
			case 42: {
				/* dup */
 T0_PUSH(T0_PEEK(0)); 
				}
				break;
			case 43: {
				/* fail */

	br_ssl_engine_fail(ENG, (int)T0_POPi());
	T0_CO();

				}
				break;
			case 44: {
				/* flush-record */

	br_ssl_engine_flush_record(ENG);

				}
				break;
			case 45: {
				/* get-key-type-usages */

	const br_x509_class *xc;
	const br_x509_pkey *pk;
	unsigned usages;

	xc = *(ENG->x509ctx);
	pk = xc->get_pkey(ENG->x509ctx, &usages);
	if (pk == NULL) {
		T0_PUSH(0);
	} else {
		T0_PUSH(pk->key_type | usages);
	}

				}
				break;
			case 46: {
				/* get16 */

	size_t addr = (size_t)T0_POP();
	T0_PUSH(*(uint16_t *)(void *)((unsigned char *)ENG + addr));

				}
				break;
			case 47: {
				/* get32 */

	size_t addr = (size_t)T0_POP();
	T0_PUSH(*(uint32_t *)(void *)((unsigned char *)ENG + addr));

				}
				break;
			case 48: {
				/* get8 */

	size_t addr = (size_t)T0_POP();
	T0_PUSH(*((unsigned char *)ENG + addr));

				}
				break;
			case 49: {
				/* has-input? */

	T0_PUSHi(-(ENG->hlen_in != 0));

				}
				break;
			case 50: {
				/* memcmp */

	size_t len = (size_t)T0_POP();
	void *addr2 = (unsigned char *)ENG + (size_t)T0_POP();
	void *addr1 = (unsigned char *)ENG + (size_t)T0_POP();
	int x = memcmp(addr1, addr2, len);
	T0_PUSH((uint32_t)-(x == 0));

				}
				break;
			case 51: {
				/* memcpy */

	size_t len = (size_t)T0_POP();
	void *src = (unsigned char *)ENG + (size_t)T0_POP();
	void *dst = (unsigned char *)ENG + (size_t)T0_POP();
	memcpy(dst, src, len);

				}
				break;
			case 52: {
				/* mkrand */

	size_t len = (size_t)T0_POP();
	void *addr = (unsigned char *)ENG + (size_t)T0_POP();
	br_hmac_drbg_generate(&ENG->rng, addr, len);

				}
				break;
			case 53: {
				/* more-incoming-bytes? */

	T0_PUSHi(ENG->hlen_in != 0 || !br_ssl_engine_recvrec_finished(ENG));

				}
				break;
			case 54: {
				/* multihash-init */

	br_multihash_init(&ENG->mhash);

				}
				break;
			case 55: {
				/* neg */

	uint32_t a = T0_POP();
	T0_PUSH(-a);

				}
				break;
			case 56: {
				/* not */

	uint32_t a = T0_POP();
	T0_PUSH(~a);

				}
				break;
			case 57: {
				/* or */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(a | b);

				}
				break;
			case 58: {
				/* over */
 T0_PUSH(T0_PEEK(1)); 
				}
				break;
			case 59: {
				/* pick */
 T0_PICK(T0_POP()); 
				}
				break;
			case 60: {
				/* read-chunk-native */

	size_t clen = ENG->hlen_in;
	if (clen > 0) {
		uint32_t addr, len;

		len = T0_POP();
		addr = T0_POP();
		if ((size_t)len < clen) {
			clen = (size_t)len;
		}
		memcpy_P((unsigned char *)ENG + addr, ENG->hbuf_in, clen);
		if (ENG->record_type_in == BR_SSL_HANDSHAKE) {
			br_multihash_update(&ENG->mhash, ENG->hbuf_in, clen);
		}
		T0_PUSH(addr + (uint32_t)clen);
		T0_PUSH(len - (uint32_t)clen);
		ENG->hbuf_in += clen;
		ENG->hlen_in -= clen;
	}

				}
				break;
			case 61: {
				/* read8-native */

	if (ENG->hlen_in > 0) {
		unsigned char x;

		x = pgm_read_byte(ENG->hbuf_in ++);
		if (ENG->record_type_in == BR_SSL_HANDSHAKE) {
			br_multihash_update(&ENG->mhash, &x, 1);
		}
		T0_PUSH(x);
		ENG->hlen_in --;
	} else {
		T0_PUSHi(-1);
	}

				}
				break;
			case 62: {
				/* save-session */

	if (CTX->cache_vtable != NULL) {
		(*CTX->cache_vtable)->save(
			CTX->cache_vtable, CTX, &ENG->session);
	}

				}
				break;
			case 63: {
				/* set-max-frag-len */

	size_t max_frag_len = T0_POP();

	br_ssl_engine_new_max_frag_len(ENG, max_frag_len);

	/*
	 * We must adjust our own output limit. Since we call this only
	 * after receiving a ClientHello and before beginning to send
	 * the ServerHello, the next output record should be empty at
	 * that point, so we can use max_frag_len as a limit.
	 */
	if (ENG->hlen_out > max_frag_len) {
		ENG->hlen_out = max_frag_len;
	}

				}
				break;
			case 64: {
				/* set16 */

	size_t addr = (size_t)T0_POP();
	*(uint16_t *)(void *)((unsigned char *)ENG + addr) = (uint16_t)T0_POP();

				}
				break;
			case 65: {
				/* set32 */

	size_t addr = (size_t)T0_POP();
	*(uint32_t *)(void *)((unsigned char *)ENG + addr) = (uint32_t)T0_POP();

				}
				break;
			case 66: {
				/* set8 */

	size_t addr = (size_t)T0_POP();
	*((unsigned char *)ENG + addr) = (unsigned char)T0_POP();

				}
				break;
			case 67: {
				/* supported-curves */

	uint32_t x = ENG->iec == NULL ? 0 : ENG->iec->supported_curves;
	T0_PUSH(x);

				}
				break;
			case 68: {
				/* supported-hash-functions */

	int i;
	unsigned x, num;

	x = 0;
	num = 0;
	for (i = br_sha1_ID; i <= br_sha512_ID; i ++) {
		if (br_multihash_getimpl(&ENG->mhash, i)) {
			x |= 1U << i;
			num ++;
		}
	}
	T0_PUSH(x);
	T0_PUSH(num);

				}
				break;
			case 69: {
				/* supports-ecdsa? */

	T0_PUSHi(-(ENG->iecdsa != 0));

				}
				break;
			case 70: {
				/* supports-rsa-sign? */

	T0_PUSHi(-(ENG->irsavrfy != 0));

				}
				break;
			case 71: {
				/* swap */
 T0_SWAP(); 
				}
				break;
			case 72: {
				/* switch-aesccm-in */

	int is_client, prf_id;
	unsigned cipher_key_len, tag_len;

	tag_len = T0_POP();
	cipher_key_len = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_ccm_in(ENG, is_client, prf_id,
		ENG->iaes_ctrcbc, cipher_key_len, tag_len);

				}
				break;
			case 73: {
				/* switch-aesccm-out */

	int is_client, prf_id;
	unsigned cipher_key_len, tag_len;

	tag_len = T0_POP();
	cipher_key_len = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_ccm_out(ENG, is_client, prf_id,
		ENG->iaes_ctrcbc, cipher_key_len, tag_len);

				}
				break;
			case 74: {
				/* switch-aesgcm-in */

	int is_client, prf_id;
	unsigned cipher_key_len;

	cipher_key_len = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_gcm_in(ENG, is_client, prf_id,
		ENG->iaes_ctr, cipher_key_len);

				}
				break;
			case 75: {
				/* switch-aesgcm-out */

	int is_client, prf_id;
	unsigned cipher_key_len;

	cipher_key_len = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_gcm_out(ENG, is_client, prf_id,
		ENG->iaes_ctr, cipher_key_len);

				}
				break;
			case 76: {
				/* switch-cbc-in */

	int is_client, prf_id, mac_id, aes;
	unsigned cipher_key_len;

	cipher_key_len = T0_POP();
	aes = T0_POP();
	mac_id = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_cbc_in(ENG, is_client, prf_id, mac_id,
		aes ? ENG->iaes_cbcdec : ENG->ides_cbcdec, cipher_key_len);

				}
				break;
			case 77: {
				/* switch-cbc-out */

	int is_client, prf_id, mac_id, aes;
	unsigned cipher_key_len;

	cipher_key_len = T0_POP();
	aes = T0_POP();
	mac_id = T0_POP();
	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_cbc_out(ENG, is_client, prf_id, mac_id,
		aes ? ENG->iaes_cbcenc : ENG->ides_cbcenc, cipher_key_len);

				}
				break;
			case 78: {
				/* switch-chapol-in */

	int is_client, prf_id;

	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_chapol_in(ENG, is_client, prf_id);

				}
				break;
			case 79: {
				/* switch-chapol-out */

	int is_client, prf_id;

	prf_id = T0_POP();
	is_client = T0_POP();
	br_ssl_engine_switch_chapol_out(ENG, is_client, prf_id);

				}
				break;
			case 80: {
				/* ta-names-total-length */

	size_t u, len;

	len = 0;
	if (CTX->ta_names != NULL) {
		for (u = 0; u < CTX->num_tas; u ++) {
			len += CTX->ta_names[u].len + 2;
		}
	} else if (CTX->tas != NULL) {
		for (u = 0; u < CTX->num_tas; u ++) {
			len += CTX->tas[u].dn.len + 2;
		}
	}
	T0_PUSH(len);

				}
				break;
			case 81: {
				/* test-protocol-name */

	size_t len = T0_POP();
	size_t u;

	for (u = 0; u < ENG->protocol_names_num; u ++) {
		const char *name;

		name = ENG->protocol_names[u];
		if (len == strlen(name) && memcmp(ENG->pad, name, len) == 0) {
			T0_PUSH(u);
			T0_RET();
		}
	}
	T0_PUSHi(-1);

				}
				break;
			case 82: {
				/* total-chain-length */

	size_t u;
	uint32_t total;

	total = 0;
	for (u = 0; u < ENG->chain_len; u ++) {
		total += 3 + (uint32_t)ENG->chain[u].data_len;
	}
	T0_PUSH(total);

				}
				break;
			case 83: {
				/* u< */

	uint32_t b = T0_POP();
	uint32_t a = T0_POP();
	T0_PUSH(-(uint32_t)(a < b));

				}
				break;
			case 84: {
				/* u>> */

	int c = (int)T0_POPi();
	uint32_t x = T0_POP();
	T0_PUSH(x >> c);

				}
				break;
			case 85: {
				/* verify-CV-sig */

	int err;

	err = verify_CV_sig(CTX, T0_POP());
	T0_PUSHi(err);

				}
				break;
			case 86: {
				/* write-blob-chunk */

	size_t clen = ENG->hlen_out;
	if (clen > 0) {
		uint32_t addr, len;

		len = T0_POP();
		addr = T0_POP();
		if ((size_t)len < clen) {
			clen = (size_t)len;
		}
		memcpy(ENG->hbuf_out, (unsigned char *)ENG + addr, clen);
		if (ENG->record_type_out == BR_SSL_HANDSHAKE) {
			br_multihash_update(&ENG->mhash, ENG->hbuf_out, clen);
		}
		T0_PUSH(addr + (uint32_t)clen);
		T0_PUSH(len - (uint32_t)clen);
		ENG->hbuf_out += clen;
		ENG->hlen_out -= clen;
	}

				}
				break;
			case 87: {
				/* write8-native */

	unsigned char x;

	x = (unsigned char)T0_POP();
	if (ENG->hlen_out > 0) {
		if (ENG->record_type_out == BR_SSL_HANDSHAKE) {
			br_multihash_update(&ENG->mhash, &x, 1);
		}
		*ENG->hbuf_out ++ = x;
		ENG->hlen_out --;
		T0_PUSHi(-1);
	} else {
		T0_PUSHi(0);
	}

				}
				break;
			case 88: {
				/* x509-append */

	const br_x509_class *xc;
	size_t len;

	xc = *(ENG->x509ctx);
	len = T0_POP();
	xc->append(ENG->x509ctx, ENG->pad, len);

				}
				break;
			case 89: {
				/* x509-end-cert */

	const br_x509_class *xc;

	xc = *(ENG->x509ctx);
	xc->end_cert(ENG->x509ctx);

				}
				break;
			case 90: {
				/* x509-end-chain */

	const br_x509_class *xc;

	xc = *(ENG->x509ctx);
	T0_PUSH(xc->end_chain(ENG->x509ctx));

				}
				break;
			case 91: {
				/* x509-start-cert */

	const br_x509_class *xc;

	xc = *(ENG->x509ctx);
	xc->start_cert(ENG->x509ctx, T0_POP());

				}
				break;
			case 92: {
				/* x509-start-chain */

	const br_x509_class *xc;
	uint32_t bc;

	bc = T0_POP();
	xc = *(ENG->x509ctx);
	xc->start_chain(ENG->x509ctx, bc ? ENG->server_name : NULL);

				}
				break;
			}

		} else {
			T0_ENTER(ip, rp, t0x);
		}
	}
t0_exit:
	((t0_context *)t0ctx)->dp = dp;
	((t0_context *)t0ctx)->rp = rp;
	((t0_context *)t0ctx)->ip = ip;
}
