/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.SdkClientException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public enum Jackson {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;

    public static String toJsonPrettyString(Object value) {
        try {
            return prettyWriter.writeValueAsString(value);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, clazz);
        }
        catch (Exception e2) {
            throw new SdkClientException("Unable to parse Json String.", e2);
        }
    }

    public static JsonNode jsonNodeOf(String json) {
        return Jackson.fromJsonString(json, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer2) throws IOException {
        return new JsonFactory().createGenerator(writer2);
    }

    public static <T> T loadFrom(File file2, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file2, clazz);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalStateException(e3);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectWriter getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

