/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.BuildExecuter;

public class SetupLoggingActionExecuter
implements BuildExecuter {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final LoggingManagerInternal loggingManager;

    public SetupLoggingActionExecuter(LoggingManagerInternal loggingManager, BuildActionExecuter<BuildActionParameters> delegate) {
        this.loggingManager = loggingManager;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        StartParameterInternal startParameter = action.getStartParameter();
        this.loggingManager.setLevelInternal(startParameter.getLogLevel());
        this.loggingManager.enableUserStandardOutputListeners();
        this.loggingManager.start();
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, requestContext, actionParameters, contextServices);
            return buildActionResult;
        }
        finally {
            this.loggingManager.stop();
        }
    }
}

