/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.base.Objects;
import com.google.common.collect.Interner;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.AbstractModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultCachedMetadata;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntrySerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataStore;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleSourcesSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.BuildCommencedTimeProvider;

public class PersistentModuleMetadataCache
extends AbstractModuleMetadataCache {
    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> cache;
    private final ModuleMetadataStore moduleMetadataStore;
    private final ArtifactCacheLockingManager artifactCacheLockingManager;

    public PersistentModuleMetadataCache(BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager, ArtifactCacheMetadata artifactCacheMetadata, ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeContainerSerializer attributeContainerSerializer, MavenMutableModuleMetadataFactory mavenMetadataFactory, IvyMutableModuleMetadataFactory ivyMetadataFactory, Interner<String> stringInterner, ModuleSourcesSerializer moduleSourcesSerializer, ChecksumService checksumService) {
        super(timeProvider);
        this.moduleMetadataStore = new ModuleMetadataStore((PathKeyFileStore)new DefaultPathKeyFileStore(checksumService, artifactCacheMetadata.getMetaDataStoreDirectory()), new ModuleMetadataSerializer(attributeContainerSerializer, mavenMetadataFactory, ivyMetadataFactory, moduleSourcesSerializer), moduleIdentifierFactory, stringInterner);
        this.artifactCacheLockingManager = artifactCacheLockingManager;
    }

    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> initCache() {
        return this.artifactCacheLockingManager.createCache("module-metadata", new RevisionKeySerializer(), new ModuleMetadataCacheEntrySerializer());
    }

    @Override
    protected ModuleMetadataCache.CachedMetadata get(ModuleComponentAtRepositoryKey key) {
        PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> cache = this.getCache();
        return (ModuleMetadataCache.CachedMetadata)this.artifactCacheLockingManager.useCache(() -> {
            ModuleMetadataCacheEntry entry = (ModuleMetadataCacheEntry)cache.get((Object)key);
            if (entry == null) {
                return null;
            }
            if (entry.isMissing()) {
                return new DefaultCachedMetadata(entry, null, this.timeProvider);
            }
            MutableModuleComponentResolveMetadata metadata = this.moduleMetadataStore.getModuleDescriptor(key);
            if (metadata == null) {
                cache.remove((Object)key);
                return null;
            }
            return new DefaultCachedMetadata(entry, entry.configure(metadata), this.timeProvider);
        });
    }

    @Override
    protected void store(ModuleComponentAtRepositoryKey key, ModuleMetadataCacheEntry entry, ModuleMetadataCache.CachedMetadata cachedMetadata) {
        if (entry.isMissing()) {
            this.getCache().put((Object)key, (Object)entry);
        } else {
            this.artifactCacheLockingManager.useCache(() -> {
                ModuleComponentResolveMetadata metadata = cachedMetadata.getMetadata();
                this.moduleMetadataStore.putModuleDescriptor(key, metadata);
                this.getCache().put((Object)key, (Object)entry);
            });
        }
    }

    private static class RevisionKeySerializer
    extends AbstractSerializer<ModuleComponentAtRepositoryKey> {
        private final ComponentIdentifierSerializer componentIdSerializer = new ComponentIdentifierSerializer();

        private RevisionKeySerializer() {
        }

        public void write(Encoder encoder, ModuleComponentAtRepositoryKey value) throws Exception {
            encoder.writeString((CharSequence)value.getRepositoryId());
            this.componentIdSerializer.write(encoder, (ComponentIdentifier)value.getComponentId());
        }

        public ModuleComponentAtRepositoryKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ModuleComponentIdentifier identifier = (ModuleComponentIdentifier)this.componentIdSerializer.read(decoder);
            return new ModuleComponentAtRepositoryKey(resolverId, identifier);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            RevisionKeySerializer rhs = (RevisionKeySerializer)((Object)obj);
            return Objects.equal((Object)((Object)this.componentIdSerializer), (Object)((Object)rhs.componentIdSerializer));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.componentIdSerializer});
        }
    }
}

