"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var geometry_1 = require("../../../../utils/geometry");
var constants_1 = require("../../rendering/constants");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var compute_chart_transform_1 = require("../../state/selectors/compute_chart_transform");
var get_tooltip_values_highlighted_geoms_1 = require("../../state/selectors/get_tooltip_values_highlighted_geoms");
var HighlighterComponent = (function (_super) {
    __extends(HighlighterComponent, _super);
    function HighlighterComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    HighlighterComponent.prototype.render = function () {
        var _a = this.props, highlightedGeometries = _a.highlightedGeometries, chartTransform = _a.chartTransform, chartDimensions = _a.chartDimensions, chartRotation = _a.chartRotation, chartId = _a.chartId;
        var left = chartDimensions.left + chartTransform.x;
        var top = chartDimensions.top + chartTransform.y;
        var clipWidth = [90, -90].includes(chartRotation) ? chartDimensions.height : chartDimensions.width;
        var clipHeight = [90, -90].includes(chartRotation) ? chartDimensions.width : chartDimensions.height;
        var clipPathId = "echHighlighterClipPath__" + chartId;
        return (react_1.default.createElement("svg", { className: "echHighlighter" },
            react_1.default.createElement("defs", null,
                react_1.default.createElement("clipPath", { id: clipPathId },
                    react_1.default.createElement("rect", { x: "0", y: "0", width: clipWidth, height: clipHeight }))),
            react_1.default.createElement("g", { transform: "translate(" + left + ", " + top + ") rotate(" + chartRotation + ")" }, highlightedGeometries.map(function (geom, i) {
                var color = geom.color, x = geom.x, y = geom.y;
                if (geometry_1.isPointGeometry(geom)) {
                    return (react_1.default.createElement("circle", { key: i, cx: x + geom.transform.x, cy: y, r: geom.radius + constants_1.DEFAULT_HIGHLIGHT_PADDING, stroke: color, strokeWidth: 4, fill: "transparent", clipPath: geom.value.mark !== null ? "url(#" + clipPathId + ")" : undefined }));
                }
                return (react_1.default.createElement("rect", { key: i, x: x, y: y, width: geom.width, height: geom.height, className: "echHighlighterOverlay__fill", clipPath: "url(#" + clipPathId + ")" }));
            }))));
    };
    HighlighterComponent.displayName = 'Highlighter';
    return HighlighterComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            initialized: false,
            chartId: state.chartId,
            highlightedGeometries: [],
            chartTransform: {
                x: 0,
                y: 0,
                rotate: 0,
            },
            chartDimensions: { top: 0, left: 0, width: 0, height: 0 },
            chartRotation: 0,
        };
    }
    return {
        initialized: true,
        chartId: state.chartId,
        highlightedGeometries: get_tooltip_values_highlighted_geoms_1.getHighlightedGeomsSelector(state),
        chartTransform: compute_chart_transform_1.computeChartTransformSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
    };
};
exports.Highlighter = react_redux_1.connect(mapStateToProps)(HighlighterComponent);
//# sourceMappingURL=highlighter.js.map