"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var legend_1 = require("../../legend/legend");
var compute_series_domains_1 = require("./compute_series_domains");
var get_series_color_map_1 = require("./get_series_color_map");
var get_specs_1 = require("./get_specs");
var getDeselectedSeriesSelector = function (state) { return state.interactions.deselectedDataSeries; };
exports.computeLegendSelector = re_reselect_1.default([
    get_specs_1.getSeriesSpecsSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_series_color_map_1.getSeriesColorsSelector,
    get_specs_1.getAxisSpecsSelector,
    getDeselectedSeriesSelector,
], function (seriesSpecs, seriesDomainsAndData, chartTheme, seriesColors, axesSpecs, deselectedDataSeries) { return legend_1.computeLegend(seriesDomainsAndData.seriesCollection, seriesColors, seriesSpecs, chartTheme.colors.defaultVizColor, axesSpecs, deselectedDataSeries); })(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_legend.js.map