"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlock = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _code_block = require("./_code_block");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiCodeBlock = function EuiCodeBlock(_ref) {
  var inline = _ref.inline,
      rest = _objectWithoutProperties(_ref, ["inline"]);

  return _react.default.createElement(_code_block.EuiCodeBlockImpl, _extends({
    inline: false
  }, rest));
};

exports.EuiCodeBlock = EuiCodeBlock;
EuiCodeBlock.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  inline: _propTypes.default.oneOf([false]),
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),
  fontSize: _propTypes.default.oneOf(["s", "m", "l"]),
  overflowHeight: _propTypes.default.number,
  isCopyable: _propTypes.default.bool,

  /**
     * Sets the syntax highlighting for a specific language
     * @see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases
     * for options
     */
  language: _propTypes.default.string,
  transparentBackground: _propTypes.default.bool
};
EuiCodeBlock.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCodeBlock",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "inline": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "false",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "paddingSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "fontSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "overflowHeight": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "isCopyable": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "language": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Sets the syntax highlighting for a specific language\n@see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases\nfor options"
    },
    "transparentBackground": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    }
  }
};