"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableSearch = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form = require("../../form");

var _matching_options = require("../matching_options");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiSelectableSearch =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiSelectableSearch, _Component);

  function EuiSelectableSearch(props) {
    var _this;

    (0, _classCallCheck2.default)(this, EuiSelectableSearch);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiSelectableSearch).call(this, props));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSearchChange", function (value) {
      _this.setState({
        searchValue: value
      });

      var options = _this.props.options;
      var matchingOptions = (0, _matching_options.getMatchingOptions)(options, value);

      _this.passUpMatches(matchingOptions, value);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "passUpMatches", function (matches, searchValue) {
      if (_this.props.onChange) {
        _this.props.onChange(matches, searchValue);
      }
    });
    _this.state = {
      searchValue: props.defaultValue
    };
    return _this;
  }

  (0, _createClass2.default)(EuiSelectableSearch, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var options = this.props.options;
      var searchValue = this.state.searchValue;
      var matchingOptions = (0, _matching_options.getMatchingOptions)(options, searchValue);
      this.passUpMatches(matchingOptions, searchValue);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          onChange = _this$props.onChange,
          options = _this$props.options,
          defaultValue = _this$props.defaultValue,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "onChange", "options", "defaultValue"]);
      var classes = (0, _classnames.default)('euiSelectableSearch', className);
      return _react.default.createElement(_form.EuiFieldSearch, (0, _extends2.default)({
        className: classes,
        placeholder: "Filter options",
        onSearch: this.onSearchChange,
        incremental: true,
        defaultValue: defaultValue,
        fullWidth: true
      }, rest));
    }
  }]);
  return EuiSelectableSearch;
}(_react.Component);

exports.EuiSelectableSearch = EuiSelectableSearch;
(0, _defineProperty2.default)(EuiSelectableSearch, "defaultProps", {
  defaultValue: ''
});
EuiSelectableSearch.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Passes back (matchingOptions, searchValue)
       */
  onChange: _propTypes.default.func,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),

    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: _propTypes.default.string,

    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: _propTypes.default.string,

    /**
       * Leave `undefined` to indicate not selected,
       * 'on' to indicate inclusion and
       * 'off' to indicate exclusion
       */
    checked: _propTypes.default.oneOf(["on", "off", undefined]),
    disabled: _propTypes.default.bool,

    /**
       * Node to add between the selection icon and the label
       */
    prepend: _propTypes.default.node,

    /**
       * Node to add to the far right of the item
       */
    append: _propTypes.default.node,
    ref: _propTypes.default.func,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired).isRequired,
  defaultValue: _propTypes.default.string.isRequired
};
EuiSelectableSearch.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "onSearchChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "value",
      "type": null
    }],
    "returns": null
  }, {
    "name": "passUpMatches",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "matches",
      "type": null
    }, {
      "name": "searchValue",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiSelectableSearch",
  "props": {
    "defaultValue": {
      "defaultValue": {
        "value": "''",
        "computed": false
      },
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Passes back (matchingOptions, searchValue)"
    },
    "options": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "isGroupLabel": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "true",
                  "computed": false
                }]
              }, {
                "name": "enum",
                "value": [{
                  "value": "false",
                  "computed": false
                }]
              }],
              "description": "Optional `boolean`.\nSet to `true` to indicate object is just a grouping label, not a selectable item",
              "required": false
            },
            "label": {
              "name": "string",
              "description": "Visible label of option.\nMust be unique across items if `key` is not supplied",
              "required": false
            },
            "key": {
              "name": "string",
              "description": "Must be unique across items.\nWill be used to match options instead of `label`",
              "required": false
            },
            "checked": {
              "name": "enum",
              "value": [{
                "value": "\"on\"",
                "computed": false
              }, {
                "value": "\"off\"",
                "computed": false
              }, {
                "value": "undefined",
                "computed": true
              }],
              "description": "Leave `undefined` to indicate not selected,\n'on' to indicate inclusion and\n'off' to indicate exclusion",
              "required": false
            },
            "disabled": {
              "name": "bool",
              "required": false
            },
            "prepend": {
              "name": "node",
              "description": "Node to add between the selection icon and the label",
              "required": false
            },
            "append": {
              "name": "node",
              "description": "Node to add to the far right of the item",
              "required": false
            },
            "ref": {
              "name": "func",
              "required": false
            },
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    }
  }
};