"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTelemetryCheck = runTelemetryCheck;

var _listr = _interopRequireDefault(require("listr"));

var _chalk = _interopRequireDefault(require("chalk"));

var _devUtils = require("@kbn/dev-utils");

var _tasks = require("../tools/tasks");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function runTelemetryCheck() {
  (0, _devUtils.run)(async ({
    flags: {
      fix = false,
      path
    },
    log
  }) => {
    if (typeof fix !== 'boolean') {
      throw (0, _devUtils.createFailError)(`${_chalk.default.white.bgRed(' TELEMETRY ERROR ')} --fix can't have a value`);
    }

    if (typeof path === 'boolean') {
      throw (0, _devUtils.createFailError)(`${_chalk.default.white.bgRed(' TELEMETRY ERROR ')} --path require a value`);
    }

    if (fix && typeof path !== 'undefined') {
      throw (0, _devUtils.createFailError)(`${_chalk.default.white.bgRed(' TELEMETRY ERROR ')} --fix is incompatible with --path flag.`);
    }

    const list = new _listr.default([{
      title: 'Checking .telemetryrc.json files',
      task: () => new _listr.default((0, _tasks.parseConfigsTask)(), {
        exitOnError: true
      })
    }, {
      title: 'Extracting Collectors',
      task: context => new _listr.default((0, _tasks.extractCollectorsTask)(context, path), {
        exitOnError: true
      })
    }, {
      title: 'Checking Compatible collector.schema with collector.fetch type',
      task: context => new _listr.default((0, _tasks.checkCompatibleTypesTask)(context), {
        exitOnError: true
      })
    }, {
      title: 'Checking Matching collector.schema against stored json files',
      task: context => new _listr.default((0, _tasks.checkMatchingSchemasTask)(context), {
        exitOnError: true
      })
    }, {
      enabled: _ => fix,
      skip: ({
        roots
      }) => {
        return roots.every(({
          esMappingDiffs
        }) => !esMappingDiffs || !esMappingDiffs.length);
      },
      title: 'Generating new telemetry mappings',
      task: context => new _listr.default((0, _tasks.generateSchemasTask)(context), {
        exitOnError: true
      })
    }, {
      enabled: _ => fix,
      skip: ({
        roots
      }) => {
        return roots.every(({
          esMappingDiffs
        }) => !esMappingDiffs || !esMappingDiffs.length);
      },
      title: 'Updating telemetry mapping files',
      task: context => new _listr.default((0, _tasks.writeToFileTask)(context), {
        exitOnError: true
      })
    }]);

    try {
      const context = (0, _tasks.createTaskContext)();
      await list.run(context);
    } catch (error) {
      process.exitCode = 1;

      if (error instanceof _tasks.ErrorReporter) {
        error.errors.forEach(e => log.error(e));
      } else {
        log.error('Unhandled exception!');
        log.error(error);
      }
    }

    process.exit();
  }, {
    flags: {
      allowUnexpected: true,
      guessTypesForUnexpectedFlags: true
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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