function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { sortBy } from 'lodash';
import { BehaviorSubject, combineLatest, ReplaySubject } from 'rxjs';
import { map, takeUntil } from 'rxjs/operators';
import { toNavLink } from './to_nav_link';
export var NavLinksService = /*#__PURE__*/function () {
  function NavLinksService() {
    _classCallCheck(this, NavLinksService);

    _defineProperty(this, "stop$", new ReplaySubject(1));
  }

  _createClass(NavLinksService, [{
    key: "start",
    value: function start(_ref) {
      var _this = this;

      var application = _ref.application,
          http = _ref.http;
      var appLinks$ = application.applications$.pipe(map(function (apps) {
        return new Map(_toConsumableArray(apps).filter(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
              app = _ref3[1];

          return !app.chromeless;
        }).map(function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 2),
              appId = _ref5[0],
              app = _ref5[1];

          return [appId, toNavLink(app, http.basePath)];
        }));
      })); // now that availableApps$ is an observable, we need to keep record of all
      // manual link modifications to be able to re-apply then after every
      // availableApps$ changes.

      var linkUpdaters$ = new BehaviorSubject([]);
      var navLinks$ = new BehaviorSubject(new Map());
      combineLatest([appLinks$, linkUpdaters$]).pipe(map(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 2),
            appLinks = _ref7[0],
            linkUpdaters = _ref7[1];

        return linkUpdaters.reduce(function (links, updater) {
          return updater(links);
        }, appLinks);
      })).subscribe(function (navlinks) {
        navLinks$.next(navlinks);
      });
      var forceAppSwitcherNavigation$ = new BehaviorSubject(false);
      return {
        getNavLinks$: function getNavLinks$() {
          return navLinks$.pipe(map(sortNavLinks), takeUntil(_this.stop$));
        },
        get: function get(id) {
          var link = navLinks$.value.get(id);
          return link && link.properties;
        },
        getAll: function getAll() {
          return sortNavLinks(navLinks$.value);
        },
        has: function has(id) {
          return navLinks$.value.has(id);
        },
        showOnly: function showOnly(id) {
          if (!this.has(id)) {
            return;
          }

          var updater = function updater(navLinks) {
            return new Map(_toConsumableArray(navLinks.entries()).filter(function (_ref8) {
              var _ref9 = _slicedToArray(_ref8, 1),
                  linkId = _ref9[0];

              return linkId === id;
            }));
          };

          linkUpdaters$.next([].concat(_toConsumableArray(linkUpdaters$.value), [updater]));
        },
        update: function update(id, values) {
          if (!this.has(id)) {
            return;
          }

          var updater = function updater(navLinks) {
            return new Map(_toConsumableArray(navLinks.entries()).map(function (_ref10) {
              var _ref11 = _slicedToArray(_ref10, 2),
                  linkId = _ref11[0],
                  link = _ref11[1];

              return [linkId, link.id === id ? link.update(values) : link];
            }));
          };

          linkUpdaters$.next([].concat(_toConsumableArray(linkUpdaters$.value), [updater]));
          return this.get(id);
        },
        enableForcedAppSwitcherNavigation: function enableForcedAppSwitcherNavigation() {
          forceAppSwitcherNavigation$.next(true);
        },
        getForceAppSwitcherNavigation$: function getForceAppSwitcherNavigation$() {
          return forceAppSwitcherNavigation$.asObservable();
        }
      };
    }
  }, {
    key: "stop",
    value: function stop() {
      this.stop$.next();
    }
  }]);

  return NavLinksService;
}();

function sortNavLinks(navLinks) {
  return sortBy(_toConsumableArray(navLinks.values()).map(function (link) {
    return link.properties;
  }), 'order');
}