function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { BehaviorSubject, Subject } from 'rxjs';
import { distinctUntilChanged, endWith, map, pairwise, startWith, takeUntil, tap } from 'rxjs/operators';

/** @internal */
export var LoadingCountService = /*#__PURE__*/function () {
  function LoadingCountService() {
    _classCallCheck(this, LoadingCountService);

    _defineProperty(this, "stop$", new Subject());

    _defineProperty(this, "loadingCount$", new BehaviorSubject(0));
  }

  _createClass(LoadingCountService, [{
    key: "setup",
    value: function setup(_ref) {
      var _this = this;

      var fatalErrors = _ref.fatalErrors;
      return {
        getLoadingCount$: function getLoadingCount$() {
          return _this.loadingCount$.pipe(distinctUntilChanged());
        },
        addLoadingCountSource: function addLoadingCountSource(count$) {
          count$.pipe(distinctUntilChanged(), tap(function (count) {
            if (count < 0) {
              throw new Error('Observables passed to loadingCount.add() must only emit positive numbers');
            }
          }), // use takeUntil() so that we can finish each stream on stop() the same way we do when they complete,
          // by removing the previous count from the total
          takeUntil(_this.stop$), endWith(0), startWith(0), pairwise(), map(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
                prev = _ref3[0],
                next = _ref3[1];

            return next - prev;
          })).subscribe({
            next: function next(delta) {
              _this.loadingCount$.next(_this.loadingCount$.getValue() + delta);
            },
            error: function error(_error) {
              return fatalErrors.add(_error);
            }
          });
        }
      };
    }
  }, {
    key: "start",
    value: function start(_ref4) {
      var fatalErrors = _ref4.fatalErrors;
      return this.setup({
        fatalErrors: fatalErrors
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      this.stop$.next();
      this.loadingCount$.complete();
    }
  }]);

  return LoadingCountService;
}();