function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { createBrowserHistory } from 'history';
import { setSetupServices, setStartServices } from './set_services';
import { ScopedHistory } from '../../../../core/public';
export var npSetup = {
  core: null,
  plugins: {}
};
export var npStart = {
  core: null,
  plugins: {}
};
/**
 * Only used by unit tests
 * @internal
 */

export function __reset__() {
  npSetup.core = null;
  npSetup.plugins = {};
  npStart.core = null;
  npStart.plugins = {};
  legacyAppRegistered = false;
}
export function __setup__(coreSetup, plugins) {
  npSetup.core = coreSetup;
  npSetup.plugins = plugins; // Setup compatibility layer for AppService in legacy platform

  npSetup.core.application.register = legacyAppRegister; // Services that need to be set in the legacy platform since the legacy data
  // & vis plugins which previously provided them have been removed.

  setSetupServices(npSetup);
}
export function __start__(coreStart, plugins) {
  npStart.core = coreStart;
  npStart.plugins = plugins; // Services that need to be set in the legacy platform since the legacy data
  // & vis plugins which previously provided them have been removed.

  setStartServices(npStart);
}
/** Flag used to ensure `legacyAppRegister` is only called once. */

var legacyAppRegistered = false;
/**
 * Exported for testing only. Use `npSetup.core.application.register` in legacy apps.
 * @internal
 */

export var legacyAppRegister = function legacyAppRegister(app) {
  if (legacyAppRegistered) {
    throw new Error("core.application.register may only be called once for legacy plugins.");
  }

  legacyAppRegistered = true; // eslint-disable-next-line @typescript-eslint/no-var-requires

  var _require = require('ui/chrome'),
      chrome = _require.default;

  chrome.setRootController(app.id, function ($scope, $element) {
    var element = document.createElement('div');
    $element[0].appendChild(element); // Root controller cannot return a Promise so use an internal async function and call it immediately

    _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var appRoute, appBasePath, params, unmount;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              appRoute = app.appRoute || "/app/".concat(app.id);
              appBasePath = npSetup.core.http.basePath.prepend(appRoute);
              params = {
                element: element,
                appBasePath: appBasePath,
                history: new ScopedHistory(createBrowserHistory({
                  basename: npSetup.core.http.basePath.get()
                }), appRoute),
                onAppLeave: function onAppLeave() {
                  return undefined;
                }
              };

              if (!isAppMountDeprecated(app.mount)) {
                _context.next = 9;
                break;
              }

              _context.next = 6;
              return app.mount({
                core: npStart.core
              }, params);

            case 6:
              _context.t0 = _context.sent;
              _context.next = 12;
              break;

            case 9:
              _context.next = 11;
              return app.mount(params);

            case 11:
              _context.t0 = _context.sent;

            case 12:
              unmount = _context.t0;
              $scope.$on('$destroy', function () {
                unmount();
              });

            case 14:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  });
};

function isAppMountDeprecated(mount) {
  // Mount functions with two arguments are assumed to expect deprecated `context` object.
  return mount.length === 2;
}