function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { reverseSortDir } from './utils/sorting';
import { extractNanos, convertIsoToMillis } from './utils/date_conversion';
import { fetchHitsInInterval } from './utils/fetch_hits_in_interval';
import { generateIntervals } from './utils/generate_intervals';
import { getEsQuerySearchAfter } from './utils/get_es_query_search_after';
import { getEsQuerySort } from './utils/get_es_query_sort';
import { getServices } from '../../../../kibana_services';
var DAY_MILLIS = 24 * 60 * 60 * 1000; // look from 1 day up to 10000 days into the past and future

var LOOKUP_OFFSETS = [0, 1, 7, 30, 365, 10000].map(function (days) {
  return days * DAY_MILLIS;
});

function fetchContextProvider(indexPatterns) {
  return {
    fetchSurroundingDocs: fetchSurroundingDocs
  };
  /**
   * Fetch successor or predecessor documents of a given anchor document
   *
   * @param {SurrDocType} type - `successors` or `predecessors`
   * @param {string} indexPatternId
   * @param {EsHitRecord} anchor - anchor record
   * @param {string} timeField - name of the timefield, that's sorted on
   * @param {string} tieBreakerField - name of the tie breaker, the 2nd sort field
   * @param {SortDirection} sortDir - direction of sorting
   * @param {number} size - number of records to retrieve
   * @param {Filter[]} filters - to apply in the elastic query
   * @returns {Promise<object[]>}
   */

  function fetchSurroundingDocs(_x, _x2, _x3, _x4, _x5, _x6, _x7, _x8) {
    return _fetchSurroundingDocs.apply(this, arguments);
  }

  function _fetchSurroundingDocs() {
    _fetchSurroundingDocs = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(type, indexPatternId, anchor, timeField, tieBreakerField, sortDir, size, filters) {
      var indexPattern, searchSource, sortDirToApply, nanos, timeValueMillis, intervals, documents, _iterator, _step, interval, remainingSize, searchAfter, sort, hits;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!(_typeof(anchor) !== 'object' || anchor === null || !size)) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return", []);

            case 2:
              _context.next = 4;
              return indexPatterns.get(indexPatternId);

            case 4:
              indexPattern = _context.sent;
              _context.next = 7;
              return createSearchSource(indexPattern, filters);

            case 7:
              searchSource = _context.sent;
              sortDirToApply = type === 'successors' ? sortDir : reverseSortDir(sortDir);
              nanos = indexPattern.isTimeNanosBased() ? extractNanos(anchor._source[timeField]) : '';
              timeValueMillis = nanos !== '' ? convertIsoToMillis(anchor._source[timeField]) : anchor.sort[0];
              intervals = generateIntervals(LOOKUP_OFFSETS, timeValueMillis, type, sortDir);
              documents = [];
              _iterator = _createForOfIteratorHelper(intervals);
              _context.prev = 14;

              _iterator.s();

            case 16:
              if ((_step = _iterator.n()).done) {
                _context.next = 29;
                break;
              }

              interval = _step.value;
              remainingSize = size - documents.length;

              if (!(remainingSize <= 0)) {
                _context.next = 21;
                break;
              }

              return _context.abrupt("break", 29);

            case 21:
              searchAfter = getEsQuerySearchAfter(type, documents, timeField, anchor, nanos);
              sort = getEsQuerySort(timeField, tieBreakerField, sortDirToApply);
              _context.next = 25;
              return fetchHitsInInterval(searchSource, timeField, sort, sortDirToApply, interval, searchAfter, remainingSize, nanos);

            case 25:
              hits = _context.sent;
              documents = type === 'successors' ? [].concat(_toConsumableArray(documents), _toConsumableArray(hits)) : [].concat(_toConsumableArray(hits.slice().reverse()), _toConsumableArray(documents));

            case 27:
              _context.next = 16;
              break;

            case 29:
              _context.next = 34;
              break;

            case 31:
              _context.prev = 31;
              _context.t0 = _context["catch"](14);

              _iterator.e(_context.t0);

            case 34:
              _context.prev = 34;

              _iterator.f();

              return _context.finish(34);

            case 37:
              return _context.abrupt("return", documents);

            case 38:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[14, 31, 34, 37]]);
    }));
    return _fetchSurroundingDocs.apply(this, arguments);
  }

  function createSearchSource(_x9, _x10) {
    return _createSearchSource.apply(this, arguments);
  }

  function _createSearchSource() {
    _createSearchSource = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(indexPattern, filters) {
      var _getServices, data, searchSource;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _getServices = getServices(), data = _getServices.data;
              _context2.next = 3;
              return data.search.searchSource.create();

            case 3:
              searchSource = _context2.sent;
              return _context2.abrupt("return", searchSource.setParent(undefined).setField('index', indexPattern).setField('filter', filters));

            case 5:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));
    return _createSearchSource.apply(this, arguments);
  }
}

export { fetchContextProvider };