function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiToolTip } from '@elastic/eui';
import { FieldIcon } from '../../../../../kibana_react/public';
import { shortenDottedString } from '../../helpers';
import { getFieldTypeName } from './field_type_name'; // properties fieldType and fieldName are provided in kbn_doc_view
// this should be changed when both components are deangularized

export function FieldName(_ref) {
  var fieldName = _ref.fieldName,
      fieldType = _ref.fieldType,
      useShortDots = _ref.useShortDots,
      fieldIconProps = _ref.fieldIconProps,
      _ref$scripted = _ref.scripted,
      scripted = _ref$scripted === void 0 ? false : _ref$scripted;
  var typeName = getFieldTypeName(fieldType);
  var displayName = useShortDots ? shortenDottedString(fieldName) : fieldName;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(FieldIcon, _extends({
    type: fieldType,
    label: typeName,
    scripted: scripted
  }, fieldIconProps))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiToolTip, {
    position: "top",
    content: displayName,
    delay: "long",
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement("span", null, displayName))));
}