function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './test_script.scss';
import React, { Component, Fragment } from 'react';
import { EuiButton, EuiCodeBlock, EuiComboBox, EuiFormRow, EuiText, EuiSpacer, EuiTitle, EuiCallOut } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { esQuery, UI_SETTINGS } from '../../../../../../../plugins/data/public';
import { context as contextType } from '../../../../../../kibana_react/public';
export var TestScript = /*#__PURE__*/function (_Component) {
  _inherits(TestScript, _Component);

  var _super = _createSuper(TestScript);

  function TestScript() {
    var _this;

    _classCallCheck(this, TestScript);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "context", void 0);

    _defineProperty(_assertThisInitialized(_this), "defaultProps", {
      name: 'myScriptedField'
    });

    _defineProperty(_assertThisInitialized(_this), "state", {
      isLoading: false,
      additionalFields: [],
      previewData: undefined
    });

    _defineProperty(_assertThisInitialized(_this), "previewScript", /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(searchContext) {
        var _this$props, indexPattern, lang, name, script, executeScript, query, esQueryConfigs, scriptResponse;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$props = _this.props, indexPattern = _this$props.indexPattern, lang = _this$props.lang, name = _this$props.name, script = _this$props.script, executeScript = _this$props.executeScript;

                if (!(!script || script.length === 0)) {
                  _context.next = 3;
                  break;
                }

                return _context.abrupt("return");

              case 3:
                _this.setState({
                  isLoading: true
                });

                if (searchContext) {
                  esQueryConfigs = esQuery.getEsQueryConfig(_this.context.services.uiSettings);
                  query = esQuery.buildEsQuery(_this.props.indexPattern, searchContext.query || [], [], esQueryConfigs);
                }

                _context.next = 7;
                return executeScript({
                  name: name,
                  lang: lang,
                  script: script,
                  indexPatternTitle: indexPattern.title,
                  query: query,
                  additionalFields: _this.state.additionalFields.map(function (option) {
                    return option.value;
                  }),
                  http: _this.context.services.http
                });

              case 7:
                scriptResponse = _context.sent;

                if (!(scriptResponse.status !== 200)) {
                  _context.next = 11;
                  break;
                }

                _this.setState({
                  isLoading: false,
                  previewData: scriptResponse
                });

                return _context.abrupt("return");

              case 11:
                _this.setState({
                  isLoading: false,
                  previewData: scriptResponse.hits.hits.map(function (hit) {
                    return _objectSpread(_objectSpread({
                      _id: hit._id
                    }, hit._source), hit.fields);
                  })
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "onAdditionalFieldsChange", function (selectedOptions) {
      _this.setState({
        additionalFields: selectedOptions
      });
    });

    return _this;
  }

  _createClass(TestScript, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.script) {
        this.previewScript();
      }
    }
  }, {
    key: "renderPreview",
    value: function renderPreview(previewData) {
      if (!previewData) {
        return null;
      }

      if (previewData.error) {
        return /*#__PURE__*/React.createElement(EuiCallOut, {
          title: i18n.translate('indexPatternManagement.testScript.errorMessage', {
            defaultMessage: "There's an error in your script"
          }),
          color: "danger",
          iconType: "cross"
        }, /*#__PURE__*/React.createElement(EuiCodeBlock, {
          language: "json",
          className: "scriptPreviewCodeBlock",
          "data-test-subj": "scriptedFieldPreview"
        }, JSON.stringify(previewData.error, null, ' ')));
      }

      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.testScript.resultsLabel",
        defaultMessage: "First 10 results"
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement(EuiCodeBlock, {
        language: "json",
        className: "scriptPreviewCodeBlock",
        "data-test-subj": "scriptedFieldPreview"
      }, JSON.stringify(previewData, null, ' ')));
    }
  }, {
    key: "renderToolbar",
    value: function renderToolbar() {
      var _this2 = this;

      var fieldsByTypeMap = new Map();
      var fields = [];
      this.props.indexPattern.fields.filter(function (field) {
        var isMultiField = field.subType && field.subType.multi;
        return !field.name.startsWith('_') && !isMultiField && !field.scripted;
      }).forEach(function (field) {
        if (fieldsByTypeMap.has(field.type)) {
          var fieldsList = fieldsByTypeMap.get(field.type);
          fieldsList.push(field.name);
          fieldsByTypeMap.set(field.type, fieldsList);
        } else {
          fieldsByTypeMap.set(field.type, [field.name]);
        }
      });
      fieldsByTypeMap.forEach(function (fieldsList, fieldType) {
        fields.push({
          label: fieldType,
          options: fieldsList.sort().map(function (fieldName) {
            return {
              value: fieldName,
              label: fieldName
            };
          })
        });
      });
      fields.sort(function (a, b) {
        if (a.label < b.label) return -1;
        if (a.label > b.label) return 1;
        return 0;
      });
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('indexPatternManagement.testScript.fieldsLabel', {
          defaultMessage: 'Additional fields'
        }),
        fullWidth: true
      }, /*#__PURE__*/React.createElement(EuiComboBox, {
        placeholder: i18n.translate('indexPatternManagement.testScript.fieldsPlaceholder', {
          defaultMessage: 'Select...'
        }),
        options: fields,
        selectedOptions: this.state.additionalFields,
        onChange: function onChange(selected) {
          return _this2.onAdditionalFieldsChange(selected);
        },
        "data-test-subj": "additionalFieldsSelect",
        fullWidth: true
      })), /*#__PURE__*/React.createElement("div", {
        className: "testScript__searchBar"
      }, /*#__PURE__*/React.createElement(this.context.services.data.ui.SearchBar, {
        appName: 'indexPatternManagement',
        showFilterBar: false,
        showDatePicker: false,
        showQueryInput: true,
        query: {
          language: this.context.services.uiSettings.get(UI_SETTINGS.SEARCH_QUERY_LANGUAGE),
          query: ''
        },
        onQuerySubmit: this.previewScript,
        indexPatterns: [this.props.indexPattern],
        customSubmitButton: /*#__PURE__*/React.createElement(EuiButton, {
          disabled: this.props.script ? false : true,
          isLoading: this.state.isLoading,
          "data-test-subj": "runScriptButton"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.testScript.submitButtonLabel",
          defaultMessage: "Run script"
        }))
      })));
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.testScript.resultsTitle",
        defaultMessage: "Preview results"
      })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.testScript.instructions",
        defaultMessage: "Run your script to preview the first 10 results. You can also select some additional fields to include in your results to gain more context or add a query to filter on specific documents."
      }))), /*#__PURE__*/React.createElement(EuiSpacer, null), this.renderToolbar(), /*#__PURE__*/React.createElement(EuiSpacer, null), this.renderPreview(this.state.previewData));
    }
  }]);

  return TestScript;
}(Component);

_defineProperty(TestScript, "contextType", contextType);