function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import classNames from 'classnames';
import { EuiToken } from '@elastic/eui';
// defaultIcon => a unknown datatype
var defaultIcon = {
  iconType: 'questionInCircle',
  color: 'gray'
};
export var typeToEuiIconMap = {
  boolean: {
    iconType: 'tokenBoolean'
  },
  // icon for an index pattern mapping conflict in discover
  conflict: {
    iconType: 'alert',
    color: 'euiVisColor9'
  },
  date: {
    iconType: 'tokenDate'
  },
  geo_point: {
    iconType: 'tokenGeo'
  },
  geo_shape: {
    iconType: 'tokenGeo'
  },
  ip: {
    iconType: 'tokenIP'
  },
  // is a plugin's data type https://www.elastic.co/guide/en/elasticsearch/plugins/current/mapper-murmur3-usage.html
  murmur3: {
    iconType: 'tokenFile'
  },
  number: {
    iconType: 'tokenNumber'
  },
  _source: {
    iconType: 'editorCodeBlock',
    color: 'gray'
  },
  string: {
    iconType: 'tokenString'
  },
  nested: {
    iconType: 'tokenNested'
  }
};
/**
 * Field token icon used across the app
 */

export function FieldIcon(_ref) {
  var type = _ref.type,
      label = _ref.label,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 's' : _ref$size,
      scripted = _ref.scripted,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["type", "label", "size", "scripted", "className"]);

  var token = typeToEuiIconMap[type] || defaultIcon;
  return /*#__PURE__*/React.createElement(EuiToken, _extends({}, token, {
    className: classNames('kbnFieldIcon', className),
    "aria-label": label || type,
    title: label || type,
    size: size,
    fill: scripted ? 'dark' : undefined
  }, rest));
}