function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiButton, EuiCopy, EuiFlexGroup, EuiSpacer, EuiFlexItem, EuiForm, EuiFormRow, EuiIconTip, EuiLoadingSpinner, EuiRadioGroup, EuiSwitch } from '@elastic/eui';
import { format as formatUrl, parse as parseUrl } from 'url';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { shortenUrl } from '../lib/url_shortener';
export var ExportUrlAsType;

(function (ExportUrlAsType) {
  ExportUrlAsType["EXPORT_URL_AS_SAVED_OBJECT"] = "savedObject";
  ExportUrlAsType["EXPORT_URL_AS_SNAPSHOT"] = "snapshot";
})(ExportUrlAsType || (ExportUrlAsType = {}));

export var UrlPanelContent = /*#__PURE__*/function (_Component) {
  _inherits(UrlPanelContent, _Component);

  var _super = _createSuper(UrlPanelContent);

  function UrlPanelContent(props) {
    var _this;

    _classCallCheck(this, UrlPanelContent);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "mounted", void 0);

    _defineProperty(_assertThisInitialized(_this), "shortUrlCache", void 0);

    _defineProperty(_assertThisInitialized(_this), "isNotSaved", function () {
      return _this.props.objectId === undefined || _this.props.objectId === '';
    });

    _defineProperty(_assertThisInitialized(_this), "resetUrl", function () {
      if (_this.mounted) {
        _this.shortUrlCache = undefined;

        _this.setState({
          useShortUrl: false
        }, _this.setUrl);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "updateUrlParams", function (url) {
      var embedUrl = _this.props.isEmbedded ? _this.makeUrlEmbeddable(url) : url;
      var extendUrl = _this.state.urlParams ? _this.getUrlParamExtensions(embedUrl) : embedUrl;
      return extendUrl;
    });

    _defineProperty(_assertThisInitialized(_this), "getSavedObjectUrl", function () {
      if (_this.isNotSaved()) {
        return;
      }

      var url = _this.getSnapshotUrl();

      var parsedUrl = parseUrl(url);

      if (!parsedUrl || !parsedUrl.hash) {
        return;
      } // Get the application route, after the hash, and remove the #.


      var parsedAppUrl = parseUrl(parsedUrl.hash.slice(1), true);
      var formattedUrl = formatUrl({
        protocol: parsedUrl.protocol,
        auth: parsedUrl.auth,
        host: parsedUrl.host,
        pathname: parsedUrl.pathname,
        hash: formatUrl({
          pathname: parsedAppUrl.pathname,
          query: {
            // Add global state to the URL so that the iframe doesn't just show the time range
            // default.
            _g: parsedAppUrl.query._g
          }
        })
      });
      return _this.updateUrlParams(formattedUrl);
    });

    _defineProperty(_assertThisInitialized(_this), "getSnapshotUrl", function () {
      var url = _this.props.shareableUrl || window.location.href;
      return _this.updateUrlParams(url);
    });

    _defineProperty(_assertThisInitialized(_this), "makeUrlEmbeddable", function (url) {
      var embedParam = '?embed=true';
      var urlHasQueryString = url.indexOf('?') !== -1;

      if (urlHasQueryString) {
        return url.replace('?', "".concat(embedParam, "&"));
      }

      return "".concat(url).concat(embedParam);
    });

    _defineProperty(_assertThisInitialized(_this), "getUrlParamExtensions", function (url) {
      var urlParams = _this.state.urlParams;
      return urlParams ? Object.keys(urlParams).reduce(function (urlAccumulator, key) {
        var urlParam = urlParams[key];
        return urlParam ? Object.keys(urlParam).reduce(function (queryAccumulator, queryParam) {
          var isQueryParamEnabled = urlParam[queryParam];
          return isQueryParamEnabled ? queryAccumulator + "&".concat(queryParam, "=true") : queryAccumulator;
        }, urlAccumulator) : urlAccumulator;
      }, url) : url;
    });

    _defineProperty(_assertThisInitialized(_this), "makeIframeTag", function (url) {
      if (!url) {
        return;
      }

      return "<iframe src=\"".concat(url, "\" height=\"600\" width=\"800\"></iframe>");
    });

    _defineProperty(_assertThisInitialized(_this), "setUrl", function () {
      var url;

      if (_this.state.exportUrlAs === ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT) {
        url = _this.getSavedObjectUrl();
      } else if (_this.state.useShortUrl) {
        url = _this.shortUrlCache;
      } else {
        url = _this.getSnapshotUrl();
      }

      if (_this.props.isEmbedded) {
        url = _this.makeIframeTag(url);
      }

      _this.setState({
        url: url
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleExportUrlAs", function (optionId) {
      _this.setState({
        exportUrlAs: optionId
      }, _this.setUrl);
    });

    _defineProperty(_assertThisInitialized(_this), "handleShortUrlChange", /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(evt) {
        var isChecked;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                isChecked = evt.target.checked;

                if (!(!isChecked || _this.shortUrlCache !== undefined)) {
                  _context.next = 4;
                  break;
                }

                _this.setState({
                  useShortUrl: isChecked
                }, _this.setUrl);

                return _context.abrupt("return");

              case 4:
                // "Use short URL" is checked but shortUrl has not been generated yet so one needs to be created.
                _this.createShortUrl();

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "createShortUrl", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var shortUrl;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _this.setState({
                isCreatingShortUrl: true,
                shortUrlErrorMsg: undefined
              });

              _context2.prev = 1;
              _context2.next = 4;
              return shortenUrl(_this.getSnapshotUrl(), {
                basePath: _this.props.basePath,
                post: _this.props.post
              });

            case 4:
              shortUrl = _context2.sent;

              if (_this.mounted) {
                _this.shortUrlCache = shortUrl;

                _this.setState({
                  isCreatingShortUrl: false,
                  useShortUrl: true
                }, _this.setUrl);
              }

              _context2.next = 11;
              break;

            case 8:
              _context2.prev = 8;
              _context2.t0 = _context2["catch"](1);

              if (_this.mounted) {
                _this.shortUrlCache = undefined;

                _this.setState({
                  useShortUrl: false,
                  isCreatingShortUrl: false,
                  shortUrlErrorMsg: i18n.translate('share.urlPanel.unableCreateShortUrlErrorMessage', {
                    defaultMessage: 'Unable to create short URL. Error: {errorMessage}',
                    values: {
                      errorMessage: _context2.t0.message
                    }
                  })
                }, _this.setUrl);
              }

            case 11:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[1, 8]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "renderExportUrlAsOptions", function () {
      return [_defineProperty({
        id: ExportUrlAsType.EXPORT_URL_AS_SNAPSHOT,
        label: _this.renderWithIconTip( /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.snapshotLabel",
          defaultMessage: "Snapshot"
        }), /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.snapshotDescription",
          defaultMessage: "Snapshot URLs encode the current state of the {objectType} in the URL itself. Edits to the saved {objectType} won't be visible via this URL.",
          values: {
            objectType: _this.props.objectType
          }
        }))
      }, 'data-test-subj', 'exportAsSnapshot'), _defineProperty({
        id: ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT,
        disabled: _this.isNotSaved(),
        label: _this.renderWithIconTip( /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.savedObjectLabel",
          defaultMessage: "Saved object"
        }), /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.savedObjectDescription",
          defaultMessage: "You can share this URL with people to let them load the most recent saved version of this {objectType}.",
          values: {
            objectType: _this.props.objectType
          }
        }))
      }, 'data-test-subj', 'exportAsSavedObject')];
    });

    _defineProperty(_assertThisInitialized(_this), "renderWithIconTip", function (child, tipContent) {
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, child), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiIconTip, {
        content: tipContent,
        position: "bottom"
      })));
    });

    _defineProperty(_assertThisInitialized(_this), "renderExportAsRadioGroup", function () {
      var generateLinkAsHelp = _this.isNotSaved() ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "share.urlPanel.canNotShareAsSavedObjectHelpText",
        defaultMessage: "Can't share as saved object until the {objectType} has been saved.",
        values: {
          objectType: _this.props.objectType
        }
      }) : undefined;
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.generateLinkAsLabel",
          defaultMessage: "Generate the link as"
        }),
        helpText: generateLinkAsHelp
      }, /*#__PURE__*/React.createElement(EuiRadioGroup, {
        options: _this.renderExportUrlAsOptions(),
        idSelected: _this.state.exportUrlAs,
        onChange: _this.handleExportUrlAs
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "renderShortUrlSwitch", function () {
      if (_this.state.exportUrlAs === ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT || !_this.props.allowShortUrl) {
        return;
      }

      var shortUrlLabel = /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "share.urlPanel.shortUrlLabel",
        defaultMessage: "Short URL"
      });
      var switchLabel = _this.state.isCreatingShortUrl ? /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
        size: "s"
      }), " ", shortUrlLabel) : shortUrlLabel;
      var switchComponent = /*#__PURE__*/React.createElement(EuiSwitch, {
        label: switchLabel,
        checked: _this.state.useShortUrl,
        onChange: _this.handleShortUrlChange,
        "data-test-subj": "useShortUrl"
      });
      var tipContent = /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "share.urlPanel.shortUrlHelpText",
        defaultMessage: "We recommend sharing shortened snapshot URLs for maximum compatibility. Internet Explorer has URL length restrictions, and some wiki and markup parsers don't do well with the full-length version of the snapshot URL, but the short URL should work great."
      });
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        helpText: _this.state.shortUrlErrorMsg,
        "data-test-subj": "createShortUrl"
      }, _this.renderWithIconTip(switchComponent, tipContent));
    });

    _defineProperty(_assertThisInitialized(_this), "renderUrlParamExtensions", function () {
      if (!_this.props.urlParamExtensions) {
        return;
      }

      var setParamValue = function setParamValue(paramName) {
        return function () {
          var values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          var stateUpdate = {
            urlParams: _objectSpread(_objectSpread({}, _this.state.urlParams), {}, _defineProperty({}, paramName, _objectSpread({}, values)))
          };

          _this.setState(stateUpdate, _this.state.useShortUrl ? _this.createShortUrl : _this.setUrl);
        };
      };

      return /*#__PURE__*/React.createElement(React.Fragment, null, _this.props.urlParamExtensions.map(function (_ref5) {
        var paramName = _ref5.paramName,
            UrlParamComponent = _ref5.component;
        return /*#__PURE__*/React.createElement(EuiFormRow, {
          key: paramName
        }, /*#__PURE__*/React.createElement(UrlParamComponent, {
          setParamValue: setParamValue(paramName)
        }));
      }));
    });

    _this.shortUrlCache = undefined;
    _this.state = {
      exportUrlAs: ExportUrlAsType.EXPORT_URL_AS_SNAPSHOT,
      useShortUrl: false,
      isCreatingShortUrl: false,
      url: ''
    };
    return _this;
  }

  _createClass(UrlPanelContent, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('hashchange', this.resetUrl);
      this.mounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.mounted = true;
      this.setUrl();
      window.addEventListener('hashchange', this.resetUrl, false);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiForm, {
        className: "kbnShareContextMenu__finalPanel",
        "data-test-subj": "shareUrlForm"
      }, this.renderExportAsRadioGroup(), this.renderUrlParamExtensions(), this.renderShortUrlSwitch(), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiCopy, {
        textToCopy: this.state.url || '',
        anchorClassName: "eui-displayBlock"
      }, function (copy) {
        return /*#__PURE__*/React.createElement(EuiButton, {
          fill: true,
          fullWidth: true,
          onClick: copy,
          disabled: _this2.state.isCreatingShortUrl || _this2.state.url === '',
          "data-share-url": _this2.state.url,
          "data-test-subj": "copyShareUrlButton",
          size: "s"
        }, _this2.props.isEmbedded ? /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.copyIframeCodeButtonLabel",
          defaultMessage: "Copy iFrame code"
        }) : /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "share.urlPanel.copyLinkButtonLabel",
          defaultMessage: "Copy link"
        }));
      })));
    }
  }]);

  return UrlPanelContent;
}(Component);