// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Message_Printer_HeaderFile
#define _Message_Printer_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Message_Printer.hxx>

#include <Message_Gravity.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_CString.hxx>
class TCollection_ExtendedString;
class TCollection_AsciiString;


//! Abstract interface class defining printer as output context for text messages
//!
//! The message, besides being text string, has associated gravity
//! level, which can be used by printer to decide either to process a message or ignore it.
class Message_Printer : public MMgt_TShared
{

public:

  
  //! Return trace level used for filtering messages;
  //! messages with lover gravity will be ignored.
      Message_Gravity GetTraceLevel()  const;
  
  //! Set trace level used for filtering messages.
  //! By default, trace level is Message_Info, so that all messages are output
      void SetTraceLevel (const Message_Gravity theTraceLevel) ;
  
  //! Send a string message with specified trace level.
  //! The parameter theToPutEol specified whether end-of-line should be added to the end of the message.
  //! This method must be redefined in descentant.
  Standard_EXPORT virtual   void Send (const TCollection_ExtendedString& theString, const Message_Gravity theGravity, const Standard_Boolean theToPutEol)  const = 0;
  
  //! Send a string message with specified trace level.
  //! The parameter theToPutEol specified whether end-of-line should be added to the end of the message.
  //! Default implementation calls first method Send().
  Standard_EXPORT virtual   void Send (const Standard_CString theString, const Message_Gravity theGravity, const Standard_Boolean theToPutEol)  const;
  
  //! Send a string message with specified trace level.
  //! The parameter theToPutEol specified whether end-of-line should be added to the end of the message.
  //! Default implementation calls first method Send().
  Standard_EXPORT virtual   void Send (const TCollection_AsciiString& theString, const Message_Gravity theGravity, const Standard_Boolean theToPutEol)  const;




  DEFINE_STANDARD_RTTI(Message_Printer)

protected:

  
  //! Empty constructor with Message_Info trace level
  Standard_EXPORT Message_Printer();

  Message_Gravity myTraceLevel;


private: 




};


#include <Message_Printer.lxx>





#endif // _Message_Printer_HeaderFile
