/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service
public final class GitRollbackEnvironment
implements RollbackEnvironment {
    @NotNull
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        if (project == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        String string = GitBundle.message("git.rollback", new Object[0]);
        if (string == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void rollbackModifiedWithoutCheckout(@NotNull List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Explicit file checkout is not supported by Git.");
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Missing file delete is not reported by Git.");
    }

    public void rollbackIfUnchanged(@NotNull VirtualFile file) {
        if (file == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(4);
        }
    }

    public void rollbackChanges(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(5);
        }
        if (exceptions == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(7);
        }
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toUnversion = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    this.registerFile(toUnversion, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    this.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), false);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (Map.Entry entry : toUnversion.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), true);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (FilePath filePath : toDelete) {
            listener.accept(filePath);
            try {
                File file = filePath.getIOFile();
                if (!file.exists() || file.delete()) continue;
                exceptions.add(new VcsException("Unable to delete file: " + filePath));
            }
            catch (Exception exception) {
                exceptions.add(new VcsException("Unable to delete file: " + filePath, (Throwable)exception));
            }
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getRollbackOperationName());){
            for (Map.Entry<VirtualFile, List<FilePath>> entry : toRevert.entrySet()) {
                listener.accept(entry.getValue());
                try {
                    this.revert(entry.getKey(), entry.getValue());
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HashSet<File> hashSet = new HashSet<File>();
        for (Change c : changes) {
            ContentRevision after2;
            ContentRevision before = c.getBeforeRevision();
            if (before != null) {
                hashSet.add(new File(before.getFile().getPath()));
            }
            if ((after2 = c.getAfterRevision()) == null) continue;
            hashSet.add(new File(after2.getFile().getPath()));
        }
        lfs.refreshIoFiles(hashSet);
        for (GitRepository repo : GitUtil.getRepositoryManager(this.myProject).getRepositories()) {
            repo.update();
        }
    }

    public void revert(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(8);
        }
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(9);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private void unindex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean toUnversioned) throws VcsException {
        if (root == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(10);
        }
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(11);
        }
        GitFileUtils.deletePaths(this.myProject, root, files, "--cached", "-f");
        if (toUnversioned) {
            GitRepository repo = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            GitUntrackedFilesHolder untrackedFilesHolder = repo == null ? null : repo.getUntrackedFilesHolder();
            for (FilePath filePath : files) {
                if (untrackedFilesHolder == null) continue;
                untrackedFilesHolder.add(filePath);
            }
        }
    }

    private void registerFile(@NotNull Map<VirtualFile, List<FilePath>> files, @NotNull FilePath file, @NotNull List<? super VcsException> exceptions) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(12);
        }
        if (file == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(13);
        }
        if (exceptions == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(14);
        }
        try {
            VirtualFile root = GitUtil.getRootForFile(this.myProject, file);
            List paths = files.computeIfAbsent(root, key -> new ArrayList());
            paths.add(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    public static void resetHardLocal(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(16);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        Git.getInstance().runCommand(handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rollbackModifiedWithoutCheckout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rollbackMissingFileDeletion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rollbackIfUnchanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unindex";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resetHardLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

