/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLSequence;

public class YAMLHyphenTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(2);
        }
        YAMLHyphenTypedHandler.autoIndentHyphen(c, project, editor, file);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(3);
        }
        return result;
    }

    private static void autoIndentHyphen(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            YAMLHyphenTypedHandler.$$$reportNull$$$0(6);
        }
        if (c != ' ' || !(file instanceof YAMLFile)) {
            return;
        }
        if (!file.isValid()) {
            return;
        }
        int curPosOffset = editor.getCaretModel().getOffset();
        if (curPosOffset < 2) {
            return;
        }
        int offset = curPosOffset - 2;
        Document document = editor.getDocument();
        if (document.getCharsSequence().charAt(offset) != '-') {
            return;
        }
        if (curPosOffset < document.getTextLength() && document.getCharsSequence().charAt(curPosOffset) != '\n') {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement element = file.findElementAt(offset);
        if (PsiUtilCore.getElementType((PsiElement)element) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return;
        }
        PsiElement item = element.getParent();
        if (PsiUtilCore.getElementType((PsiElement)item) != YAMLElementTypes.SEQUENCE_ITEM) {
            return;
        }
        PsiElement sequence = item.getParent();
        if (PsiUtilCore.getElementType((PsiElement)sequence) != YAMLElementTypes.SEQUENCE) {
            return;
        }
        if (((YAMLSequence)sequence).getItems().size() != 1) {
            return;
        }
        DefaultRawTypedHandler handler = ((TypedActionImpl)TypedAction.getInstance()).getDefaultRawTypedHandler();
        handler.beginUndoablePostProcessing();
        ApplicationManager.getApplication().runWriteAction(() -> {
            int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
            editor.getCaretModel().moveToOffset(newOffset + 2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLHyphenTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLHyphenTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "autoIndentHyphen";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

